/*
 * Decompiled with CFR 0.152.
 */
package sun.text.normalizer;

import sun.text.normalizer.UCharacterProperty;
import sun.text.normalizer.UTF16;
import sun.text.normalizer.VersionInfo;

public final class UCharacter {
    public static final int MIN_VALUE = 0;
    public static final int MAX_VALUE = 0x10FFFF;
    public static final int SUPPLEMENTARY_MIN_VALUE = 65536;
    public static final double NO_NUMERIC_VALUE = -1.23456789E8;
    private static final UCharacterProperty PROPERTY_;
    private static final char[] PROPERTY_TRIE_INDEX_;
    private static final char[] PROPERTY_TRIE_DATA_;
    private static final int[] PROPERTY_DATA_;
    private static final int PROPERTY_INITIAL_VALUE_;
    private static final int LAST_CHAR_MASK_ = 65535;
    private static final int SHIFT_24_ = 24;
    private static final int NUMERIC_TYPE_SHIFT_ = 12;
    private static final int NUMERIC_TYPE_MASK_ = 28672;
    private static final int BIDI_SHIFT_ = 6;
    private static final int BIDI_MASK_AFTER_SHIFT_ = 31;
    private static final int NUMERATOR_POWER_LIMIT_ = 0x7FFFFF00;
    private static final int JOINING_TYPE_MASK_ = 14336;
    private static final int JOINING_TYPE_SHIFT_ = 11;
    private static final int JOINING_GROUP_MASK_ = 2016;
    private static final int JOINING_GROUP_SHIFT_ = 5;
    private static final int DECOMPOSITION_TYPE_MASK_ = 31;
    private static final int EAST_ASIAN_MASK_ = 229376;
    private static final int EAST_ASIAN_SHIFT_ = 15;
    private static final int LINE_BREAK_MASK_ = 0x7C0000;
    private static final int LINE_BREAK_SHIFT_ = 18;
    private static final int BLOCK_MASK_ = 32640;
    private static final int BLOCK_SHIFT_ = 7;
    private static final int SCRIPT_MASK_ = 127;

    public static int digit(int n, int n2) {
        int n3;
        int n4 = UCharacter.getProperty(n);
        if (UCharacter.getNumericType(n4) != 1) {
            return n2 <= 10 ? -1 : UCharacter.getEuropeanDigit(n);
        }
        if (UCharacter.isNotExceptionIndicator(n4)) {
            if (n4 >= 0) {
                return UCharacterProperty.getSignedValue(n4);
            }
        } else {
            int n5;
            n3 = UCharacterProperty.getExceptionIndex(n4);
            if (PROPERTY_.hasExceptionValue(n3, 4) && (n5 = PROPERTY_.getException(n3, 4)) >= 0) {
                return n5;
            }
        }
        if (n2 > 10 && (n3 = UCharacter.getEuropeanDigit(n)) >= 0 && n3 < n2) {
            return n3;
        }
        return -1;
    }

    public static double getUnicodeNumericValue(int n) {
        int n2 = PROPERTY_.getProperty(n);
        int n3 = UCharacter.getNumericType(n2);
        if (n3 > 0 && n3 < 4) {
            if (UCharacter.isNotExceptionIndicator(n2)) {
                return UCharacterProperty.getSignedValue(n2);
            }
            int n4 = UCharacterProperty.getExceptionIndex(n2);
            boolean bl = false;
            boolean bl2 = false;
            double d = 0.0;
            if (PROPERTY_.hasExceptionValue(n4, 4)) {
                int n5 = PROPERTY_.getException(n4, 4);
                d = n5 >= 0x7FFFFF00 ? Math.pow(10.0, n5 &= 0xFF) : (double)n5;
                bl = true;
            }
            double d2 = 0.0;
            if (PROPERTY_.hasExceptionValue(n4, 5)) {
                d2 = PROPERTY_.getException(n4, 5);
                if (d != 0.0) {
                    return d / d2;
                }
                bl2 = true;
            }
            if (bl) {
                if (bl2) {
                    return d / d2;
                }
                return d;
            }
            if (bl2) {
                return 1.0 / d2;
            }
        }
        return -1.23456789E8;
    }

    public static int getType(int n) {
        return UCharacter.getProperty(n) & 0x1F;
    }

    public static int getCodePoint(char c, char c2) {
        if (c >= '\ud800' && c <= '\udbff' && c2 >= '\udc00' && c2 <= '\udfff') {
            return UCharacterProperty.getRawSupplementary(c, c2);
        }
        throw new IllegalArgumentException("Illegal surrogate characters");
    }

    public static int getDirection(int n) {
        return UCharacter.getProperty(n) >> 6 & 0x1F;
    }

    public static String foldCase(String string, boolean bl) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = UTF16.charAt(string, n2);
            n2 += UTF16.getCharCount(n4);
            int n5 = PROPERTY_.getProperty(n4);
            if (UCharacter.isNotExceptionIndicator(n5)) {
                n3 = 0x1F & n5;
                if (n3 == 1 || n3 == 3) {
                    n4 += UCharacterProperty.getSignedValue(n5);
                }
            } else {
                n3 = UCharacterProperty.getExceptionIndex(n5);
                if (PROPERTY_.hasExceptionValue(n3, 8)) {
                    int n6 = PROPERTY_.getException(n3, 8);
                    if (n6 != 0) {
                        PROPERTY_.getFoldCase(n6 & 0xFFFF, n6 >> 24, stringBuffer);
                        continue;
                    }
                    if (n4 != 73 && n4 != 304) {
                        UTF16.append(stringBuffer, n4);
                        continue;
                    }
                    if (bl) {
                        if (n4 == 73) {
                            stringBuffer.append('i');
                            continue;
                        }
                        if (n4 != 304) continue;
                        stringBuffer.append('i');
                        stringBuffer.append('\u0307');
                        continue;
                    }
                    if (n4 == 73) {
                        stringBuffer.append('\u0131');
                        continue;
                    }
                    if (n4 != 304) continue;
                    stringBuffer.append('i');
                    continue;
                }
                if (PROPERTY_.hasExceptionValue(n3, 1)) {
                    n4 = PROPERTY_.getException(n3, 1);
                }
            }
            UTF16.append(stringBuffer, n4);
        }
        return stringBuffer.toString();
    }

    public static VersionInfo getAge(int n) {
        if (n < 0 || n > 0x10FFFF) {
            throw new IllegalArgumentException("Codepoint out of bounds");
        }
        return PROPERTY_.getAge(n);
    }

    public static int getIntPropertyValue(int n, int n2) {
        if (n2 == 4107 && n >= 4352) {
            if (n <= 4607) {
                if (n <= 4447) {
                    if (n == 4447 || n <= 4441 || UCharacter.getType(n) == 5) {
                        return 1;
                    }
                } else if (n <= 4519) {
                    if (n <= 4514 || UCharacter.getType(n) == 5) {
                        return 2;
                    }
                } else if (n <= 4601 || UCharacter.getType(n) == 5) {
                    return 3;
                }
            } else if ((n -= 44032) >= 0 && n < 11172) {
                return n % 28 == 0 ? 4 : 5;
            }
        }
        return 0;
    }

    private UCharacter() {
    }

    private static int getEuropeanDigit(int n) {
        if (n > 122 && n < 65313 || n < 65 || n > 90 && n < 97 || n > 65370 || n > 65329 && n < 65345) {
            return -1;
        }
        if (n <= 122) {
            return n + 10 - (n <= 90 ? 65 : 97);
        }
        if (n <= 65338) {
            return n + 10 - 65313;
        }
        return n + 10 - 65345;
    }

    private static int getNumericType(int n) {
        return (n & 0x7000) >> 12;
    }

    private static boolean isNotExceptionIndicator(int n) {
        return (n & 0x20) == 0;
    }

    private static int getProperty(int n) {
        if (n < 55296 || n > 56319 && n < 65536) {
            try {
                return PROPERTY_DATA_[PROPERTY_TRIE_DATA_[(PROPERTY_TRIE_INDEX_[n >> 5] << 2) + (n & 0x1F)]];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return PROPERTY_INITIAL_VALUE_;
            }
        }
        if (n <= 56319) {
            return PROPERTY_DATA_[PROPERTY_TRIE_DATA_[(PROPERTY_TRIE_INDEX_[320 + (n >> 5)] << 2) + (n & 0x1F)]];
        }
        if (n <= 0x10FFFF) {
            return PROPERTY_DATA_[UCharacter.PROPERTY_.m_trie_.getSurrogateValue(UTF16.getLeadSurrogate(n), (char)(n & 0x3FF))];
        }
        return PROPERTY_INITIAL_VALUE_;
    }

    static {
        try {
            PROPERTY_ = UCharacterProperty.getInstance();
            PROPERTY_TRIE_INDEX_ = UCharacter.PROPERTY_.m_trieIndex_;
            PROPERTY_TRIE_DATA_ = UCharacter.PROPERTY_.m_trieData_;
            PROPERTY_DATA_ = UCharacter.PROPERTY_.m_property_;
            PROPERTY_INITIAL_VALUE_ = PROPERTY_DATA_[UCharacter.PROPERTY_.m_trieInitialValue_];
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    public static interface ECharacterCategory {
        public static final int UPPERCASE_LETTER = 1;
        public static final int TITLECASE_LETTER = 3;
        public static final int OTHER_LETTER = 5;
    }

    public static interface HangulSyllableType {
        public static final int NOT_APPLICABLE = 0;
        public static final int LEADING_JAMO = 1;
        public static final int VOWEL_JAMO = 2;
        public static final int TRAILING_JAMO = 3;
        public static final int LV_SYLLABLE = 4;
        public static final int LVT_SYLLABLE = 5;
        public static final int COUNT = 6;
    }

    public static interface NumericType {
        public static final int NONE = 0;
        public static final int DECIMAL = 1;
        public static final int DIGIT = 2;
        public static final int NUMERIC = 3;
        public static final int COUNT = 4;
    }
}

