/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.LocalApplicationProperties;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.javaws.Globals;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.exceptions.FailedDownloadingResourceException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.exceptions.LaunchDescException;
import com.sun.javaws.exceptions.MissingFieldException;
import com.sun.javaws.exceptions.MultipleHostsException;
import com.sun.javaws.exceptions.NativeLibViolationException;
import com.sun.javaws.exceptions.UnsignedAccessViolationException;
import com.sun.javaws.jnl.AppletDesc;
import com.sun.javaws.jnl.ApplicationDesc;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.InstallerDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.PackageDesc;
import com.sun.javaws.jnl.PropertyDesc;
import com.sun.javaws.jnl.ResourceVisitor;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.security.AppPolicy;
import com.sun.javaws.security.SigningInfo;
import java.awt.Component;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class LaunchDownload {
    private static boolean updateAvailable = false;
    private static int _numThread = 0;
    private static JNLPException _exception = null;
    private static Object syncObj = new Object();
    private static final String SIGNED_JNLP_ENTRY = "JNLP-INF/APPLICATION.JNLP";

    public static boolean updateNoHrefLaunchDescInCache(LaunchDesc launchDesc) {
        if (!Cache.isCacheEnabled()) {
            return false;
        }
        URL uRL = launchDesc.getCanonicalHome();
        File file = null;
        try {
            file = DownloadEngine.getCachedFile((URL)uRL);
            if (file == null) {
                Cache.createNoHrefCacheEntry((URL)uRL, (byte[])launchDesc.getBytes());
                return true;
            }
            Trace.println((String)("Loaded descriptor from cache at: " + uRL), (TraceLevel)TraceLevel.BASIC);
            byte[] byArray = LaunchDescFactory.readBytes(new FileInputStream(file), file.length());
            if (launchDesc.hasIdenticalContent(byArray)) {
                return false;
            }
            Cache.createNoHrefCacheEntry((URL)uRL, (byte[])launchDesc.getBytes());
            return true;
        }
        catch (IOException iOException) {
            Trace.ignoredException((Exception)iOException);
            return false;
        }
    }

    public static LaunchDesc getUpdatedLaunchDesc(URL uRL, URL uRL2) throws JNLPException, IOException {
        boolean bl;
        if (uRL == null) {
            return null;
        }
        try {
            bl = DownloadEngine.isUpdateAvailable((URL)uRL, null);
        }
        catch (IOException iOException) {
            Trace.ignored((Throwable)iOException);
            bl = false;
        }
        if (!bl) {
            Trace.println((String)("Update JNLP: no update for: " + uRL), (TraceLevel)TraceLevel.BASIC);
            return null;
        }
        Trace.println((String)("Update JNLP: " + uRL + ", thisCodebase: " + uRL2), (TraceLevel)TraceLevel.BASIC);
        File file = null;
        try {
            DownloadEngine.getResource((URL)uRL, null, null, null, (boolean)true);
            file = DownloadEngine.getCachedFile((URL)uRL);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Trace.ignoredException((Exception)fileNotFoundException);
        }
        if (file != null) {
            LaunchDesc launchDesc = null;
            try {
                launchDesc = LaunchDescFactory.buildDescriptor(file, uRL2, uRL, uRL);
                return launchDesc;
            }
            catch (LaunchDescException launchDescException) {
                launchDesc = LaunchDescFactory.buildDescriptor(file);
                if (launchDesc == null) {
                    throw launchDescException;
                }
                return launchDesc;
            }
        }
        return LaunchDescFactory.buildDescriptor(uRL, uRL);
    }

    public static boolean isJnlpCached(LaunchDesc launchDesc) {
        try {
            return DownloadEngine.isResourceCached((URL)launchDesc.getCanonicalHome(), null, null);
        }
        catch (Exception exception) {
            Trace.ignored((Throwable)exception);
            return false;
        }
    }

    public static boolean isInCache(LaunchDesc launchDesc) {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return true;
        }
        try {
            if (launchDesc.getLocation() != null && !DownloadEngine.isResourceCached((URL)launchDesc.getLocation(), null, null)) {
                return false;
            }
            boolean bl = LaunchDownload.getCachedExtensions(launchDesc);
            if (!bl) {
                return false;
            }
            JARDesc[] jARDescArray = resourcesDesc.getEagerOrAllJarDescs(false);
            for (int i = 0; i < jARDescArray.length; ++i) {
                if (!DownloadEngine.isResourceCached((URL)jARDescArray[i].getLocation(), null, (String)jARDescArray[i].getVersion(), (int)(jARDescArray[i].isNativeLib() ? 272 : 1))) {
                    return false;
                }
                if (!DownloadEngine.isJarFileCorrupted((URL)jARDescArray[i].getLocation(), (String)jARDescArray[i].getVersion())) continue;
                DownloadEngine.removeCachedResource((URL)jARDescArray[i].getLocation(), null, (String)jARDescArray[i].getVersion());
                return false;
            }
        }
        catch (JNLPException jNLPException) {
            Trace.ignoredException((Exception)jNLPException);
            return false;
        }
        catch (IOException iOException) {
            Trace.ignoredException((Exception)iOException);
            return false;
        }
        return true;
    }

    private static void updateCheck(URL uRL, String string, boolean bl) {
        LaunchDownload.updateCheck(uRL, string, bl, false);
    }

    private static void updateCheck(URL uRL, String string, boolean bl, boolean bl2) {
        LaunchDownload.updateCheck(uRL, string, bl, bl2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateCheck(final URL uRL, final String string, boolean bl, final boolean bl2, final boolean bl3) {
        if (string != null) {
            return;
        }
        Object object = syncObj;
        synchronized (object) {
            ++_numThread;
        }
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                FailedDownloadingResourceException failedDownloadingResourceException = null;
                try {
                    boolean bl = DownloadEngine.isUpdateAvailable((URL)uRL, (String)string, (boolean)bl3);
                    if (bl2 && bl) {
                        Globals.setIconImageUpdated(true);
                    }
                    Object object = syncObj;
                    synchronized (object) {
                        if (bl && !updateAvailable) {
                            updateAvailable = true;
                        }
                    }
                }
                catch (IOException iOException) {
                    try {
                        failedDownloadingResourceException = new FailedDownloadingResourceException(uRL, string, iOException);
                    }
                    catch (Throwable throwable) {
                        Object object = syncObj;
                        synchronized (object) {
                            if (_exception == null) {
                                _exception = failedDownloadingResourceException;
                            }
                            _numThread--;
                        }
                        throw throwable;
                    }
                    Object object = syncObj;
                    synchronized (object) {
                        if (_exception == null) {
                            _exception = failedDownloadingResourceException;
                        }
                        _numThread--;
                    }
                }
                Object object = syncObj;
                synchronized (object) {
                    if (_exception == null) {
                        _exception = failedDownloadingResourceException;
                    }
                    _numThread--;
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isUpdateAvailable(LaunchDesc launchDesc) throws JNLPException {
        Object object;
        ResourcesDesc resourcesDesc;
        URL uRL = launchDesc.getLocation();
        if (uRL != null) {
            try {
                boolean bl = DownloadEngine.isUpdateAvailable((URL)uRL, null);
                if (bl) {
                    return true;
                }
            }
            catch (IOException iOException) {
                throw new FailedDownloadingResourceException(uRL, null, iOException);
            }
        }
        if ((resourcesDesc = launchDesc.getResources()) == null) {
            return false;
        }
        ExtensionDesc[] extensionDescArray = resourcesDesc.getExtensionDescs();
        for (int i = 0; i < extensionDescArray.length; ++i) {
            URL uRL2 = extensionDescArray[i].getLocation();
            if (uRL2 == null) continue;
            LaunchDownload.updateCheck(uRL2, extensionDescArray[i].getVersion(), false);
        }
        JARDesc[] jARDescArray = resourcesDesc.getEagerOrAllJarDescs(true);
        for (int i = 0; i < jARDescArray.length; ++i) {
            URL uRL3 = jARDescArray[i].getLocation();
            object = jARDescArray[i].getVersion();
            try {
                if (!DownloadEngine.isResourceCached((URL)uRL3, null, (String)object)) continue;
                LaunchDownload.updateCheck(uRL3, (String)object, jARDescArray[i].isLazyDownload(), false, jARDescArray[i].isPack200Enabled());
                continue;
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
        IconDesc[] iconDescArray = launchDesc.getInformation().getIcons();
        if (iconDescArray != null) {
            for (int i = 0; i < iconDescArray.length; ++i) {
                object = iconDescArray[i].getLocation();
                String string = iconDescArray[i].getVersion();
                try {
                    if (DownloadEngine.getCachedFile((URL)object, (String)string) == null) continue;
                    LaunchDownload.updateCheck((URL)object, string, false, true);
                    continue;
                }
                catch (IOException iOException) {
                    Trace.ignoredException((Exception)iOException);
                }
            }
        }
        while (_numThread > 0) {
            Object object2 = syncObj;
            synchronized (object2) {
                if (updateAvailable) {
                    break;
                }
                if (_exception != null) {
                    throw _exception;
                }
            }
        }
        return updateAvailable;
    }

    public static File[] getNativeDirectories(LaunchDesc launchDesc) {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return new File[0];
        }
        JARDesc[] jARDescArray = resourcesDesc.getEagerOrAllJarDescs(true);
        ArrayList<File> arrayList = new ArrayList<File>();
        for (int i = 0; i < jARDescArray.length; ++i) {
            JarFile jarFile;
            String string;
            URL uRL;
            block8: {
                if (!jARDescArray[i].isNativeLib()) continue;
                uRL = jARDescArray[i].getLocation();
                string = jARDescArray[i].getVersion();
                jarFile = null;
                try {
                    jarFile = DownloadEngine.getUpdatedJarFile((URL)uRL, (String)string, (int)272);
                }
                catch (IOException iOException) {
                    Trace.ignoredException((Exception)iOException);
                    if (!launchDesc.getInformation().supportsOfflineOperation()) break block8;
                    try {
                        jarFile = DownloadEngine.getCachedJarFile((URL)uRL, (String)string);
                    }
                    catch (IOException iOException2) {
                        Trace.ignoredException((Exception)iOException2);
                    }
                }
            }
            if (jarFile == null) continue;
            try {
                File file = DownloadEngine.getCachedFile((URL)uRL, (String)string);
                if (file == null) continue;
                String string2 = file.getPath();
                arrayList.add(new File(string2 + "-n"));
                continue;
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
        File[] fileArray = new File[arrayList.size()];
        return arrayList.toArray(fileArray);
    }

    public static void downloadExtensions(LaunchDesc launchDesc, DownloadProgress downloadProgress, int n, ArrayList arrayList) throws IOException, JNLPException {
        LaunchDownload.downloadExtensionsHelper(launchDesc, downloadProgress, n, false, arrayList);
    }

    public static boolean getCachedExtensions(LaunchDesc launchDesc) throws IOException, JNLPException {
        return LaunchDownload.downloadExtensionsHelper(launchDesc, null, 0, true, null);
    }

    private static boolean downloadExtensionsHelper(LaunchDesc launchDesc, DownloadProgress downloadProgress, int n, boolean bl, ArrayList arrayList) throws IOException, JNLPException {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return true;
        }
        String string = JREInfo.getKnownPlatforms();
        final ArrayList arrayList2 = new ArrayList();
        resourcesDesc.visit(new ResourceVisitor(){

            public void visitJARDesc(JARDesc jARDesc) {
            }

            public void visitPropertyDesc(PropertyDesc propertyDesc) {
            }

            public void visitPackageDesc(PackageDesc packageDesc) {
            }

            public void visitJREDesc(JREDesc jREDesc) {
            }

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                arrayList2.add(extensionDesc);
            }
        });
        n += arrayList2.size();
        for (int i = 0; i < arrayList2.size(); ++i) {
            int n2;
            ExtensionDesc extensionDesc = (ExtensionDesc)arrayList2.get(i);
            String string2 = extensionDesc.getName();
            if (string2 == null && (n2 = (string2 = extensionDesc.getLocation().toString()).lastIndexOf(47)) > 0) {
                string2 = string2.substring(n2 + 1, string2.length());
            }
            --n;
            if (downloadProgress != null) {
                downloadProgress.extensionDownload(string2, n);
            }
            File file = DownloadEngine.getCachedFile((URL)extensionDesc.getLocation(), (String)extensionDesc.getVersion(), (!bl ? 1 : 0) != 0, (boolean)false, (String)JREInfo.getKnownPlatforms());
            Trace.println((String)("Downloaded extension: " + extensionDesc.getLocation() + "\n\tcodebase: " + extensionDesc.getCodebase() + "\n\tld parentCodebase: " + launchDesc.getCodebase() + "\n\tfile: " + file), (TraceLevel)TraceLevel.NETWORK);
            if (file == null) {
                return false;
            }
            LaunchDesc launchDesc2 = LaunchDescFactory.buildDescriptor(file, extensionDesc.getCodebase(), extensionDesc.getLocation(), extensionDesc.getLocation());
            boolean bl2 = false;
            if (launchDesc2.getLaunchType() == 3) {
                bl2 = true;
            } else if (launchDesc2.getLaunchType() == 4) {
                extensionDesc.setInstaller(true);
                LocalApplicationProperties localApplicationProperties = Cache.getLocalApplicationProperties((URL)extensionDesc.getLocation(), (String)extensionDesc.getVersion(), (boolean)false);
                boolean bl3 = bl2 = !localApplicationProperties.isLocallyInstalled();
                if (arrayList != null && (LaunchDownload.isUpdateAvailable(launchDesc2) || bl2)) {
                    arrayList.add(file);
                }
                if (bl && bl2) {
                    return false;
                }
            } else {
                throw new MissingFieldException(launchDesc2.getSource(), "<component-desc>|<installer-desc>");
            }
            if (!bl2) continue;
            extensionDesc.setExtensionDesc(launchDesc2);
            boolean bl4 = LaunchDownload.downloadExtensionsHelper(launchDesc2, downloadProgress, n, bl, arrayList);
            if (bl4) continue;
            return false;
        }
        return true;
    }

    public static void downloadJRE(LaunchDesc launchDesc, DownloadProgress downloadProgress, ArrayList arrayList) throws JNLPException, IOException {
        File file;
        LaunchDesc launchDesc2;
        String string;
        boolean bl;
        JREDesc jREDesc = launchDesc.getResources().getSelectedJRE();
        String string2 = jREDesc.getVersion();
        URL uRL = jREDesc.getHref();
        boolean bl2 = bl = uRL == null;
        if (uRL == null && (string = Config.getProperty((String)"deployment.javaws.installURL")) != null) {
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (downloadProgress != null) {
            downloadProgress.jreDownload(string2, uRL);
        }
        if ((launchDesc2 = LaunchDescFactory.buildDescriptor(file = DownloadEngine.getUpdatedFile((URL)uRL, (String)string2, (boolean)bl, (String)(string = JREInfo.getKnownPlatforms())), null, null, null)).getLaunchType() != 4) {
            throw new MissingFieldException(launchDesc2.getSource(), "<installer-desc>");
        }
        if (arrayList != null) {
            arrayList.add(file);
        }
        jREDesc.setExtensionDesc(launchDesc2);
        LaunchDownload.downloadExtensionsHelper(launchDesc2, downloadProgress, 0, false, arrayList);
    }

    public static void downloadResource(LaunchDesc launchDesc, URL uRL, String string, DownloadProgress downloadProgress, boolean bl) throws IOException, JNLPException {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        JARDesc[] jARDescArray = resourcesDesc.getResource(uRL, string);
        LaunchDownload.downloadJarFiles(jARDescArray, downloadProgress, bl);
    }

    public static void downloadParts(LaunchDesc launchDesc, String[] stringArray, DownloadProgress downloadProgress, boolean bl) throws IOException, JNLPException {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        JARDesc[] jARDescArray = resourcesDesc.getPartJars(stringArray);
        LaunchDownload.downloadJarFiles(jARDescArray, downloadProgress, bl);
    }

    public static void downloadExtensionPart(LaunchDesc launchDesc, URL uRL, String string, String[] stringArray, DownloadProgress downloadProgress, boolean bl) throws IOException, JNLPException {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        JARDesc[] jARDescArray = resourcesDesc.getExtensionPart(uRL, string, stringArray);
        LaunchDownload.downloadJarFiles(jARDescArray, downloadProgress, bl);
    }

    public static void downloadEagerorAll(LaunchDesc launchDesc, boolean bl, DownloadProgress downloadProgress, boolean bl2) throws IOException, JNLPException {
        Object object;
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        JARDesc[] jARDescArray = resourcesDesc.getEagerOrAllJarDescs(bl);
        if (!bl && ((JARDesc[])(object = resourcesDesc.getEagerOrAllJarDescs(true))).length != jARDescArray.length) {
            HashSet<JARDesc> hashSet = new HashSet<JARDesc>(Arrays.asList(jARDescArray));
            int n = 0;
            for (int i = 0; i < ((Object)object).length; ++i) {
                URL uRL = ((JARDesc)object[i]).getLocation();
                String string = ((JARDesc)object[i]).getVersion();
                if (!hashSet.contains(object[i]) && DownloadEngine.getCachedJarFile((URL)uRL, (String)string) != null) {
                    if (((JARDesc)object[i]).isLazyDownload()) {
                        boolean bl3 = DownloadEngine.isUpdateAvailable((URL)uRL, (String)string, (boolean)((JARDesc)object[i]).isPack200Enabled());
                        if (bl3) {
                            DownloadEngine.removeCachedResource((URL)uRL, null, (String)string);
                        }
                        object[i] = null;
                        continue;
                    }
                    ++n;
                    continue;
                }
                object[i] = null;
            }
            if (n > 0) {
                JARDesc[] jARDescArray2 = new JARDesc[jARDescArray.length + n];
                System.arraycopy(jARDescArray, 0, jARDescArray2, 0, jARDescArray.length);
                int n2 = jARDescArray.length;
                for (int i = 0; i < ((Object)object).length; ++i) {
                    if (object[i] == null) continue;
                    jARDescArray2[n2++] = object[i];
                }
                jARDescArray = jARDescArray2;
            }
        }
        LaunchDownload.downloadJarFiles(jARDescArray, downloadProgress, bl2);
        object = launchDesc.getInformation().getIconLocation(1, 0);
        if (object != null) {
            try {
                DownloadEngine.getResource((URL)((IconDesc)object).getLocation(), null, (String)((IconDesc)object).getVersion(), null, (boolean)true, (int)1);
                Trace.println((String)("Downloaded " + ((IconDesc)object).getLocation()), (TraceLevel)TraceLevel.NETWORK);
            }
            catch (Exception exception) {
                Trace.ignored((Throwable)exception);
            }
        }
    }

    public static void reverse(JARDesc[] jARDescArray) {
        int n = 0;
        for (int i = jARDescArray.length - 1; n < i; ++n, --i) {
            JARDesc jARDesc = jARDescArray[n];
            jARDescArray[n] = jARDescArray[i];
            jARDescArray[i] = jARDesc;
        }
    }

    private static void downloadJarFiles(JARDesc[] jARDescArray, DownloadProgress downloadProgress, boolean bl) throws JNLPException, IOException {
        if (jARDescArray == null) {
            return;
        }
        if (Globals.isReverseMode()) {
            LaunchDownload.reverse(jARDescArray);
        }
        long l = -1L;
        for (int i = 0; i < jARDescArray.length && l != -1L; ++i) {
            JARDesc jARDesc = jARDescArray[i];
            long l2 = jARDesc.getSize();
            if (l2 == 0L) {
                l2 = -1L;
            }
            Trace.println((String)("Size of " + jARDescArray[i].getLocation() + ": " + l2), (TraceLevel)TraceLevel.NETWORK);
            if (l2 == -1L) {
                l = -1L;
                continue;
            }
            l += l2;
        }
        Trace.println((String)("Total size to download: " + l), (TraceLevel)TraceLevel.NETWORK);
        if (l == 0L) {
            return;
        }
        DownloadCallbackHelper downloadCallbackHelper = new DownloadCallbackHelper(downloadProgress, l);
        downloadCallbackHelper.setNumOfJars(jARDescArray.length);
        int n = 0;
        for (int i = 0; i < jARDescArray.length; ++i) {
            JARDesc jARDesc = jARDescArray[i];
            try {
                int n2 = 256;
                if (jARDesc.isNativeLib()) {
                    n2 |= 0x10;
                }
                if (jARDesc.isPack200Enabled()) {
                    n2 |= 0x1000;
                }
                if (jARDesc.isVersionEnabled()) {
                    n2 |= 0x10000;
                }
                URL uRL = DownloadEngine.getResource((URL)jARDescArray[i].getLocation(), null, (String)jARDescArray[i].getVersion(), (DownloadEngine.DownloadDelegate)downloadCallbackHelper, (boolean)true, (int)n2);
                Trace.println((String)("Downloaded " + jARDescArray[i].getLocation() + ": " + uRL), (TraceLevel)TraceLevel.NETWORK);
                downloadCallbackHelper.setJarsDone(++n);
                if (!Cache.isCacheEnabled() || uRL != null || Environment.isImportMode()) continue;
                throw new FailedDownloadingResourceException(null, jARDescArray[i].getLocation(), jARDescArray[i].getVersion(), null);
            }
            catch (JNLPException jNLPException) {
                if (downloadProgress != null) {
                    downloadProgress.downloadFailed(jARDesc.getLocation(), jARDesc.getVersion());
                }
                throw jNLPException;
            }
        }
    }

    public static void checkJNLPSecurity(LaunchDesc launchDesc) throws MultipleHostsException, NativeLibViolationException {
        boolean[] blArray = new boolean[1];
        boolean[] blArray2 = new boolean[1];
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        JARDesc jARDesc = launchDesc.getResources().getMainJar(true);
        if (jARDesc == null) {
            return;
        }
        LaunchDownload.checkJNLPSecurityHelper(launchDesc, jARDesc.getLocation().getHost(), blArray2, blArray);
        if (blArray2[0]) {
            throw new MultipleHostsException();
        }
        if (blArray[0]) {
            throw new NativeLibViolationException();
        }
    }

    private static void checkJNLPSecurityHelper(LaunchDesc launchDesc, final String string, final boolean[] blArray, final boolean[] blArray2) {
        if (launchDesc.getSecurityModel() != 0) {
            return;
        }
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        resourcesDesc.visit(new ResourceVisitor(){

            public void visitJARDesc(JARDesc jARDesc) {
                String string2 = jARDesc.getLocation().getHost();
                blArray[0] = blArray[0] || !string.equals(string2);
                blArray2[0] = blArray2[0] || jARDesc.isNativeLib();
            }

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                if (!blArray[0] && !blArray2[0]) {
                    LaunchDesc launchDesc = extensionDesc.getExtensionDesc();
                    String string2 = extensionDesc.getLocation().getHost();
                    if (launchDesc != null && launchDesc.getSecurityModel() == 0 && !blArray[0]) {
                        LaunchDownload.checkJNLPSecurityHelper(launchDesc, string2, blArray, blArray2);
                    }
                }
            }

            public void visitPropertyDesc(PropertyDesc propertyDesc) {
            }

            public void visitPackageDesc(PackageDesc packageDesc) {
            }

            public void visitJREDesc(JREDesc jREDesc) {
            }
        });
    }

    public static long getCachedSize(LaunchDesc launchDesc) {
        long l = 0L;
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return l;
        }
        JARDesc[] jARDescArray = resourcesDesc.getEagerOrAllJarDescs(true);
        for (int i = 0; i < jARDescArray.length; ++i) {
            try {
                l += DownloadEngine.getCachedSize((URL)jARDescArray[i].getLocation(), null, (String)jARDescArray[i].getVersion(), null, (boolean)false);
                continue;
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
        IconDesc[] iconDescArray = launchDesc.getInformation().getIcons();
        if (iconDescArray != null) {
            for (int i = 0; i < iconDescArray.length; ++i) {
                try {
                    l += DownloadEngine.getCachedSize((URL)iconDescArray[i].getLocation(), null, (String)iconDescArray[i].getVersion(), null, (boolean)false);
                    continue;
                }
                catch (IOException iOException) {
                    Trace.ignoredException((Exception)iOException);
                }
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getMainClassName(LaunchDesc launchDesc, boolean bl) throws IOException, JNLPException, LaunchDescException {
        AppletDesc appletDesc;
        InstallerDesc installerDesc;
        String string = null;
        ApplicationDesc applicationDesc = launchDesc.getApplicationDescriptor();
        if (applicationDesc != null) {
            string = applicationDesc.getMainClass();
        }
        if ((installerDesc = launchDesc.getInstallerDescriptor()) != null) {
            string = installerDesc.getMainClass();
        }
        if ((appletDesc = launchDesc.getAppletDescriptor()) != null) {
            string = appletDesc.getAppletClass();
        }
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (string != null) {
            return string;
        }
        if (launchDesc.getResources() == null) {
            return null;
        }
        JARDesc jARDesc = launchDesc.getResources().getMainJar(bl);
        if (jARDesc == null) {
            return null;
        }
        ZipFile zipFile = null;
        try {
            Object object;
            zipFile = new JarFile(DownloadEngine.getCachedResourceFilePath((URL)jARDesc.getLocation(), (String)jARDesc.getVersion()), false);
            if (zipFile != null && string == null && launchDesc.getLaunchType() != 2) {
                object = ((JarFile)zipFile).getManifest();
                String string2 = string = object != null ? ((Manifest)object).getMainAttributes().getValue("Main-Class") : null;
            }
            if (string == null) {
                throw new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.nomainclassspec"), null);
            }
            object = string.replace('.', '/') + ".class";
            if (((JarFile)zipFile).getEntry((String)object) == null) {
                throw new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.nomainclass", (String)string, (String)jARDesc.getLocation().toString()), null);
            }
            String string3 = string;
            return string3;
        }
        finally {
            if (zipFile != null) {
                zipFile.close();
            }
        }
    }

    public static void checkSignedLaunchDesc(LaunchDesc launchDesc) throws IOException, JNLPException {
        ArrayList arrayList = new ArrayList();
        LaunchDownload.addExtensions(arrayList, launchDesc);
        for (int i = 0; i < arrayList.size(); ++i) {
            LaunchDesc launchDesc2 = (LaunchDesc)arrayList.get(i);
            LaunchDownload.checkSignedLaunchDescHelper(launchDesc2);
        }
    }

    public static boolean checkSignedResources(LaunchDesc launchDesc) throws IOException, JNLPException, ExitException {
        ArrayList arrayList = new ArrayList();
        LaunchDownload.addExtensions(arrayList, launchDesc);
        boolean bl = true;
        for (int i = 0; i < arrayList.size(); ++i) {
            LaunchDesc launchDesc2 = (LaunchDesc)arrayList.get(i);
            bl = LaunchDownload.checkSignedResourcesHelper(launchDesc2) && bl;
        }
        return bl;
    }

    private static void addExtensions(final ArrayList arrayList, LaunchDesc launchDesc) {
        arrayList.add(launchDesc);
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc != null) {
            resourcesDesc.visit(new ResourceVisitor(){

                public void visitJARDesc(JARDesc jARDesc) {
                }

                public void visitPropertyDesc(PropertyDesc propertyDesc) {
                }

                public void visitPackageDesc(PackageDesc packageDesc) {
                }

                public void visitJREDesc(JREDesc jREDesc) {
                }

                public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                    if (!extensionDesc.isInstaller()) {
                        LaunchDownload.addExtensions(arrayList, extensionDesc.getExtensionDesc());
                    }
                }
            });
        }
    }

    private static void checkSignedLaunchDescHelper(LaunchDesc launchDesc) throws IOException, JNLPException {
        boolean bl = launchDesc.isApplicationDescriptor();
        byte[] byArray = null;
        try {
            byArray = LaunchDownload.getSignedJNLPFile(launchDesc, bl);
            if (byArray != null) {
                LaunchDesc launchDesc2 = LaunchDescFactory.buildDescriptor(byArray, null, launchDesc.getLocation(), launchDesc.getLocation());
                Trace.println((String)"Signed JNLP file: ", (TraceLevel)TraceLevel.BASIC);
                Trace.println((String)launchDesc2.toString(), (TraceLevel)TraceLevel.BASIC);
                launchDesc.checkSigning(launchDesc2);
                byArray = null;
            }
        }
        catch (LaunchDescException launchDescException) {
            launchDescException.setIsSignedLaunchDesc();
            throw launchDescException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (JNLPException jNLPException) {
            throw jNLPException;
        }
    }

    private static boolean checkSignedResourcesHelper(LaunchDesc launchDesc) throws IOException, JNLPException, ExitException {
        Object object;
        JARDesc jARDesc;
        int n;
        boolean bl;
        Object object2;
        if (launchDesc.isSecure()) {
            return launchDesc.isSecureJVMArgs();
        }
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return true;
        }
        JARDesc[] jARDescArray = resourcesDesc.getLocalJarDescs();
        boolean bl2 = true;
        boolean bl3 = true;
        List list = null;
        URL uRL = launchDesc.getCanonicalHome();
        int n2 = 0;
        URL uRL2 = null;
        SigningInfo signingInfo = null;
        Map map = null;
        if (launchDesc.getLocation() != null) {
            object2 = launchDesc.getSourceURL();
            if (object2 == null) {
                object2 = launchDesc.getLocation();
            }
            signingInfo = new SigningInfo((URL)object2, launchDesc.getVersion());
            map = signingInfo.getTrustedEntries();
        }
        object2 = new SigningInfo[jARDescArray.length];
        HashMap<Object, Long> hashMap = new HashMap<Object, Long>();
        boolean bl4 = false;
        if (map == null) {
            bl = false;
            Trace.println((String)("Empty trusted set for [" + uRL + "]"), (TraceLevel)TraceLevel.SECURITY);
        } else {
            bl = true;
        }
        for (n = 0; !bl4 && n < jARDescArray.length; ++n) {
            jARDesc = jARDescArray[n];
            object2[n] = new SigningInfo(jARDesc.getLocation(), jARDesc.getVersion());
            if (object2[n].canBeSkipped()) continue;
            if (object2[n].isKnownToBeValidated()) {
                long l = object2[n].getCachedVerificationTimestampt();
                String string = jARDesc.getLocation().toString();
                if (!object2[n].isKnownToBeSigned()) {
                    throw new UnsignedAccessViolationException(launchDesc, jARDesc.getLocation(), true);
                }
                if (bl && ((object = (Long)map.get(string)) == null || (Long)object != l)) {
                    Trace.println((String)("Entry [" + string + ", " + object + "] does not match trusted set. Revert to full validation of JNLP."), (TraceLevel)TraceLevel.SECURITY);
                    bl = false;
                }
                hashMap.put(string, new Long(l));
                continue;
            }
            bl4 = true;
            bl = false;
            Trace.println((String)("Entry [" + jARDesc.getLocation().toString() + "] is not prevalidated. Revert to full validation of this JAR."), (TraceLevel)TraceLevel.SECURITY);
        }
        if (!bl) {
            for (n = 0; n < jARDescArray.length && bl3; ++n) {
                jARDesc = jARDescArray[n];
                if (object2[n] == null) {
                    object2[n] = new SigningInfo(jARDesc.getLocation(), jARDesc.getVersion());
                }
                if (object2[n].canBeSkipped()) continue;
                List list2 = null;
                list2 = object2[n].isKnownToBeValidated() ? object2[n].getCertificates() : object2[n].check();
                if (list2 == null) {
                    bl2 = false;
                    uRL2 = jARDesc.getLocation();
                    if (launchDesc.getSecurityModel() == 0) break;
                    DownloadEngine.removeCachedResource((URL)jARDesc.getLocation(), null, (String)jARDesc.getVersion());
                    break;
                }
                if (list == null) {
                    list = list2;
                } else {
                    list = SigningInfo.overlapChainLists(list2, list);
                    Trace.println((String)("Have " + (list == null ? 0 : list.size()) + " common certificates after processing " + jARDesc.getLocation()), (TraceLevel)TraceLevel.SECURITY);
                    if (list == null) {
                        bl3 = false;
                        if (launchDesc.getSecurityModel() != 0) {
                            DownloadEngine.removeCachedResource((URL)jARDesc.getLocation(), null, (String)jARDesc.getVersion());
                        }
                    }
                }
                long l = object2[n].getCachedVerificationTimestampt();
                object = jARDesc.getLocation().toString();
                hashMap.put(object, new Long(l));
                ++n2;
            }
            if (!launchDesc.isSecure()) {
                if (!bl2) {
                    throw new UnsignedAccessViolationException(launchDesc, uRL2, true);
                }
                if (!bl3) {
                    throw new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.singlecertviolation"), null);
                }
                if (n2 > 0) {
                    long l;
                    CodeSource codeSource = null;
                    codeSource = Globals.isJavaVersionAtLeast15() ? new CodeSource(launchDesc.getLocation(), list.toArray(new CodeSigner[0])) : new CodeSource(launchDesc.getLocation(), SigningInfo.toCertificateArray(list));
                    if (bl) {
                        launchDesc.setTrusted();
                    }
                    if ((l = AppPolicy.getInstance().grantUnrestrictedAccess(launchDesc, codeSource)) > 0L) {
                        for (int i = 0; i < ((SigningInfo[])object2).length; ++i) {
                            object2[i].updateCacheIfNeeded(true, null, System.currentTimeMillis(), l);
                        }
                        if (signingInfo != null) {
                            signingInfo.updateCache(true, hashMap, System.currentTimeMillis(), l);
                        }
                    }
                    bl = true;
                } else {
                    if (signingInfo != null) {
                        signingInfo.updateCache(true, hashMap, System.currentTimeMillis(), Long.MAX_VALUE);
                    }
                    bl = true;
                }
            }
        }
        if (bl) {
            launchDesc.setTrusted();
        }
        Trace.println((String)("LD - All JAR files signed: " + uRL), (TraceLevel)TraceLevel.BASIC);
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getSignedJNLPFile(LaunchDesc launchDesc, boolean bl) throws IOException, JNLPException {
        if (launchDesc.getResources() == null) {
            return null;
        }
        JARDesc jARDesc = launchDesc.getResources().getMainJar(bl);
        if (jARDesc == null) {
            return null;
        }
        ZipFile zipFile = null;
        try {
            Object object;
            Object object2;
            zipFile = new JarFile(DownloadEngine.getCachedResourceFilePath((URL)jARDesc.getLocation(), (String)jARDesc.getVersion()), false);
            Object object3 = ((JarFile)zipFile).getJarEntry(SIGNED_JNLP_ENTRY);
            if (object3 == null) {
                object2 = ((JarFile)zipFile).entries();
                while (object2.hasMoreElements() && object3 == null) {
                    object = (JarEntry)object2.nextElement();
                    if (!((ZipEntry)object).getName().equalsIgnoreCase(SIGNED_JNLP_ENTRY)) continue;
                    object3 = object;
                }
            }
            if (object3 == null) {
                object2 = null;
                return object2;
            }
            object2 = new byte[(int)((ZipEntry)object3).getSize()];
            object = new DataInputStream(((JarFile)zipFile).getInputStream((ZipEntry)object3));
            ((DataInputStream)object).readFully((byte[])object2, 0, (int)((ZipEntry)object3).getSize());
            ((FilterInputStream)object).close();
            Object object4 = object2;
            return object4;
        }
        finally {
            if (zipFile != null) {
                zipFile.close();
            }
        }
    }

    private static class DownloadCallbackHelper
    implements DownloadEngine.DownloadDelegate {
        DownloadProgress _downloadProgress;
        long _totalSize;
        long _downloadedSoFar;
        long _currentTotal;
        int _numOfJars = 0;
        int _jarsDone = 0;

        public DownloadCallbackHelper(DownloadProgress downloadProgress, long l) {
            this._downloadProgress = downloadProgress;
            this._totalSize = l;
            this._downloadedSoFar = 0L;
        }

        public void setTotalSize(long l) {
            this._totalSize = l;
        }

        public void setNumOfJars(int n) {
            this._numOfJars = n;
        }

        public void setJarsDone(int n) {
            this._jarsDone = n;
        }

        public void downloading(URL uRL, String string, int n, int n2, boolean bl) {
            int n3 = -1;
            double d = 0.0;
            double d2 = 0.0;
            d = 100.0 / (double)this._numOfJars * ((double)n / (double)n2);
            d2 = (double)this._jarsDone * (100.0 / (double)this._numOfJars);
            n3 = (int)(d + d2 + 0.5);
            if (this._downloadProgress != null) {
                this._downloadProgress.progress(uRL, string, this._downloadedSoFar + (long)n, this._totalSize, n3);
            }
        }

        public void patching(URL uRL, String string, int n) {
            int n2 = -1;
            if (this._totalSize != -1L) {
                double d = (double)this._downloadedSoFar + (double)this._currentTotal * (0.8 + (double)n / 1000.0);
                n2 = this.getPercent(d);
            }
            if (this._downloadProgress != null) {
                this._downloadProgress.patching(uRL, string, n, n2);
            }
        }

        public void validating(URL uRL, int n, int n2) {
            int n3 = -1;
            if (this._totalSize != -1L && n2 != 0) {
                double d = (double)this._downloadedSoFar + 0.9 * (double)this._currentTotal + 0.1 * (double)this._currentTotal * ((double)n / (double)n2);
                n3 = this.getPercent(d);
            }
            if (this._downloadProgress != null) {
                this._downloadProgress.validating(uRL, null, n, n2, n3);
            }
            if (n == n2) {
                this._downloadedSoFar += this._currentTotal;
            }
        }

        public void downloadFailed(URL uRL, String string) {
            if (this._downloadProgress != null) {
                this._downloadProgress.downloadFailed(uRL, string);
            }
        }

        private int getPercent(double d) {
            if (d > (double)this._totalSize) {
                this._totalSize = -1L;
                return -1;
            }
            double d2 = d * 100.0 / (double)this._totalSize;
            return (int)(d2 + 0.5);
        }
    }

    public static interface DownloadProgress {
        public void jreDownload(String var1, URL var2);

        public void extensionDownload(String var1, int var2);

        public void progress(URL var1, String var2, long var3, long var5, int var7);

        public void validating(URL var1, String var2, long var3, long var5, int var7);

        public void patching(URL var1, String var2, int var3, int var4);

        public void downloadFailed(URL var1, String var2);
    }

    public static interface DownloadProgressWindow
    extends DownloadProgress {
        public void setHeading(String var1, boolean var2);

        public void setStatus(String var1);

        public Component getOwner();

        public void setVisible(boolean var1);

        public void setProgressBarVisible(boolean var1);

        public void setProgressBarValue(int var1);

        public void showLaunchingApplication(String var1);
    }
}

