;Control program for 2256 Mhz local oscillator
;
;This file is called "2256VER2.ASM" Last revised 12-26-06 14:50
;
;Sets compare frequency to 2 Mhz and output to 2256 Mhz
;
;Charge pump current is 1.00 mA
;
;
#include	"p16f84.inc"

		list p=16f84a

;
;Define registers

#define	synpoint		H'008'		;points to current synth data
#define	datalen		H'009'		;# of bits in current data seq
#define	bitctr		H'00A'		;counts off bits in byte
#define	wordctr		H'00B'		;counts off synth data words
#define	charbuff		H'00C'		;store for synth data characters
;
;Define connections to PLL IC
;

#define	syndata		PORTA,1		;data
#define	synclk		PORTA,2		;clock
#define	synle			PORTA,0		;load enable

;
;Set the reset vector to point to program start
;
		org	H'1FF'
		goto	start

;
;Program starts here
;

		org	0

;
;Configure port A for input and clear FSR
;

start		movlw	0		;set portA as output
		tris	PORTA
		clrf	FSR

;
;Reset the PLL and set to chan 1  (2256 MHz)
;

		;
		;First put PLL in reset mode
		;

		movlw	D'20'		;set data length count
		movwf	datalen
		movlw	reset1-table	;point to reset1 data
		movwf	synpoint
		call	synthdata

		;
		;Then set the reference divider
		;

		movlw	D'21'
		movwf	datalen
		movlw	rcount-table	;point to R counter data
		movwf	synpoint
		call 	synthdata

		;
		;Then set to 2256 MHz
		;

		movlw	D'21'
		movwf	datalen
		movlw	ch1-table	;point to channel 1 data (2256 Mhz)
		movwf	synpoint
		call	synthdata

		;
		;Return from reset mode
		;

		movlw	D'20'
		movwf	datalen
		movlw	reset2-table
		movwf	synpoint
		call 	synthdata

loop		nop
		goto loop		;endless loop

; ------ subroutine -----------
;Send channel or reset data to the synthesizer.
;Following code is entered with synpoint & datalen set to proper values
;

synthdata	bcf	synclk	;clear clock bit
		bcf	synle		;clear load enable

synthdata1	movlw	D'8'		;set bit counter
		movwf	bitctr
		movf	synpoint,0	;put table offset pointer in W
		call	getdata	;get character from table
		movwf	charbuff	;temp store data byte
		incf	synpoint,1	;point to next data byte

synthdata2	btfsc	charbuff,7	;check if msb clear..
		goto	synthdata3	;if not go and set data bit..
		bcf	syndata	;else clear data bit..
		goto	synthdata4	;and then send data bit

synthdata3	bsf	syndata	;set data bit

synthdata4	nop
		bsf	synclk	;pulse clock high..
		bcf	synclk	;and then low
		rlf	charbuff,1	;move to next data bit
		decf	datalen,1	;dec the length count
		decfsz	bitctr,1	;and the bit/byte count
					
		goto	synthdata5	;if bit/byte count not zero
					;then test the length count
		goto	synthdata1	;else get the next byte

synthdata5	movf	datalen,1	;test length count using Z
		btfss	STATUS,Z	;if not zero
		goto	synthdata2	;process next bit
		bsf	synle		;else send synth LE
		bcf	synle
		retlw	0
		
;	
;Data tables
;		

getdata	addwf	PCL,1		;offset into table
table
reset1	retlw	D'128'	;data to enter reset mode
		retlw	D'8'
		retlw	D'96'

reset2	retlw	D'128'	;data to leave reset mode
		retlw	D'8'
		retlw	D'32'

rcount	retlw	0		;reference counter data - 2 Mhz & divide by 5
		retlw	D'0'
		retlw	D'160'
 

ch1		retlw	D'0'		; 2256 Mhz L.O. output with 2 Mhz ref - divide by 1128
		retlw	D'141'
		retlw	D'8'

		end

