﻿//    Copyright © 2010, 2011 Thomas C. McDermott, N5EG
//    This file is part of ABCDmatrix - the 2-Port Network Calculator program.
//
//    ABCDmatrix is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    ABCDmatrix is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with ABCDmatrix, if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//


using System;
using System.ComponentModel;

namespace ABCDmatrix
{
    /// <summary>
    /// Hold the parameters used in an analysis, make them browsable.
    /// </summary>
    [Serializable]
    public class AnalysisParameter
    {
        /// <summary>
        /// Default constructor
        /// </summary>
        public AnalysisParameter()
        {
            StartFrequency = 1;
            StopFrequency = 1000000000;
            NumberPoints = 400;
            ShowInputZ = true;               
            ShowVoltageTransfer = false;
            ShowNetworkS11 = false;
            RefResistanceS11Display = 50;
            FrequencyAxisFormat = AxisFormat.Linear;
            YAxisFormat = AxisFormat.Linear;
            Y2AxisFormat = AxisFormat.Linear;
            InputZFormat = ComplexFormat.MagnitudePhase;

        }

        public Boolean Yauto;                    // auto Y-scale
        public Double Ymin;                      // manual Y-scale minimum
        public Double Ymax;                      // manual Y-scale maximum
        public Boolean Xauto;                    // auto Y-scale
 
        [Description("Node to display the analysis start point"), Category("Display Parameter")]
        public Int32 FromNode { get; set; }    // node to analyze from

        [Description("Node to display the analysis end point"), Category("Display Parameter")]
        public Int32 ToNode { get; set; }   // node to anlayze to

        [Description("Frequency to Start the analysis."), Category("Analysis Parameter")]
        public Double StartFrequency { get; set; }

        [Description("Frequency to Stop the analysis."), Category("Analysis Parameter")]
        public Double StopFrequency { get; set; }

        [Description("Number of points in the Frequency sweep."), Category("Analysis Parameter")]
        public Int32 NumberPoints { get; set; }

        [Description("Reference resistance for S11 display"), Category("Analysis Parameter")]
        public Double RefResistanceS11Display { get; set; }   // reference impedance for S11 & S21 display

        [Description("Frequency Axis Type."), Category("Linear / Log Scale")]
        public AxisFormat FrequencyAxisFormat { get; set; } // Frequency analysis & display lin/log

        [Description("Y Axis Type."), Category("Linear / Log Scale")]
        public AxisFormat YAxisFormat { get; set; } // primary axis format lin/log

        [Description("Y2 Axis Type."), Category("Linear / Log Scale")]
        public AxisFormat Y2AxisFormat { get; set; }  // secondary asix format lin/log

        [Description("Network Input Impedance."), Category("Trace Display")]
        public Boolean ShowInputZ { get; set; }  // display Input Impedance?

        [Description("Network Voltage Transfer Function."), Category("Trace Display")]
        public Boolean ShowVoltageTransfer { get; set; } // display network voltage transfer function

        [Description("Network Power Transfer Function."), Category("Trace Display")]
        public Boolean ShowPowerTransfer { get; set; }  // display network power transfer ratio?

        [Description("Network Input Impedance as S11."), Category("Trace Display")]
        public Boolean ShowNetworkS11 { get; set; }  // display network input impedance as S11?

        [Description("Input Impedance Format"), Category("Trace Format")]
        public ComplexFormat InputZFormat { get; set; }  // how to show the input impedance

    }

    /// <summary>
    /// Define chart axis formats
    /// </summary>
    public enum AxisFormat
    {
        /// <summary>
        /// Linear chart scale
        /// </summary>
        Linear = 0,
        /// <summary>
        /// Logarithmic chart scale
        /// </summary>
        Logarithmic
    }

    /// <summary>
    /// Ways to show an analysis result that's a complex number 
    /// </summary>
    public enum ComplexFormat
    {
        /// <summary>
        /// magnitude and angle format
        /// </summary>
        MagnitudePhase = 0,
        /// <summary>
        /// real, imaginary format
        /// </summary>
        RealImaginary
    }
}
