/*******************************************************************************
* File Name: REDLED.c  
* Version 1.60
*
* Description:
*  This file contains API to enable firmware control of a Pins component.
*
* Note:
*
********************************************************************************
* Copyright 2008-2010, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
********************************************************************************/

#include "cytypes.h"
#include "REDLED.h"


/*******************************************************************************
* Function Name: REDLED_Write
********************************************************************************
* Summary:
*  Assign a new value to the digital port's data output register.  
*
* Parameters:  
*  prtValue:  The value to be assigned to the Digital Port. 
*
* Return: 
*  void 
*  
*******************************************************************************/
void REDLED_Write(uint8 value) 
{
    uint8 staticBits = REDLED_DR & ~REDLED_MASK;
    REDLED_DR = staticBits | ((value << REDLED_SHIFT) & REDLED_MASK);
}


/*******************************************************************************
* Function Name: REDLED_SetDriveMode
********************************************************************************
* Summary:
*  Change the drive mode on the pins of the port.
* 
* Parameters:  
*  mode:  Change the pins to this drive mode.
*
* Return: 
*  void
*
*******************************************************************************/
void REDLED_SetDriveMode(uint8 mode) 
{
	CyPins_SetPinDriveMode(REDLED_0, mode);
}


/*******************************************************************************
* Function Name: REDLED_Read
********************************************************************************
* Summary:
*  Read the current value on the pins of the Digital Port in right justified 
*  form.
*
* Parameters:  
*  void 
*
* Return: 
*  Returns the current value of the Digital Port as a right justified number
*  
* Note:
*  Macro REDLED_ReadPS calls this function. 
*  
*******************************************************************************/
uint8 REDLED_Read(void) 
{
    return (REDLED_PS & REDLED_MASK) >> REDLED_SHIFT;
}


/*******************************************************************************
* Function Name: REDLED_ReadDataReg
********************************************************************************
* Summary:
*  Read the current value assigned to a Digital Port's data output register
*
* Parameters:  
*  void 
*
* Return: 
*  Returns the current value assigned to the Digital Port's data output register
*  
*******************************************************************************/
uint8 REDLED_ReadDataReg(void) 
{
    return (REDLED_DR & REDLED_MASK) >> REDLED_SHIFT;
}


/* If Interrupts Are Enabled for this Pins component */ 
#if defined(REDLED_INTSTAT) 

    /*******************************************************************************
    * Function Name: REDLED_ClearInterrupt
    ********************************************************************************
    * Summary:
    *  Clears any active interrupts attached to port and returns the value of the 
    *  interrupt status register.
    *
    * Parameters:  
    *  void 
    *
    * Return: 
    *  Returns the value of the interrupt status register
    *  
    *******************************************************************************/
    uint8 REDLED_ClearInterrupt(void) 
    {
        return (REDLED_INTSTAT & REDLED_MASK) >> REDLED_SHIFT;
    }

#endif /* If Interrupts Are Enabled for this Pins component */ 


/* [] END OF FILE */ 
