/*******************************************************************************
* File Name: TEST_INPUT.c  
* Version 1.50
*
* Description:
*  This file contains API to enable firmware control of a Pins component.
*
* Note:
*
********************************************************************************
* Copyright 2008-2010, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
********************************************************************************/

#include "cytypes.h"
#include "TEST_INPUT.h"


/*******************************************************************************
* Function Name: TEST_INPUT_Write
********************************************************************************
* Summary:
*  Assign a new value to the digital port's data output register.  
*
* Parameters:  
*  prtValue:  The value to be assigned to the Digital Port. 
*
* Return: 
*  void 
*  
*******************************************************************************/
void TEST_INPUT_Write(uint8 value) 
{
    uint8 staticBits = TEST_INPUT_DR & ~TEST_INPUT_MASK;
    TEST_INPUT_DR = staticBits | ((value << TEST_INPUT_SHIFT) & TEST_INPUT_MASK);
}


/*******************************************************************************
* Function Name: TEST_INPUT_SetDriveMode
********************************************************************************
* Summary:
*  Change the drive mode on the pins of the port.
* 
* Parameters:  
*  mode:  Change the pins to this drive mode.
*
* Return: 
*  void
*
*******************************************************************************/
void TEST_INPUT_SetDriveMode(uint8 mode) 
{
	CyPins_SetPinDriveMode(TEST_INPUT_0, mode);
}


/*******************************************************************************
* Function Name: TEST_INPUT_Read
********************************************************************************
* Summary:
*  Read the current value on the pins of the Digital Port in right justified 
*  form.
*
* Parameters:  
*  void 
*
* Return: 
*  Returns the current value of the Digital Port as a right justified number
*  
* Note:
*  Macro TEST_INPUT_ReadPS calls this function. 
*  
*******************************************************************************/
uint8 TEST_INPUT_Read(void) 
{
    return (TEST_INPUT_PS & TEST_INPUT_MASK) >> TEST_INPUT_SHIFT;
}


/*******************************************************************************
* Function Name: TEST_INPUT_ReadDataReg
********************************************************************************
* Summary:
*  Read the current value assigned to a Digital Port's data output register
*
* Parameters:  
*  void 
*
* Return: 
*  Returns the current value assigned to the Digital Port's data output register
*  
*******************************************************************************/
uint8 TEST_INPUT_ReadDataReg(void) 
{
    return (TEST_INPUT_DR & TEST_INPUT_MASK) >> TEST_INPUT_SHIFT;
}


/* If Interrupts Are Enabled for this Pins component */ 
#if defined(TEST_INPUT_INTSTAT) 

    /*******************************************************************************
    * Function Name: TEST_INPUT_ClearInterrupt
    ********************************************************************************
    * Summary:
    *  Clears any active interrupts attached to port and returns the value of the 
    *  interrupt status register.
    *
    * Parameters:  
    *  void 
    *
    * Return: 
    *  Returns the value of the interrupt status register
    *  
    *******************************************************************************/
    uint8 TEST_INPUT_ClearInterrupt(void) 
    {
        return (TEST_INPUT_INTSTAT & TEST_INPUT_MASK) >> TEST_INPUT_SHIFT;
    }

#endif /* If Interrupts Are Enabled for this Pins component */ 


/* [] END OF FILE */ 
