/******************************************************************************
* File Name: EEPROM.h
* Version 1.50
*
*  Description:
*   Provides the function definitions for the EEPROM API.
*
********************************************************************************
* Copyright 2008-2010, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
********************************************************************************/


#if !defined(__EEPROM_EEPROM_H__)
#define __EEPROM_EEPROM_H__


#include <CYFLASH.H>

#define EEPROM_EEPROM_SIZE    CYDEV_EE_SIZE

/***************************************
*   Conditional Compilation Parameters
***************************************/

/* PSoC3 ES3 or later */
#define EEPROM_PSOC3_ES3  ((CYDEV_CHIP_MEMBER_USED == CYDEV_CHIP_MEMBER_3A) && \
                                    (CYDEV_CHIP_REVISION_USED >= CYDEV_CHIP_REVISION_3A_ES3))

/* PSoC5 ES2 or later */
#define EEPROM_PSOC5_ES2  ((CYDEV_CHIP_MEMBER_USED == CYDEV_CHIP_MEMBER_5A) && \
                                    (CYDEV_CHIP_REVISION_USED > CYDEV_CHIP_REVISION_5A_ES1))

/***************************************
* Function Prototypes
***************************************/
#if (EEPROM_PSOC3_ES3 || EEPROM_PSOC5_ES2) 
    void EEPROM_Enable(void) ;
    void EEPROM_Start(void); 
    void EEPROM_Stop(void) ;
#endif /* (EEPROM_PSOC3_ES3 || EEPROM_PSOC5_ES2) */
cystatus EEPROM_EraseSector(uint16 sectorNumber) ;
cystatus EEPROM_Write(uint8 * rowData, uint16 rowNumber) ;
cystatus EEPROM_StartWrite(uint8 * rowData, uint16 rowNumber) ;
cystatus EEPROM_QueryWrite(void) ;


#endif /* __EEPROM_EEPROM_H__ */
