/*******************************************************************************
* File Name: UART_TXInternalInterrupt_intc.h
* Version 1.0
*
*  Description:
*   Provides the function definitions for the Interrupt Controller.
*
*
********************************************************************************
* Copyright 2008-2009, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
********************************************************************************/
#if !defined(__UART_TXInternalInterrupt_INTC_H__)
#define __UART_TXInternalInterrupt_INTC_H__


#include <cytypes.h>
#include <cyfitter.h>


/* Interrupt Controller API. */
void UART_TXInternalInterrupt_Start(void);
void UART_TXInternalInterrupt_Stop(void);

CY_ISR_PROTO(UART_TXInternalInterrupt_Interrupt);

void UART_TXInternalInterrupt_SetVector(cyisraddress address);
cyisraddress UART_TXInternalInterrupt_GetVector(void);

void UART_TXInternalInterrupt_SetPriority(uint8 priority);
uint8 UART_TXInternalInterrupt_GetPriority(void);

void UART_TXInternalInterrupt_Enable(void);
uint8 UART_TXInternalInterrupt_GetState(void);
void UART_TXInternalInterrupt_Disable(void);

void UART_TXInternalInterrupt_SetPending(void);
void UART_TXInternalInterrupt_ClearPending(void);


/* Interrupt Controller Constants */

/* Address of the INTC.VECT[x] register that contains the Address of the UART_TXInternalInterrupt ISR. */
#define UART_TXInternalInterrupt_INTC_VECTOR            ((reg16 *) UART_TXInternalInterrupt__INTC_VECT)

/* Address of the UART_TXInternalInterrupt ISR priority. */
#define UART_TXInternalInterrupt_INTC_PRIOR             ((reg8 *) UART_TXInternalInterrupt__INTC_PRIOR_REG)

/* Priority of the UART_TXInternalInterrupt interrupt. */
#define UART_TXInternalInterrupt_INTC_PRIOR_NUMBER      UART_TXInternalInterrupt__INTC_PRIOR_NUM

/* Address of the INTC.SET_EN[x] byte to bit enable UART_TXInternalInterrupt interrupt. */
#define UART_TXInternalInterrupt_INTC_SET_EN            ((reg8 *) UART_TXInternalInterrupt__INTC_SET_EN_REG)

/* Address of the INTC.CLR_EN[x] register to bit clear the UART_TXInternalInterrupt interrupt. */
#define UART_TXInternalInterrupt_INTC_CLR_EN            ((reg8 *) UART_TXInternalInterrupt__INTC_CLR_EN_REG)

/* Address of the INTC.SET_PD[x] register to set the UART_TXInternalInterrupt interrupt state to pending. */
#define UART_TXInternalInterrupt_INTC_SET_PD            ((reg8 *) UART_TXInternalInterrupt__INTC_SET_PD_REG)

/* Address of the INTC.CLR_PD[x] register to clear the UART_TXInternalInterrupt interrupt. */
#define UART_TXInternalInterrupt_INTC_CLR_PD            ((reg8 *) UART_TXInternalInterrupt__INTC_CLR_PD_REG)

/* __UART_TXInternalInterrupt_INTC_H__ */
#endif

