#!/usr/bin/env python
##################################################
# Gnuradio Python Flow Graph
# Title: BiQuad_Cascades
# Author: Theodor Prosch ,DL8PT
# Description: 2x5BiQuads, equiripple, 77.5 dB SB-att
# Generated: Mon Dec 12 17:48:18 2011
##################################################

from gnuradio import audio
from gnuradio import gr
from gnuradio.eng_option import eng_option
from gnuradio.wxgui import fftsink2
from gnuradio.wxgui import forms
from grc_gnuradio import wxgui as grc_wxgui
from optparse import OptionParser
import wx

class Biphase_Hilbert_Network(grc_wxgui.top_block_gui):

	def __init__(self):
		grc_wxgui.top_block_gui.__init__(self, title="BiQuad_Cascades")

		##################################################
		# Variables
		##################################################
		self.samp_rate = samp_rate = 48000
		self.noise = noise = .050
		self.f_ton = f_ton = 2500
		self.ampl = ampl = .4

		##################################################
		# Controls
		##################################################
		_noise_sizer = wx.BoxSizer(wx.VERTICAL)
		self._noise_text_box = forms.text_box(
			parent=self.GetWin(),
			sizer=_noise_sizer,
			value=self.noise,
			callback=self.set_noise,
			label="Noise",
			converter=forms.float_converter(),
			proportion=0,
		)
		self._noise_slider = forms.slider(
			parent=self.GetWin(),
			sizer=_noise_sizer,
			value=self.noise,
			callback=self.set_noise,
			minimum=0,
			maximum=.2,
			num_steps=100,
			style=wx.SL_HORIZONTAL,
			cast=float,
			proportion=1,
		)
		self.GridAdd(_noise_sizer, 1, 3, 1, 2)
		_f_ton_sizer = wx.BoxSizer(wx.VERTICAL)
		self._f_ton_text_box = forms.text_box(
			parent=self.GetWin(),
			sizer=_f_ton_sizer,
			value=self.f_ton,
			callback=self.set_f_ton,
			label="2nd tone frequency",
			converter=forms.float_converter(),
			proportion=0,
		)
		self._f_ton_slider = forms.slider(
			parent=self.GetWin(),
			sizer=_f_ton_sizer,
			value=self.f_ton,
			callback=self.set_f_ton,
			minimum=50,
			maximum=samp_rate/2,
			num_steps=501,
			style=wx.SL_HORIZONTAL,
			cast=float,
			proportion=1,
		)
		self.GridAdd(_f_ton_sizer, 1, 5, 1, 2)
		_ampl_sizer = wx.BoxSizer(wx.VERTICAL)
		self._ampl_text_box = forms.text_box(
			parent=self.GetWin(),
			sizer=_ampl_sizer,
			value=self.ampl,
			callback=self.set_ampl,
			label="Volume",
			converter=forms.float_converter(),
			proportion=0,
		)
		self._ampl_slider = forms.slider(
			parent=self.GetWin(),
			sizer=_ampl_sizer,
			value=self.ampl,
			callback=self.set_ampl,
			minimum=0,
			maximum=.5,
			num_steps=100,
			style=wx.SL_HORIZONTAL,
			cast=float,
			proportion=1,
		)
		self.GridAdd(_ampl_sizer, 1, 1, 1, 2)

		##################################################
		# Blocks
		##################################################
		self.audio_sink_0 = audio.sink(48000, "hw:1", True)
		self.gr_add_xx = gr.add_vff(1)
		self.gr_delay_0 = gr.delay(gr.sizeof_float*1, 1)
		self.gr_float_to_complex_0 = gr.float_to_complex(1)
		self.gr_iir_filter_ffd_0 = gr.iir_filter_ffd((-0.595614470 ,0.,1.), (0.,0.,0.595614470))
		self.gr_iir_filter_ffd_1 = gr.iir_filter_ffd((-0.222853404 ,0.,1.), (0.,0.,0.222853404 ))
		self.gr_iir_filter_ffd_2 = gr.iir_filter_ffd((-0.897795483,0.,1.), (0.,0.,0.897795483))
		self.gr_iir_filter_ffd_3 = gr.iir_filter_ffd((-0.969358595,0.,1.), (0.,0.,0.969358595))
		self.gr_iir_filter_ffd_4 = gr.iir_filter_ffd((-0.734309652,0.,1.), (0.,0.,0.734309652))
		self.gr_iir_filter_ffd_5 = gr.iir_filter_ffd((-0.417480056,0.,1.), (0.,0.,0.417480056))
		self.gr_iir_filter_ffd_6 = gr.iir_filter_ffd((-0.063038084,0.,1.), (0.,0.,0.063038084))
		self.gr_iir_filter_ffd_7 = gr.iir_filter_ffd((-0.832300087,0.,1.), (0.,0.,0.832300087))
		self.gr_iir_filter_ffd_8 = gr.iir_filter_ffd((-0.940655103,0.,1.), (0.,0.,0.940655103))
		self.gr_iir_filter_ffd_9 = gr.iir_filter_ffd((-0.990533091,0.,1.), (0.,0.,0.990533091))
		self.gr_noise_source_x = gr.noise_source_f(gr.GR_GAUSSIAN, noise, 42)
		self.gr_sig_source_x = gr.sig_source_f(samp_rate, gr.GR_COS_WAVE, 200, ampl, 0)
		self.gr_sig_source_x0 = gr.sig_source_f(samp_rate, gr.GR_COS_WAVE, f_ton, ampl, 0)
		self.wxgui_fftsink2_0 = fftsink2.fft_sink_c(
			self.GetWin(),
			baseband_freq=0,
			y_per_div=20,
			y_divs=10,
			ref_level=50,
			sample_rate=samp_rate,
			fft_size=2*4096,
			fft_rate=2,
			average=True,
			avg_alpha=0.1,
			title="FFT Plot",
			peak_hold=False,
		)
		self.Add(self.wxgui_fftsink2_0.win)

		##################################################
		# Connections
		##################################################
		self.connect((self.gr_sig_source_x0, 0), (self.gr_add_xx, 0))
		self.connect((self.gr_sig_source_x, 0), (self.gr_add_xx, 1))
		self.connect((self.gr_noise_source_x, 0), (self.gr_add_xx, 2))
		self.connect((self.gr_float_to_complex_0, 0), (self.wxgui_fftsink2_0, 0))
		self.connect((self.gr_iir_filter_ffd_2, 0), (self.gr_iir_filter_ffd_3, 0))
		self.connect((self.gr_iir_filter_ffd_1, 0), (self.gr_iir_filter_ffd_0, 0))
		self.connect((self.gr_delay_0, 0), (self.gr_iir_filter_ffd_1, 0))
		self.connect((self.gr_add_xx, 0), (self.gr_delay_0, 0))
		self.connect((self.gr_iir_filter_ffd_3, 0), (self.gr_float_to_complex_0, 0))
		self.connect((self.gr_iir_filter_ffd_0, 0), (self.gr_iir_filter_ffd_7, 0))
		self.connect((self.gr_iir_filter_ffd_7, 0), (self.gr_iir_filter_ffd_8, 0))
		self.connect((self.gr_iir_filter_ffd_8, 0), (self.gr_iir_filter_ffd_9, 0))
		self.connect((self.gr_iir_filter_ffd_6, 0), (self.gr_iir_filter_ffd_5, 0))
		self.connect((self.gr_iir_filter_ffd_5, 0), (self.gr_iir_filter_ffd_4, 0))
		self.connect((self.gr_iir_filter_ffd_4, 0), (self.gr_iir_filter_ffd_2, 0))
		self.connect((self.gr_add_xx, 0), (self.gr_iir_filter_ffd_6, 0))
		self.connect((self.gr_iir_filter_ffd_3, 0), (self.audio_sink_0, 0))
		self.connect((self.gr_iir_filter_ffd_9, 0), (self.audio_sink_0, 1))
		self.connect((self.gr_iir_filter_ffd_9, 0), (self.gr_float_to_complex_0, 1))

	def set_samp_rate(self, samp_rate):
		self.samp_rate = samp_rate
		self.gr_sig_source_x0.set_sampling_freq(self.samp_rate)
		self.gr_sig_source_x.set_sampling_freq(self.samp_rate)
		self.wxgui_fftsink2_0.set_sample_rate(self.samp_rate)

	def set_noise(self, noise):
		self.noise = noise
		self.gr_noise_source_x.set_amplitude(self.noise)
		self._noise_slider.set_value(self.noise)
		self._noise_text_box.set_value(self.noise)

	def set_f_ton(self, f_ton):
		self.f_ton = f_ton
		self.gr_sig_source_x0.set_frequency(self.f_ton)
		self._f_ton_slider.set_value(self.f_ton)
		self._f_ton_text_box.set_value(self.f_ton)

	def set_ampl(self, ampl):
		self.ampl = ampl
		self.gr_sig_source_x0.set_amplitude(self.ampl)
		self.gr_sig_source_x.set_amplitude(self.ampl)
		self._ampl_slider.set_value(self.ampl)
		self._ampl_text_box.set_value(self.ampl)

if __name__ == '__main__':
	parser = OptionParser(option_class=eng_option, usage="%prog: [options]")
	(options, args) = parser.parse_args()
	tb = Biphase_Hilbert_Network()
	tb.Run(True)

