/*	CPLEX.H
 */

#ifndef _CPLEX_H
#define _CPLEX_H

#include <math.h>

typedef struct {
	double r;
	double i;
} COMPLEX;

COMPLEX *cadd(COMPLEX *c1, COMPLEX *c2, COMPLEX *sum);
COMPLEX *csub(COMPLEX *c1, COMPLEX *c2, COMPLEX *diff);
COMPLEX *cmult(COMPLEX *c1, COMPLEX *c2, COMPLEX *prod);
COMPLEX *cdiv(COMPLEX *c1, COMPLEX *c2, COMPLEX *quot);
COMPLEX *crecip(COMPLEX *c, COMPLEX *recip);
COMPLEX *csqrt(COMPLEX *c, COMPLEX *root);
double cmod(COMPLEX *c);

#endif /* _CPLEX_H */
