10 REM          file "KNEC.BAS"
20 COLOR 11,1,3:CLS:X$=STRING$(79,32)
25 REM          Option selection page
30 LOCATE 1,16:PRINT"Calculation of K, the Antenna Shortening Factor,":LOCATE 2,18:PRINT"and Vertical and Horizontal Antenna Lengths":LOCATE 3,30:PRINT"L. B. Cebik, W4RNL":PRINT
40  PRINT " This program calculates values of the antenna shortening factor and antenna     lengths, including quarter-wave verticals over perfect ground, half-wavelength  dipoles in free space, and long wire vertical and horizontal antennas.  The"
50  PRINT " frequency limits are 3 to 30 MHz.  All dimensions are calibrated to NEC-2       antenna models.  Available materials are AWG #18 to AWG #10 copper wire and     aluminum rod or tubing from 0.125 to 2.0 inch diameters.":PRINT
60  PRINT " Select one of the following two options:":PRINT:PRINT " <A>  A table of antenna lengths from 1 to 7 half wavelengths.":PRINT
70  PRINT " <B>  A table of values of K, along with the lengths of quarter-wavelength            vertical and half-wavelength horizontal antennas."
80 Z$=INKEY$:IF Z$="a" OR Z$="A" THEN 90 ELSE IF Z$="b" OR Z$="B" THEN 470 ELSE 80
85 REM          Option A calculations
90 CLS:LOCATE 1,8:PRINT "Tables of Horizontal Antenna Lengths from 1 to 7 Half Wavelengths":PRINT:VV$="###.##":WW$="####.##":YY$=STRING$(3,32)
100 PRINT " AWG Wire sizes are copper; decimal wire diameters are aluminum.  Quarter-wave   vertical antennas over perfect ground are 1/2 the values shown where Xn = the   number of quarter wavelengths.
110 LOCATE 6,1:INPUT " Enter the frequency of interest in MHz      ",F
120 IF F<3 OR F>30 THEN LOCATE 6,1:PRINT X$:GOTO 500
130 WLF=983.5712/F
140 LOCATE 6,1:PRINT X$:LOCATE 6,1:PRINT" Frequency:";F;"MHz";:LOCATE 6,58:PRINT"Wavelength: ";:PRINT USING "###.##";WLF;:PRINT" ft"
150 LOCATE 7,25:PRINT "Number of half-wavelengths; Length in feet"
160 PRINT " Wire size";:PRINT YY$;:PRINT "  X 1      X 2      X 3      X 4      X 5       X 6       X7"
170 FOR A=1 TO 14
180 IF A=1 THEN 200 ELSE IF A=2 THEN 210 ELSE IF A=3 THEN 220 ELSE IF A=4 THEN 230 ELSE IF A=5 THEN 240 ELSE IF A=6 THEN 250 ELSE IF A=7 THEN 260 ELSE IF A=8 THEN 270 ELSE 190
190 IF A=9 THEN 280 ELSE IF A=10 THEN 290 ELSE IF A=11 THEN 300 ELSE IF A=12 THEN 310 ELSE IF A=13 THEN 320 ELSE IF A=14 THEN 330
200 W$=" #18-0.0403":LQL=959.435:LQH=95.335:LTL=6848.87:LTH=684.82:GOTO 340
210 W$=" #16-0.0508":LQL=959.183:LQH=95.252:LTL=6850.53:LTH=684.8:GOTO 340
220 W$=" #14-0.0641":LQL=958.885:LQH=95.154:LTL=6851.67:LTH=684.768:GOTO 340
230 W$=" #12-0.0808":LQL=958.478:LQH=95.04799:LTL=6852.43:LTH=684.699:GOTO 340
240 W$=" #10-0.1019":LQL=958.001:LQH=94.931:LTL=6852.81:LTH=684.618:GOTO 340
250 W$=" 0.125 in. ":LQL=957.22:LQH=94.807:LTL=6850.95:LTH=684.45:GOTO 340
260 W$=" 0.25 in.  ":LQL=955.36:LQH=94.35:LTL=6851.31:LTH=684.082:GOTO 340
270 W$=" 0.50 in.  ":LQL=952.85:LQH=93.734:LTL=6850.05:LTH=683.55:GOTO 340
280 W$=" 0.75 in.  ":LQL=951.03:LQH=93.275:LTL=6848.59:LTH=683.144:GOTO 340
290 W$=" 1.00 in.  ":LQL=949.58:LQH=92.898:LTL=6847.46:LTH=682.82:GOTO 340
300 W$=" 1.25 in.  ":LQL=948.31:LQH=92.575:LTL=6846.2:LTH=682.555:GOTO 340
310 W$=" 1.50 in.  ":LQL=947.22:LQH=92.292:LTL=6845.25:LTH=682.332:GOTO 340
320 W$=" 1.75 in.  ":LQL=946.22:LQH=92.038:LTL=6844.28:LTH=682.14:GOTO 340
330 W$=" 2.00 in.  ":LQL=945.3:LQH=91.81199:LTL=6843.45:LTH=681.983:GOTO 340
340 Q=2950.7136#:LQW=Q/F:LQWH=Q/30:LQWL=Q/3:KQH=LQH/LQWH:KQL=LQL/LQWL:KTH=LTH/(3*LQWH):KTL=LTL/(3*LQWL)
350 EE=(((F/3)-1)*.0333333)+.61:KQW=KQH+((.4343*LOG(30/F))^EE)*(KQL-KQH)
360 KTQ=KTH+((.4343*LOG(30/F))^EE)*(KTL-KTH)
370 LQ=KQW*LQW:LT=KTQ*(3*LQW):KE=(6*LQ)/(LT-LQ):KM=KQW/KE:PRINT W$;:PRINT YY$;
380 FOR B=1 TO 7
390 BB=B-1:LD=(2*LQW)/12:LL=((BB*LD)*KM)+(KQW*LD)
400 IF B<6 THEN PRINT USING VV$;LL;:PRINT YY$;
410 IF B>5 AND B<7 THEN PRINT USING WW$;LL;:PRINT YY$;
420 IF B=7 THEN PRINT USING WW$;LL
430 NEXT
440 NEXT
450 PRINT:PRINT "  <Print Screen> for hard copy";YY$;YY$;"<A>nother run, <V>alues of K, or <Q>uit";
460 Z$=INKEY$:IF Z$="a" OR Z$="A" THEN 90 ELSE IF Z$="v" OR Z$="V" THEN 470 ELSE IF Z$="Q" OR Z$="q" THEN 810 ELSE 460
465 REM                 Option B Calculation
470 CLS:LOCATE 1,16:PRINT "Calculation of K, the Antenna Shortening Factor"
480 LOCATE 3,1:PRINT" KT is the total shortening factor. KM is the shortening factor due to element   material. KE is the shortening factor due to end effect.  Values calibrated to"
490 LOCATE 5,1:PRINT" NEC-2 models for 3-30 MHz.  AWG sizes are copper; decimal sizes are aluminum."
500 LOCATE 7,1:INPUT " Enter the frequency of interest in MHz      ",F
510 IF F<3 OR F>30 THEN LOCATE 7,1:PRINT X$:GOTO 500
520 WLF=983.5712/F
530 LOCATE 7,1:PRINT X$:LOCATE 7,1:PRINT" Freq:";F;"MHz";:LOCATE 7,20:PRINT"Wavelength:";:PRINT USING "###.##";WLF;:PRINT" ft":LOCATE 7,48:PRINT"1/4-WL Vertical";:LOCATE 7,65:PRINT"1/2-WL Dipole"
540 LOCATE 8,2:PRINT"Wire Size":LOCATE 8,20:PRINT"KT":LOCATE 8,30:PRINT"KM":LOCATE 8,40:PRINT"KE":LOCATE 8,52:PRINT"L (ft)":LOCATE 8,67:PRINT"L (ft)"
550 FOR A=1 TO 14
560 IF A=1 THEN 580 ELSE IF A=2 THEN 590 ELSE IF A=3 THEN 600 ELSE IF A=4 THEN 610 ELSE IF A=5 THEN 620 ELSE IF A=6 THEN 630 ELSE IF A=7 THEN 640 ELSE IF A=8 THEN 650 ELSE 570
570 IF A=9 THEN 660 ELSE IF A=10 THEN 670 ELSE IF A=11 THEN 680 ELSE IF A=12 THEN 690 ELSE IF A=13 THEN 700 ELSE IF A=14 THEN 710
580 W$=" #18-0.0403":LQL=959.435:LQH=95.335:LTL=6848.87:LTH=684.82:GOTO 720
590 W$=" #16-0.0508":LQL=959.183:LQH=95.252:LTL=6850.53:LTH=684.8:GOTO 720
600 W$=" #14-0.0641":LQL=958.885:LQH=95.154:LTL=6851.67:LTH=684.768:GOTO 720
610 W$=" #12-0.0808":LQL=958.478:LQH=95.04799:LTL=6852.43:LTH=684.699:GOTO 720
620 W$=" #10-0.1019":LQL=958.001:LQH=94.931:LTL=6852.81:LTH=684.618:GOTO 720
630 W$=" 0.125 in. ":LQL=957.22:LQH=94.807:LTL=6850.95:LTH=684.45:GOTO 720
640 W$=" 0.25 in.  ":LQL=955.36:LQH=94.35:LTL=6851.31:LTH=684.082:GOTO 720
650 W$=" 0.50 in.  ":LQL=952.85:LQH=93.734:LTL=6850.05:LTH=683.55:GOTO 720
660 W$=" 0.75 in.  ":LQL=951.03:LQH=93.275:LTL=6848.59:LTH=683.144:GOTO 720
670 W$=" 1.00 in.  ":LQL=949.58:LQH=92.898:LTL=6847.46:LTH=682.82:GOTO 720
680 W$=" 1.25 in.  ":LQL=948.31:LQH=92.575:LTL=6846.2:LTH=682.555:GOTO 720
690 W$=" 1.50 in.  ":LQL=947.22:LQH=92.292:LTL=6845.25:LTH=682.332:GOTO 720
700 W$=" 1.75 in.  ":LQL=946.22:LQH=92.038:LTL=6844.28:LTH=682.14:GOTO 720
710 W$=" 2.00 in.  ":LQL=945.3:LQH=91.81199:LTL=6843.45:LTH=681.983:GOTO 720
720 Q=2950.7136#:LQW=Q/F:LQWH=Q/30:LQWL=Q/3:KQH=LQH/LQWH:KQL=LQL/LQWL:KTH=LTH/(3*LQWH):KTL=LTL/(3*LQWL)
730 EE=(((F/3)-1)*.0333333)+.61:KQW=KQH+((.4343*LOG(30/F))^EE)*(KQL-KQH)
740 KTQ=KTH+((.4343*LOG(30/F))^EE)*(KTL-KTH)
750 LQ=KQW*LQW:LT=KTQ*(3*LQW):KE=(6*LQ)/(LT-LQ):KM=KQW/KE:IF KM>.9999 THEN KM=.9999
760 V=KQW*(245.8928/F):D=V*2:Y$=STRING$(5,32):V$=STRING$(9,32):U$=".####":T$="###.##":S$=STRING$(6,32)
770 PRINT W$;:PRINT S$;:PRINT USING U$;KQW;:PRINT Y$;:PRINT USING U$;KM;:PRINT Y$;:PRINT USING U$;KE;:PRINT V$;:PRINT USING T$;V;:PRINT V$;:PRINT USING T$;D
780 NEXT
790 PRINT:PRINT "  <Print Screen> for hard copy";V$;"<A>nother run, <W>ire lengths, or <Q>uit";
800 Z$=INKEY$:IF Z$="a" OR Z$="A" THEN 470 ELSE IF Z$="Q" OR Z$="q" THEN 810 ELSE IF Z$="w" OR Z$="W" THEN 90 ELSE 800
810 END
