*THE ULTIMATE VFO  
*ANALOG DEVICES AD7008 DIRECT DIGITAL SYNTHESIS CHIP
*USING THE MOTOROLA MC68HC811E2FN MICROCOMPUTER
*BY DONALD S. KIRK (WD8DSB) 27MR96
        ORG     $F800                                                                          
PORTA   EQU     $1000
PORTB   EQU     $1004
PORTC   EQU     $1003
DDRC    EQU     $1007
PORTD   EQU     $1008
DDRD    EQU     $1009
ADCTL   EQU     $1030   FOR A/D
OPTION  EQU     $1039   FOR A/D
ADR1    EQU     $1031   FOR A/D
ADR2    EQU     $1032   FOR A/D
ADR3    EQU     $1033   FOR A/D
ADR4    EQU     $1034   FOR A/D
CHAR    EQU     $80
TMSK2   EQU     $1024   FOR PULSE ACCUMULATOR
TFLG2   EQU     $1025   FOR PULSE ACCUMULATOR
PACTL   EQU     $1026   FOR PULSE ACCUMULATOR
PACNT   EQU     $1027   FOR PULSE ACCUMULATOR
BPROT   EQU     $1035   EEPROM BLOCK PROTECT
LOBYTE  EQU     $81
TEMP    EQU     $82
PHASE   EQU     $83     PHASE VALUE REGISTERS FOR FREQ0=TX
PHASE1  EQU     $84
PHASE2  EQU     $85
PHASE3  EQU     $86
SERCNT  EQU     $87
HOLD    EQU     $88
HOLD+1  EQU     $89
BYTE    EQU     $8A
BYTE+1  EQU     $8B
BYTE+2  EQU     $8C
BYTE+3  EQU     $8D
BCD     EQU     $8E
BCD+1   EQU     $8F
BCD+2   EQU     $90
BCD+3   EQU     $91
ANS     EQU     $92
ANS+1   EQU     $93
ANS+2   EQU     $94
ANS+3   EQU     $95
BCDCTR  EQU     $96
RATE    EQU     $97
RATE+1  EQU     $98
RATE+2  EQU     $99
RATE+3  EQU     $9A
IF      EQU     $9B
IF+1    EQU     $9C
IF+2    EQU     $9D
IF+3    EQU     $9E
BAND    EQU     $9F                   
BAND+1  EQU     $A0
FREQ    EQU     $A1     FLAG REGISTER FOR FREQ0/FREQ1
PHARX   EQU     $A2     PHASE VALUE REGISTERS FOR FREQ1=RX
PHARX1  EQU     $A3
PHARX2  EQU     $A4
PHARX3  EQU     $A5
RITRAW  EQU     $A6
RITFRQ  EQU     $A7
IFSTAT  EQU     $A8

*MAIN        
        LDS     #$00FF  INITIALIZE STACK
        LDAA    #$7F    CONFIG PORT C FOR LCD DISPLAY
        STAA    DDRC
        CLR     DDRD    CONFIG PORT D FOR IF SET AND BAND SELECT INPUTS
        LDAA    #$00
        STAA    BPROT   ENABLE PROGRAMMING OF EEPROM
        LDAA    OPTION  SET A/D POWERUP CONTROL BIT =1
        ORAA    #$80
        STAA    OPTION
        LDAA    #$F0    SET A/D SCAN,MULT,&GROUP
        STAA    ADCTL
        LDAA    #$02    SET DEFAULT I.F. STAT = 2 WHICH IS DIFFERENCE FREQ.
        STAA    IFSTAT  
        LDD     $FFB0  I.F. FREQ STORED IN EEPROM
        STD     IF
        LDD     $FFB2
        STD     IF+2
        JSR     CLRIF   GO TO CLEAR THE I.F. REGISTERS ROUTINE
        LDX     #$FD24  RESET BAND POINTER TO START OF LIST MINUS 4
        STX     BAND
        CLR     PHASE   SET PHASE VALUE EQUAL TO 0 HERTZ
        CLR     PHASE1   
        CLR     PHASE2
        CLR     PHASE3
START   JSR     LCDINT  INITIALIZE DISPLAY
AGAIN   JSR     RATES
        LDAA    PORTA
        BITA    #$01    LOOK FOR UP PUSH BUTTON
        BEQ     LOOP9 
        BITA    #$02
        BEQ     LOOP3   LOOK FOR DOWN PUSH BUTTON
        JSR     SETIF   GO TO THE SET IF REGISTER ROUTINE 
        JSR     BANDS   GO AND PROCESS THE BAND SELECT P.B.
LOOP8   JSR     RX      ROUTINE TO CALCULATE RX FREQ FROM IF FREQ.
        JSR     RIT     ROUTINE TO USE RIT
        LDAA    PHASE
        JSR     SHOW
        LDAA    PHASE1 
        JSR     SHOW
        LDAA    PHASE2
        JSR     SHOW
        LDAA    PHASE3
        JSR     SHOW
        LDAA    IF
        JSR     SHOW
        LDAA    IF+1
        JSR     SHOW
        LDAA    IF+2
        JSR     SHOW
        LDAA    IF+3
        JSR     SHOW
        JSR     SERIAL
        JSR     DIVIDE
        JSR     BCDCON
        JSR     BCDDIS
        JSR     MIXDIS
        JSR     RITBCD  USE BCDDIS AND BORROW ANS REGISTERS FOR RIT DISPLAY
        LDAA    #$80    SEND DISPLAY BACK TO FIRST LOCATION OF ROW 1
        STAA    CHAR
        JSR     CONTRL
        BRA     AGAIN
LOOP9   LDD     PHASE2
        ADDD    RATE+2
        STD     PHASE2
        LDD     PHASE
        BCS     LOOP4
LOOP5   ADDD    RATE
        STD     PHASE
        BRA     LOOP8
LOOP4   ADDD    #$01
        BRA     LOOP5
LOOP3   LDD     PHASE2
        SUBD    RATE+2
        STD     PHASE2
        LDD     PHASE
        BCS     LOOP6
LOOP7   SUBD    RATE
        STD     PHASE
        BRA     LOOP8
LOOP6   SUBD    #$01
        BRA     LOOP7
CLRIF   LDAA    PORTD   LOOK FOR THE IF SET P.B. TO BE PUSHED ON POWER UP
        BITA    #$10
        BEQ     LOOP50
        RTS
LOOP50  CLR     IF
        CLR     IF+1
        CLR     IF+2
        CLR     IF+3
        CLR     IFSTAT  CLEAR THE IF STATUS REGISTER TO SHOW IF NOT SET
LOOP51  LDAA    PORTD   LOOK FOR P.B. TO GO BACK OFF
        BITA    #$10
        BEQ     LOOP51
        RTS
SETIF   LDAA    PORTD   LOOK FOR IF SET P.B. TO BE PUSHED
        BITA    #$10
        BEQ     LOOP52
        RTS
LOOP52  LDAA    IFSTAT  
        BEQ     LOOP60  BRANCH IF IF HAS NOT BEEN SET YET
        BITA    #$01
        BNE     LOOP61  BRANCH BECAUSE IFSTAT IS NOT = 2
        DEC     IFSTAT  MAKE IFSTAT = 1 = SUM
LOOP62  LDAA    PORTD
        BITA    #$10
        BEQ     LOOP62  LOOK FOR P.B. TO GO BACK OFF
        RTS
LOOP61  INC     IFSTAT
        BRA     LOOP62
LOOP60  LDAA    PHASE
        STAA    IF
        LDAA    PHASE1
        STAA    IF+1
        LDAA    PHASE2
        STAA    IF+2
        LDAA    PHASE3
        STAA    IF+3
        LDAA    #$01
        STAA    IFSTAT  PUT A 1 = SUM AND ALSO INDICATES IF HAS BEEN SET
        JSR     LOAD    ROUTINE TO LOAD BURN ROUTINE INTO RAM
        RTS
BANDS   LDAA    PORTD   IS THE BAND SELECT P.B. PUSHED?
        BITA    #$20
        BEQ     LOOP53
        RTS
LOOP53  LDX     BAND    POINTER TO BAND FREQUENCIES
        INX             INCREMENT POINTER TO NEXT BAND
        INX
        INX
        INX
        CPX     #$FD4C  END OF BAND TABLE REACHED?
        BEQ     LOOP54  BRANCH IF YES
LOOP56  STX     BAND
        LDD     00,X
        STD     PHASE
        LDD     02,X
        STD     PHASE2
LOOP55  LDAA    PORTD   LOOK FOR BAND SELECT P.B. TO GO BACK OFF
        BITA    #$20
        BEQ     LOOP55
        RTS
LOOP54  LDX     #$FD28  ROLL BAND POINTER BACK TO THE FIRST LOCATION
        BRA     LOOP56
RX      LDAA    IFSTAT
        BITA    #$02    LOOK FOR IFSTAT TO INDICATE DIFFERENCE NOT SUM
        BNE     RX3     BRANCH IF WE WANT DIFFERENCE FREQ. FOR L.O.
        LDD     PHASE2  CALCULATE THE SUM OF SIGNAL AND I.F.
        ADDD    IF+2
        STD     PHARX2
        BCS     RX1
        LDD     PHASE
RX2     ADDD    IF
        STD     PHARX
        RTS
RX1     LDD     PHASE
        ADDD    #$0001
        BRA     RX2
RX3     LDD     PHASE
        CPD     IF
        BLO     RX4
        CPD     IF
        BEQ     RX5
RX11    LDD     PHASE2
        SUBD    IF+2
        STD     PHARX2
        BCS     RX7
        LDD     PHASE
RX8     SUBD    IF
        STD     PHARX
        RTS
RX5     LDD     PHASE2
        CPD     IF+2
        BLO     RX4
        BRA     RX11
RX7     LDD     PHASE
        SUBD    #$0001
        BRA     RX8
RX4     LDD     IF+2
        SUBD    PHASE2
        STD     PHARX2
        BCS     RX9
        LDD     IF
RX10    SUBD    PHASE
        STD     PHARX
        RTS
RX9     LDD     IF
        SUBD    #$0001
        BRA     RX10
RIT     LDAA    ADR1    GET POT ANALOG VALUE
        LSRA            DIVIDE ANALOG VALUE BY 2 TO GET RID OF NOISE
        STAA    RITRAW
        CMPA    #$40
        BHS     RIT1
        LDAA    #$3F
        SUBA    RITRAW
        STAA    RITRAW
        STAA    RITFRQ
        BEQ     RIT2
RIT3    LDD     PHARX2
        SUBD    #$035B  10HZ PHASE VALUE
        STD     PHARX2
        BCS     RIT4
RIT5    DEC     RITRAW
        BNE     RIT3
RIT2    RTS
RIT4    LDD     PHARX
        SUBD    #$0001
        STD     PHARX
        BRA     RIT5
RIT1    SUBA    #$40
        STAA    RITRAW
        STAA    RITFRQ
        BEQ     RIT6
RIT7    LDD     PHARX2
        ADDD    #$035B  10HZ PHASE VALUE
        STD     PHARX2
        BCS     RIT8
RIT9    DEC     RITRAW
        BNE     RIT7
RIT6    RTS
RIT8    LDD     PHARX
        ADDD    #$0001
        STD     PHARX
        BRA     RIT9
RITBCD  LDAA    RITFRQ
        LDAB    #$0A    MULTIPLY RITFRQ TO GET RIT FREQUENCY IN HERTZ
        MUL
        STD     ANS+2
        CLR     ANS
        CLR     ANS+1
        JSR     BCDCON
        LDAA    #$CC    SEND DISPLAY TO 2 ROW LOCATION 13
        STAA    CHAR
        JSR     CONTRL
        LDAA    BCD+2
        JSR     SHOW
        LDAA    BCD+3
        JSR     SHOW
        RTS
MIXDIS  LDAA    #$C9    SEND DISPLAY TO SECOND ROW LOCATION 10
        STAA    CHAR
        JSR     CONTRL
        LDAA    IFSTAT
        BITA    #$01
        BNE     MIX1    BRANCH IF WE ARE DOING THE SUM        
        LDAA    #$20    BLANK DISPLAY CHARACTER
        STAA    CHAR
        JSR     DISLET
        RTS
MIX1    LDAA    #$5E    DISPLAY CHARACTER ^ TO SHOW MIXER IS SUMMING
        STAA    CHAR
        JSR     DISLET
        RTS
SERIAL  CLR     FREQ    FREQ0/FREQ1 FLAG. 0=FREQ0=TX,1=FREQ1=RX REGISTERS
        LDAA    PORTB
        ANDA    #$DF    SET TC0=0=FREQ0=TX FREQ
        STAA    PORTB
SER     LDAA    #$20    ROUTINE TO SEND DELTA PHASE TO AD7008 SERIAL
        STAA    SERCNT
        LDAA    FREQ
        BNE     SER1
        LDD     PHASE
SER2    STD     HOLD
LOOP10  LDD     HOLD
        ASLD
        BCS     LOOP11
        STD     HOLD
        LDAA    PORTB
        ANDA    #$BF    SDATA LINE=0
        STAA    PORTB
        BRA     LOOP12
LOOP11  STD     HOLD
        LDAA    PORTB
        ORAA    #$40    SDATA LINE=1
        STAA    PORTB
LOOP12  ORAA    #$80    BRING SCLK LINE HIGH
        STAA    PORTB
        ANDA    #$7F    BRING SCLK LINE LOW
        STAA    PORTB
        DEC     SERCNT
        LDAA    SERCNT
        CMPA    #$10    DONE PROCESSING FIRST 16 BITS?
        BEQ     LOOP13
        CMPA    #$00    DONE PROCESSING ALL 32 BITS?
        BEQ     LOOP14
        BRA     LOOP10
LOOP13  LDAA    FREQ
        BNE     SER3
        LDD     PHASE2
SER4    STD     HOLD
        BRA     LOOP10
LOOP14  LDAA    PORTB
        ORAA    #$10    BRING LOAD LINE HIGH 
        STAA    PORTB
        ANDA    #$EF    BRING LOAD LINE LOW
        STAA    PORTB
        LDAA    FREQ
        BEQ     SER5
        RTS
SER1    LDD     PHARX
        BRA     SER2
SER3    LDD     PHARX2
        BRA     SER4
SER5    INC     FREQ
        LDAA    PORTB
        ORAA    #$20
        STAA    PORTB
        BRA     SER

DIVIDE  LDD     #$0000  CLEAR ANSWER REGISTER
        STD     ANS
        STD     ANS+2
        LDD     PHASE    TRANSFER PHASE VALUE INTO WORKING BYTE REGISTERS
        STD     BYTE
        LDD     PHASE2
        STD     BYTE+2
        LDX     #$FD00
LOOP21  LDD     BYTE
        CPD     00,X
        BHI     LOOP22
        BEQ     LOOP23
LOOP15  LDAB    #$08
        ABX
        CPX     #$FD28  DONE CONVERTING PHASE TO FREQ?
        BNE     LOOP21
        LDAA    #$C0    SEND DISPLAY TO FIRST LOCATION OF ROW 2
        STAA    CHAR
        JSR     CONTRL
        RTS
LOOP22  LDD     BYTE+2
        SUBD    02,X
        BCS     LOOP25
        STD     BYTE+2
LOOP26  LDD     BYTE
        SUBD    $00,X
        STD     BYTE
        LDD     ANS+2
        ADDD    $06,X
        STD     ANS+2
        BCS     LOOP27
LOOP28  LDD     ANS
        ADDD    $04,X
        STD     ANS
        BRA     LOOP21
LOOP25  STD     BYTE+2
        LDD     BYTE
        SUBD    #$01
        STD     BYTE
        BRA     LOOP26
LOOP27  LDD     ANS
        ADDD    #$0001
        STD     ANS
        BRA     LOOP28
LOOP23  LDD     BYTE+2
        CPD     $02,X
        BHS     LOOP22
        BRA     LOOP15
BCDCON  LDX     #BCD
        CLR     03,X
        CLR     02,X
        CLR     01,X
        CLR     00,X
        LDAA    #$20
        STAA    BCDCTR
L20     LDAA    03,X
        BSR     CALC
        STAB    03,X
        LDAA    02,X
        BSR     CALC
        STAB    02,X
        LDAA    01,X
        BSR     CALC
        STAB    01,X
        LDAA    00,X
        BSR     CALC
        STAB    00,X
        ASL     07,X
        ROL     06,X
        ROL     05,X
        ROL     04,X
        ROL     03,X
        ROL     02,X
        ROL     01,X
        ROL     00,X
        DEC     BCDCTR
        BNE     L20
        RTS
CALC    TAB
        ANDA    #$0F
        SUBA    #$05
        BMI     L14
        ADDB    #$03
L14     TBA
        ANDA    #$F0
        SUBA    #$50
        BMI     L15
        ADDB    #$30
L15     RTS
RATES   LDAA    PORTA
        BITA    #$04    LOOK FOR 10 HERTZ PER STEP INPUT
        BEQ     LOOP40
        LDAA    PORTA
        BITA    #$80    LOOK FOR .1 MHZ PER STEP INPUT
        BEQ     LOOP41
        LDD     #$01    SET RATE FOR 1000 HERTZ PER STEP
        STD     RATE
        LDD     #$4F8B
        STD     RATE+2
        RTS
LOOP40  LDD     #$00    SET RATE FOR 10 HERTZ PER STEP
        STD     RATE
        LDD     #$035B
        STD     RATE+2
        RTS
LOOP41  LDD     #$83    SET RATE FOR .1 MHZ PER STEP
        STD     RATE
        LDD     #$126E
        STD     RATE+2
        RTS
BCDDIS  LDAA    BCD
        JSR     SHOW
        LDAA    BCD+1
        JSR     SHOW
        LDAA    BCD+2
        JSR     SHOW
        LDAA    BCD+3
        JSR     SHOW
        RTS
SHOW    STAA    TEMP    TAKES HEX REG. VALUE & CONVERTS TO MSD & LSD
        ANDA    #$F0
        LSRA
        LSRA
        LSRA
        LSRA
        BSR     CONVRT
        LDAA    TEMP
        ANDA    #$0F
        BSR     CONVRT
        RTS
CONVRT  CMPA    #$09    CONVERT FROM HEX TO ASCII VALUE FOR LCD DISPLAY
        BHI     LOOP30  BRANCH WHEN NUMBER GREATER THEN 9
        ADDA    #$30    CONVERT 0 THRU 9 TO ASCII VALUE
        STAA    CHAR
        JSR     DISLET
        RTS
LOOP30  ADDA    #$37    CONVERT A THRU F TO ASCII VALUE
        STAA    CHAR
        JSR     DISLET
        RTS

LCDINT  JSR     DELAY
        JSR     DELAY
        JSR     DELAY
        JSR     DELAY
        JSR     DELAY
        LDAA    #$03
        JSR     CSTROB
        JSR     DELAY
        LDAA    #$03
        JSR     CSTROB
        JSR     DELAY
        LDAA    #$03
        JSR     CSTROB
        JSR     DELAY   *MODIFIED WAS BUSY
        LDAA    #$02
        JSR     CSTROB
        JSR     DELAY   *MODIFIED WAS BUSY
        LDAA    #$28
        STAA    CHAR
        JSR     CONTRL
        LDAA    #$0E
        STAA    CHAR
        JSR     CONTRL
        LDAA    #$01
        STAA    CHAR
        JSR     CONTRL
        LDAA    #$06
        STAA    CHAR
        JSR     CONTRL
        RTS
CSTROB  STAA    PORTC
        ORAA    #$40
        STAA    PORTC
        ANDA    #$3F
        STAA    PORTC
        RTS
DELAY   LDX     #$01FF
LOOP1   NOP
        NOP
        NOP
        NOP
        NOP
        DEX
        BEQ     LOOP2
        JMP     LOOP1
LOOP2   RTS
BUSY    LDAA    #$77
        STAA    DDRC
HOP1    LDAA    #$10
        STAA    PORTC
        ORAA    #$40
        STAA    PORTC
        LDAA    PORTC
        ANDA    #$08
        BNE     HOP2
        LDAA    #$10
        STAA    PORTC
        ORAA    #$40
        STAA    PORTC
        ANDA    #$3F
        STAA    PORTC
        LDAA    #$7F
        STAA    DDRC
        RTS
HOP2    LDAA    #$10
        STAA    PORTC
        ORAA    #$40
        STAA    PORTC
        ANDA    #$3F
        STAA    PORTC
        JMP     HOP1
CONTRL  LDAA    CHAR
        ANDA    #$0F
        STAA    LOBYTE
        LDAA    CHAR
        ANDA    #$F0
        LSRA
        LSRA
        LSRA
        LSRA
        STAA    PORTC
        ORAA    #$40
        STAA    PORTC
        ANDA    #$3F
        STAA    PORTC
        LDAA    LOBYTE
        STAA    PORTC
        ORAA    #$40
        STAA    PORTC
        ANDA    #$3F
        STAA    PORTC
        JSR     BUSY
        RTS
DISLET  LDAA    CHAR
        ANDA    #$0F
        STAA    LOBYTE
        LDAA    CHAR
        ANDA    #$F0
        LSRA
        LSRA
        LSRA
        LSRA
        ORAA    #$20
        STAA    PORTC
        ORAA    #$40
        STAA    PORTC
        ANDA    #$3F
        STAA    PORTC
        LDAA    LOBYTE
        ORA     #$20
        STAA    PORTC
        ORAA    #$40
        STAA    PORTC
        ANDA    #$3F
        STAA    PORTC
        JSR     BUSY
        RTS
*PHASE VS FREQ. VALUES FOR CALCULATING FREQ. FROM PHASE VALUE
        ORG     $FD00
        FCB     $05,$1E,$B8,$52 PHASE VALUE FOR 1,000,000.001 HZ
        FCB     $00,$0F,$42,$40 FREQUENCY VALUE FOR 1,000,000 HZ
        FCB     $00,$0D,$6C,$FB PHASE VALUE FOR 10243.0000 HZ
        FCB     $00,$00,$28,$03 FREQUENCY VALUE FOR 10243 HZ
        FCB     $00,$00,$35,$5A PHASE VALUE FOR 159.0000466 HZ
        FCB     $00,$00,$00,$9F FREQUENCY VALUE FOR 159 HZ
        FCB     $00,$00,$03,$5B PHASE VALUE FOR 10.00007615 HZ
        FCB     $00,$00,$00,$0A FREQUENCY VALUE FOR 10 HZ
        FCB     $00,$00,$00,$56 PHASE VALUE FOR 1.001171768 HZ
        FCB     $00,$00,$00,$01 FREQUENCY VALUE FOR 1 HZ
*PHASE VS START OF BAND FOR BAND SELECT P.B.
        ORG     $FD28
        FCB     $09,$37,$4B,$C7 PHASE VALUE FOR 1.8 MHZ 
        FCB     $11,$EB,$85,$20 PHASE VALUE FOR 3.5 MHZ
        FCB     $23,$D7,$0A,$3E PHASE VALUE FOR 7 MHZ
        FCB     $33,$B6,$45,$A3 PHASE VALUE FOR 10.1 MHZ
        FCB     $47,$AE,$14,$7C PHASE VALUE FOR 14 MHZ
        FCB     $5C,$82,$16,$C8 PHASE VALUE FOR 18.068 MHZ
        FCB     $6B,$85,$1E,$BA PHASE VALUE FOR 21 MHZ
        FCB     $7F,$6F,$D2,$23 PHASE VALUE FOR 24.89 MHZ
        FCB     $8F,$5C,$28,$F8 PHASE VALUE FOR 28 MHZ 
*ROUTINE TO LOAD BURN ROUTINE INTO RAM
        ORG     $FD60
LOAD    LDX     #$FD79
        LDY     #$0000
LOAD1   LDAA    00,X
        STAA    00,Y
        INX
        INY
        CPX     #$FDC5  END OF BURN ROUTINE IN EEPROM REACHED?
        BEQ     LOAD2
        BRA     LOAD1
LOAD2   JMP     $0000   JUMP TO BURN ROUTINE IN LOADED IN RAM
*EEPROM BURN ROUTINE THAT MUST BE LOADED INTO RAM BEFORE RUNNING
        ORG     $FD79
        LDX     #$FFB0  EEPROM ROW TO ERASE
ERASE   LDAB    #$0E
        STAB    $103B
        STAB    00,X
        LDAB    #$0F
        STAB    $103B
        BSR     DLY10
        CLR     $103B
BURN    LDX     #$FFB0
        LDY     #$009B  START LOCATION OF IF PHASE VALUE IN RAM
BURN1   LDAA    00,Y
        LDAB    #$02
        STAB    $103B
        STAA    00,X
        LDAB    #$03
        STAB    $103B
        BSR     DLY10
        CLR     $103B
        INX
        INY
        CPY     #$009F
        BNE     BURN1
        RTS
*10 MSEC DELAY SUBROUTINE FOR EEPROM BURNING
DLY10   LDAA    #$06
DLY2    LDAB    #$FF
DLY1    NOP
        NOP
        NOP
        DECB
        BEQ     DLY3
        BRA     DLY1
DLY3    DECA
        BEQ     DLY4
        BRA     DLY2
DLY4    RTS


*EEPROM STORAGE OF I.F. FREQUENCY PROGRAMMED BY USER USING I.F. PUSH BUTTON
        ORG     $FFB0
        FCB     $00,$00,$00,$00

*START UP VECTOR
        ORG     $FFFE
        FCB     $F8,$00
        END









                                

