;
; Program to control 2 Harris HSP45102 NCOs
;
; Copyright 1999-2000 John B. Stephensen
;
; This software in source, object or binary form is licensed only for personal non-profit
; educational use in the Amateur Radio Service and the license is not transferrable. The
; software is provided as-is for experimental purposes and the author does not warranty
; its freedom from defects or its suitability for any specific application. 
;
;  Written for use with Microchip MPASM v02.15
;
;	7-1-99	eliminated use of TXFER - use separate SCLK output from MCU for each NCO
;	3-14-00	start commands with SOH to differentiate from reponses on HDX line
;
; HSP45102 date code must exceed 9700 - previous mask had defect in shift register wiring
; and can only be shifted in one direction (reverse of that used here)
;
;Requires 7.3728 MHz crystal on oscillator pins.
;Accepts data from asynch. port and loads into NCO.
;
	LIST	P=16F84
	RADIX 	DEC
	__CONFIG 0x3FF2
;
; PIC registers
;
OPTREG	EQU	0x81	;OPTION
;
ADDRESS	EQU	0x81	;address of this device
;
FSR	EQU	4	;indirect address pointer
INDF	EQU	0	;access to use indirect address
STATUS	EQU	3	;status register
CARRY	EQU	0	;carry bit
ZERO	EQU	2	;zero bit
RA	EQU	5	;PORT A - filter select
TRISA	EQU	0x85	;TRIS A
RB	EQU	6	;PORT B - DDS control and UART input
TRISB	EQU	0x86	;TRIS B
TEST1	EQU	7	;signal user frame received
TEST	EQU	6	;signal user bit sampled
UARTOUT	EQU	5	;serial data out
UART	EQU	4	;serial data in
TXENA	EQU	3	;transfer enable - active low
DTA	EQU	2	;DDS data
CLK2	EQU	1	;LO DDS clock - active on low to high transition
CLK1	EQU	0	;BFO DDS clock - active on low to high transition
;
; PIC RAM
;
CTR	EQU	0x10	;wait loop counter
BITS	EQU	0x11	;UART bit accumulator
BCTR	EQU	0x12	;UART bit counter
LONGPAR	EQU	0x13	;frame longitudinal parity accum.
;
;the following 6 loactions contain the received command
CTL	EQU	0x14	;control byte
;numeric values stores LS bit first in following registers
DT1	EQU	0x15	;1st data byte
DT2	EQU	0x16	;2nd data byte
DT3	EQU	0x17	;3rd data byte
DT4	EQU	0x18	;4th data byte
DT5	EQU	0x19	;5th data byte
DT6	EQU	0x1A
DT7	EQU	0x1B
DT8	EQU	0x1C
DT9	EQU	0x1D
DT10	EQU	0x1E
;
CTR1	EQU	0x1F
;Transmit and receive LO frequencies
RX1	EQU	0x20
RX2	EQU	0x21
RX3	EQU	0x22
RX4	EQU	0x23
TX1	EQU	0x24
TX2	EQU	0x25
TX3	EQU	0x26
TX4	EQU	0x27
;Transmit and receive BFO frequencies
RB1	EQU	0x28
RB2	EQU	0x29
RB3	EQU	0x2A
RB4	EQU	0x2B
TB1	EQU	0x2C
TB2	EQU	0x2D
TB3	EQU	0x2E
TB4	EQU	0x2F
;ASCII control characters
NUL	EQU	0
SOH	EQU	1
STX	EQU	2
ETX	EQU	3
ACK	EQU	6
DLE	EQU	0x10
NAK	EQU	0x15
SYN	EQU	0x16
DEL	EQU	0x7F
;commands recognized by this program
CRXF	EQU	'R'
CTXF	EQU	'T'
CFREQ	EQU	'F'
CRXB	EQU	'r'
CTXB	EQU	't'
CBFO	EQU	'f'
CFIL	EQU	'B'
;
	ORG	0x000
;
	NOP
	NOP
	NOP
	NOP
;
	MOVLW	0x00	;pullups on
	OPTION
;
	MOVLW	0x10	;RA0-3 outputs, RA4 input
	TRIS	RA
	CLRF	RA	;clear RA0-3
;
	MOVLW	0x10	;RB0-3,5-7 outputs, RB4 input
	TRIS	RB
	MOVLW	0x28	;set UART out and TXFER pins high (inactive)
	MOVWF	RB
;
	CALL	WAIT
;
START	CALL	RCVF	;wait for a command
	MOVF	CTL,W	;put control byte in W
	XORLW	CFREQ
	BTFSC	STATUS,ZERO
	CALL	SETLO
	MOVF	CTL,W	;put control byte in W
	XORLW	CRXF
	BTFSC	STATUS,ZERO
	CALL	SETRXLO
	MOVF	CTL,W	;put control byte in W
	XORLW	CTXF
	BTFSC	STATUS,ZERO
	CALL	SETTXLO
	MOVF	CTL,W	;put control byte in W
	XORLW	CBFO
	BTFSC	STATUS,ZERO
	CALL	SETBFO
	MOVF	CTL,W	;put control byte in W
	XORLW	CRXB
	BTFSC	STATUS,ZERO
	CALL	SETRXB
	MOVF	CTL,W	;put control byte in W
	XORLW	CTXB
	BTFSC	STATUS,ZERO
	CALL	SETTXB
;	MOVF	CTL,W	;put control byte in W
;	XORLW	CFIL
;	BTFSC	STATUS,ZERO
;	CALL	SETFIL
	GOTO	START
;
;subroutine to receive a frame of data from PC
;
; frame is SOH, command, 
; 8 data bytes, ETX and LRC
;
RCVF	MOVLW	CTL	;point to beginning of buffer
	MOVWF	FSR
	MOVLW	10	;max. 10 bytes
	MOVWF	BCTR
	CLRF	LONGPAR
	CALL	RCVB	;first byte must be SOH
	XORLW	SOH
	BTFSS	STATUS,ZERO
	GOTO	RCVF	;try again if not SOH
RCVLOOP	DECF	BCTR,F	;abort if too many characters
	BTFSC	STATUS,ZERO
	GOTO	RCVF
	CALL	RCVB	;collect character
	MOVWF	INDF	;and store in next byte of buffer 
	INCF	FSR,F
	XORWF	LONGPAR,F ;add to LRC
	XORLW	ETX	;check for end
	BTFSS	STATUS,ZERO
	GOTO	RCVLOOP	;this loop takes 12 instr. cycles (1/8 bit)
	CALL	RCVB	;get and test LRC
	XORWF	LONGPAR,W
	BTFSS	STATUS,ZERO
	GOTO	RCVF	;abort if incorrect
	BSF	RB,TEST1	;else tell user
	BCF	RB,TEST1
	RETURN
;
;subroutine to receive one byte from RS-232 port
;
; set for 19,200 b/s: 1 bit = 96 instruction cycles
; with 7.3728 MHz crystal
;
RCVB	CLRF	BITS	;zero bit accumulator
	MOVLW	8	;set up for 8 bits
	MOVWF	BCTR
RCV0	BTFSC	RB,4	;test for start bit
	GOTO	RCV0	;loop takes 3 cycles
;
	NOP
	NOP		;wait 1/2 bit times
	MOVLW	14	;46 more cycles
	MOVWF	CTR
RCV1	DECFSZ	CTR,F	;each loop is 3 cycles
	GOTO	RCV1	
;
	BTFSC	RB,4	;if still there then data follows
	GOTO	RCVB	;else start over	
;
	NOP		;add 6 cycles on entry 
	NOP		;to make 1 bit time
	NOP		;or 93 cycles
	NOP
	NOP
	NOP
;
RCV2	NOP		;wait 87 cycles
	MOVLW	28	
	MOVWF	CTR
RCV3	DECFSZ	CTR,F	;each loop is 3 cycles
	GOTO	RCV3	
;
	MOVLW	0x10	;mask for bit 4 - this is a cycle
	ANDWF	RB,W	;get bit 4 of port b
	IORWF	BITS,F	;add to data byte
	BSF	RB,TEST	;signal user
	BCF	RB,TEST
	RRF	BITS,F	;make space for another bit
	DECFSZ	BCTR,F	;get another bit if more coming
	GOTO	RCV2	;this took 9 cycles
;
	RLF	BITS,F	;move over 4 bits so aligned
	RLF	BITS,F	
	RLF	BITS,F	
	RLF	BITS,F	
	MOVF	BITS,W	;put in W to return
RCV4	BTFSS	RB,4	;wait for start of framing bit
	GOTO	RCV4	
	RETURN		;and then return
;
;subroutine to send one byte via RS-232 port
;
; set for 19,200 b/s: 1 bit = 96 instruction cycles
; with 7.3728 MHz crystal
;
SNDB	MOVWF	BITS	;save byte to send
	MOVLW	8	;set up for 8 bits
	MOVWF	BCTR
	BCF	RB,UARTOUT	;send start bit
	NOP		;add 5 cycles on entry 
	NOP		;to make 1 bit time
	NOP		;or 95-97 cycles before next bit
	NOP
	NOP
;
SNDB2	NOP		;wait 1 bit time
	NOP		;or 88 more cycles
	MOVLW	28	
	MOVWF	CTR
SNDB3	DECFSZ	CTR,F	;each loop is 3 cycles
	GOTO	SNDB3	
;
	BTFSS	BITS,0	;test for 0
	BCF	RB,UARTOUT	;and send it
	BTFSC	BITS,0	;test for 1
	BSF	RB,UARTOUT	;and send it
	RRF	BITS,F	;get another bit
	DECFSZ	BCTR,F	;check if all sent
	GOTO	SNDB2	;this took 8 cycles
;
	NOP		;wait 91 more cycles
	NOP
	MOVLW	29	
	MOVWF	CTR
SNDB4	DECFSZ	CTR,F	;each loop is 3 cycles
	GOTO	SNDB4	
	BSF	RB,UARTOUT	;send stop bit
;	
	MOVLW	28	;wait 87 more cycles
	MOVWF	CTR
	NOP
SNDB5	DECFSZ	CTR,F	;each loop is 3 cycles
	GOTO	SNDB5	
	RETURN		;and then return
;
;Subrotine to pack nibbles into bytes - LSB first
; Input: DT1-8
; Output: 4 bytes pointed to by FSR
;
PACK	MOVF	DT1,W	;get LS nibble into LS bits
	ANDLW	0x0F
	MOVWF	INDF
	SWAPF	DT2,W	;get MS nibble into MS bits
	ANDLW	0xF0
	IORWF	INDF,F
	INCF	FSR,F
	MOVF	DT3,W	;get LS nibble into LS bits
	ANDLW	0x0F
	MOVWF	INDF
	SWAPF	DT4,W	;get MS nibble into MS bits
	ANDLW	0xF0
	IORWF	INDF,F
	INCF	FSR,F
	MOVF	DT5,W	;get LS nibble into LS bits
	ANDLW	0x0F
	MOVWF	INDF
	SWAPF	DT6,W	;get MS nibble into MS bits
	ANDLW	0xF0
	IORWF	INDF,F
	INCF	FSR,F
	MOVF	DT7,W	;get LS nibble into LS bits
	ANDLW	0x0F
	MOVWF	INDF
	SWAPF	DT8,W	;get MS nibble into MS bits
	ANDLW	0xF0
	IORWF	INDF,F
	RETURN
;
;Set TX/RX frequency routine - copy to TX and RX regs and send
;
SETLO	MOVLW	RX1	;set indirect address register
	MOVWF	FSR	;to 1st byte of frequency
	CALL	PACK	;copy nibbles from DT1-8 to bytes xx1-4
	MOVLW	TX1	;set indirect address register
	MOVWF	FSR	;to 1st byte of frequency
	CALL	PACK	;copy nibbles from DT1-8 to bytes xx1-4
	CALL	SETDDS1	;send to DDS
;	MOVLW	ACK
;	CALL	SNDB	;acknowledge command
	RETURN
;
SETRXLO	MOVLW	RX1	;set indirect address register
	MOVWF	FSR	;to 1st byte of frequency
	CALL	PACK	;copy nibbles from DT1-8 to bytes RX1-4
	CALL	SETDDS1	;send to DDS
;	MOVLW	ACK
;	CALL	SNDB	;acknowledge command
	RETURN
;
SETTXLO	MOVLW	TX1	;set indirect address register
	MOVWF	FSR	;to 1st byte of frequency
	CALL	PACK	;copy nibbles from DT1-8 to bytes TX1-4
	CALL	SETDDS1	;send to DDS
;	MOVLW	ACK
;	CALL	SNDB	;acknowledge command
	RETURN
;
;Set BFO frequency routine - copy to TX and RX regs and send
;
SETBFO	MOVLW	RB1	;set indirect address register
	MOVWF	FSR	;to 1st byte of frequency
	CALL	PACK	;copy nibbles from DT1-8 to bytes xx1-4
	MOVLW	TB1	;set indirect address register
	MOVWF	FSR	;to 1st byte of frequency
	CALL	PACK	;copy nibbles from DT1-8 to bytes xx1-4
	CALL	SETDDS2	;send to DDS
;	MOVLW	ACK
;	CALL	SNDB	;acknowledge command
	RETURN
;
SETRXB	MOVLW	RB1	;set indirect address register
	MOVWF	FSR	;to 1st byte of frequency
	CALL	PACK	;copy nibbles from DT1-8 to bytes RB1-4
	CALL	SETDDS2	;send to DDS
;	MOVLW	ACK
;	CALL	SNDB	;acknowledge command
	RETURN
;
SETTXB	MOVLW	TB1	;set indirect address register
	MOVWF	FSR	;to 1st byte of frequency
	CALL	PACK	;copy nibbles from DT1-8 to bytes TB1-4
	CALL	SETDDS2	;send to DDS
;	MOVLW	ACK
;	CALL	SNDB	;acknowledge command
	RETURN
;
;Select Filter routine
;
SETFIL	MOVF	DT1,W	;write data byte to port A
	ANDLW	0x0F
	MOVWF	RA	;RA0-3 select filters
;	MOVLW	ACK
;	CALL	SNDB	;acknowledge command
	RETURN
;
; delay routine - 284.5 ms
;
WAIT	CLRF	CTR
	CLRF	CTR1
WAIT0	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	DECFSZ	CTR,F
	GOTO	WAIT0
	DECFSZ	CTR1,F
	GOTO	WAIT0
	RETURN
;
; SETDDS subroutine
;
; sends data bits to DDS chip, 8 bits per byte
;
SETDDS1	BSF	RB,TXENA ;disable data transfer to phase accumulator
	MOVLW	RX1	;set indirect address register
	MOVWF	FSR	;to 1st byte to send
	CALL	SND1	;send 8 x 8 bits
	INCF	FSR,F
	CALL	SND1
	INCF	FSR,F
	CALL	SND1
	INCF	FSR,F
	CALL	SND1
	INCF	FSR,F
	CALL	SND1	
	INCF	FSR,F
	CALL	SND1
	INCF	FSR,F
	CALL	SND1
	INCF	FSR,F
	CALL	SND1
	BCF	RB,TXENA ;transfer to phase accum.
	RETURN
;
SETDDS2	BSF	RB,TXENA ;disable data transfer to phase accumulator
	MOVLW	RB1	;set indirect address register
	MOVWF	FSR	;to 1st byte to send
	CALL	SND2	;send 8 x 8 bits
	INCF	FSR,F
	CALL	SND2
	INCF	FSR,F
	CALL	SND2
	INCF	FSR,F
	CALL	SND2
	INCF	FSR,F
	CALL	SND2	
	INCF	FSR,F
	CALL	SND2
	INCF	FSR,F
	CALL	SND2
	INCF	FSR,F
	CALL	SND2
	BCF	RB,TXENA ;transfer to phase accum.
	RETURN
;
;subroutine to send 8 bits (LSB first) to DDS
;
SND1	MOVLW	8	;normally, send 8 bits
	MOVWF	BCTR
SNDNXT1	RRF	INDF,F
	CALL	SNDBIT1
	DECFSZ	BCTR,F
	GOTO	SNDNXT1
	RRF	INDF,F	;put bits in original position
	RETURN
;
SND2	MOVLW	8	;normally, send 8 bits
	MOVWF	BCTR
SNDNXT2	RRF	INDF,F
	CALL	SNDBIT2
	DECFSZ	BCTR,F
	GOTO	SNDNXT2
	RRF	INDF,F	;put bits in original position
	RETURN
;
; Subroutines to send carry bit, 0, 1 and enable pulse to DDS
;
SONE1	BSF	RB,DTA	;set data pin
	NOP
	BSF	RB,CLK1	;generate clock pulse
	BCF	RB,CLK1
	RETURN
;
SNDBIT1	BTFSC	STATUS,CARRY ;check for one/zero
	GOTO	SONE1
SZERO1	BCF	RB,DTA	;reset data pin
	NOP
	BSF	RB,CLK1	;generate clock pulse
	BCF	RB,CLK1
	RETURN
;
SONE2	BSF	RB,DTA	;set data
	NOP
	BSF	RB,CLK2	;generate clock pulse
	BCF	RB,CLK2
	RETURN
;
SNDBIT2	BTFSC	STATUS,CARRY
	GOTO	SONE2
SZERO2	BCF	RB,DTA	;reset data
	NOP
	BSF	RB,CLK2	;generate clock pulse
	BCF	RB,CLK2
	RETURN
;
; Copyright 1999-2000 John B. Stephensen
;
	END
