DECLARE SUB Delay (dly!)

'This program should demonstrate how to use all functions of the
'Hagtronics PIC DAS using QBasic

CLS

PRINT "Hagtronics PIC DAS QBasic Demonstration Program"
PRINT "Version: 3Aug00, By: Steve Hageman"

'Standard open com port command, you maay need to change the COM1 to
'match the COM port that the PIC DAS is connected to
'The extra parameters here disable all the hardware timeouts
'When the COM port is opened the DTR line is enabled which turns on
'the PIC DAS, to turn off the PIC DAS, close the COM port again
'Opening the COM port also clears the TX and RX buffers
OPEN "COM2:9600,N,8,1,CD0,CS0,DS0,OP0,RS," FOR RANDOM AS #1

'Wait for 1 second for the PIC DAS to start after the COM port opens
Delay (10000)

'===== Get the firmware version
PRINT #1, "VER"
Delay (10000)     'This line is needed to slow down a 700 MHz Pentium!
LINE INPUT #1, ver$
PRINT "PIC DAS Firmware Version String = "; ver$

'=====< Digital Functions >=====

'===== Set the Digital I/O to all outputs
PRINT #1, "DIR 0"
'Note: Even though the DIR command returns no parameters we
'still need to remove the CR that the PIC DAS sent back when
'it completed the command
LINE INPUT #1, ret$
'The following print statements are optional, they just show
'if something went wrong
PRINT ret$

'===== Set all bits high
PRINT #1, "OUT 255"
LINE INPUT #1, ret$
PRINT ret$

'===== Set MSB on, all other bits off
PRINT #1, "OUT 128"
LINE INPUT #1, ret$
PRINT ret$

'===== Set LSB on all other bits off
PRINT #1, "OUT 1"
LINE INPUT #1, ret$
PRINT ret$

'===== Set all bits off
PRINT #1, "OUT 0"
LINE INPUT #1, ret$
PRINT ret$

'===== Set all bits as input
PRINT #1, "DIR 255"
LINE INPUT #1, ret$
PRINT ret$

'===== Set pullups on
PRINT #1, "PULLUP 1"
LINE INPUT #1, ret$
PRINT ret$

'===== Read I/O port, should be 255
PRINT #1, "IN"
LINE INPUT #1, ret$
PRINT "I/O Port (pullups on) = "; ret$

'===== Read bit 0, should be 1
PRINT #1, "BIN"
LINE INPUT #1, ret$
PRINT "Bit 0 Input (pullups on) = "; ret$

'===== Set pullups off
PRINT #1, "PULLUP 0"
LINE INPUT #1, ret$
PRINT ret$

'===== Read I/O port, should be 0
PRINT #1, "IN"
LINE INPUT #1, ret$
PRINT "I/O Port (pullups off) = "; ret$

'===== Read bit 0, should be 0
PRINT #1, "BIN"
LINE INPUT #1, ret$
PRINT "Bit 0 Input (pullups off) = "; ret$

'===== Set direction to all outputs
PRINT #1, "DIR 0"
LINE INPUT #1, ret$
PRINT ret$

'===== Set bit 0
PRINT #1, "BSET 0"
LINE INPUT #1, ret$
PRINT ret$

'===== Clear bit 0
PRINT #1, "BCLEAR 0"
LINE INPUT #1, ret$
PRINT ret$

'===== Count to 255 on output port
PRINT #1, "DIR 0"
LINE INPUT #1, ret$
PRINT ret$

FOR i% = 0 TO 255
        PRINT #1, "OUT "; i%
        LINE INPUT #1, ret$
NEXT i%

'===== Turn I/O port off (all zeros)
PRINT #1, "OUT 0"
LINE INPUT #1, ret$


'=====< Analog I/O >=====

'===== Set DAC CH 0 to 2.5 volts
PRINT #1, "AO 0 2500"
LINE INPUT #1, ret$
PRINT ret$


'===== Read A/D channel 0, 100 times
'If A/D 0 is connected to DAC 0, it should return
'the code 2500
FOR i% = 1 TO 100
        ret$ = ""
        PRINT #1, "AI 0"
        LINE INPUT #1, ret$
        PRINT i%, ret$
NEXT i%

'===== Ramp DAC 0, 5 times
PRINT "Writing to DAC"
FOR i% = 0 TO 5
        FOR code% = 0 TO 4095 STEP 100
                PRINT #1, "AO 0 "; code%
                LINE INPUT #1, ret$
        NEXT code%
NEXT i%

'===== That's all folks!
PRINT "End of test program..."

'===== Close the COM port
CLOSE #1

END

SUB Delay (dly!)
        FOR i! = 0 TO dly!
        NEXT i!
END SUB

