//
//    Copyright 2004, Thomas C. McDermott, N5EG
//    This file is part of VNAR - the Vector Network Analyzer program.
//
//    VNAR is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    VNAR is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with VNAR, if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//

#pragma once

// DataDisplay.h -- contains the VNA BUFFER typedefs.
// Defines the format of the USB packets to and from the VNA

#include "stdafx.h"

// FORMAT of the Response:
//
//  Offset  Word (LSB first, MSB second)		Condition
//  ------  -------------------------------     --------------
//	0000    0100 								Valid frame
//  0002    S11M S11P VREF1 S21M S21P VREF2 	Ref=I, TX=REFL
//  000E    S11M S11P							Ref=I, TX=FWD
//  0012    S11M S11P VREF1 S21M S21P VREF2		Ref=Q, TX=REFL
//  001E    S11M S11P							Ref=Q, TX=FWD
//  0022	remainder of frame all zeros


typedef struct _VNA_RXBUFFER {
	unsigned short Header;
	unsigned short ReflMI;
	unsigned short ReflPI;
	unsigned short Vref1;
	unsigned short TranMI;
	unsigned short TranPI;
	unsigned short Vref2;
	unsigned short FwdMI;
	unsigned short FwdPI;
	unsigned short ReflMQ;
	unsigned short ReflPQ;
	unsigned short Vref1a;
	unsigned short TranMQ;
	unsigned short TranPQ;
	unsigned short Vref2a;
	unsigned short FwdMQ;
	unsigned short FwdPQ;
	unsigned short fill[3];		// force double word alignment for
	__int64		   Freq;		// the __int64
	unsigned short dummy[8];	// unused locations in the buffer
} VNA_RXBUFFER;

typedef struct _VNA_TXBUFFER {
	__int64 TxAccum;			// 8 byte accumulator value (we use 6 LSBytes)
	unsigned short IDAClevel;	// 2 byte I-DAC (Transmit) level
	unsigned short QDAClevel;	// 2 byte Q-DAC (Reference) level
	unsigned short ReplyType;		// Rx buffer reply type requested (0 = normal buffer)
	unsigned short IntegrationCount;	// How many times for target to integrate
								// should have a value of 1, 2, 4, 8, or 16
	__int64 Freq2;				// TxAccumulator values for multi-freq reads (type > 0)
	__int64 Freq3;
	__int64 Freq4;
	__int64 Freq5;
	__int64 Freq6;
	__int64 Freq7;
} VNA_TXBUFFER;


