//
//    Copyright 2004, Thomas C. McDermott, N5EG
//    This file is part of VNAR - the Vector Network Analyzer program.
//
//    VNAR is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    VNAR is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with VNAR, if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//

#pragma once

#include "DisplayRoutines.h"
#include "USB_EZ_interface.h"
#include <math.h>

using namespace System;
using namespace System::ComponentModel;
using namespace System::Collections;
using namespace System::Windows::Forms;
using namespace System::Data;
using namespace System::Drawing;
using namespace System::IO;


namespace VNAR2
{
	/// <summary> 
	/// Summary for InstrumentCal
	///
	/// WARNING: If you change the name of this class, you will need to change the 
	///          'Resource File Name' property for the managed resource compiler tool 
	///          associated with all .resx files this class depends on.  Otherwise,
	///          the designers will not be able to interact properly with localized
	///          resources associated with this form.
	/// </summary>
	public __gc class InstrumentCal : public System::Windows::Forms::Form
	{
	public: 
		InstrumentCal(CalDataSet* CalDS, VNADevice* VNADev, String* StartDir)
		{
			InitializeComponent();
			VNA = VNADev;			// VNA hardware device
			Cal = CalDS;			// Calibration Dataset
			StartUpDir = StartDir;	// Directory where execution started
			Iphase = new int __gc[1024];	// allocate space to hold phase measurements
			Qphase = new int __gc[1024];
			Mag = new int __gc[21, 4];		// allocate space to hold amplitude measurements 
		}
        
	protected: 
		void Dispose(Boolean disposing)
		{
			if (disposing && components)
			{
				components->Dispose();
			}
			__super::Dispose(disposing);
		}
	private: System::Windows::Forms::Label *  label1;
	private: System::Windows::Forms::Button *  OKbutton;
	private: System::Windows::Forms::Button *  Cancelbutton;


	private: System::Windows::Forms::Label *  label2;


	private: System::Windows::Forms::Label *  label3;
	private: System::Windows::Forms::Button *  RxPhaseButton;
	private: System::Windows::Forms::Button *  RxAmpButton;
	private: System::Windows::Forms::Button *  TxPhaseButton;
	private: System::Windows::Forms::Button *  TxAmpButton;
	private: System::Windows::Forms::Label *  label4;
	private: System::Windows::Forms::Label *  label5;
	private: System::Windows::Forms::Label *  RxPhaseStat;
	private: System::Windows::Forms::Label *  RxAmpStat;
	private: System::Windows::Forms::Label *  TxPhaseStat;
	private: System::Windows::Forms::Label *  TxAmpStat;
	private: System::Windows::Forms::ProgressBar *  progressBar1;
	private: System::Windows::Forms::Label *  label6;
	private: System::Windows::Forms::Label *  label7;

	private:
		/// <summary>
		/// Required designer variable.
		/// </summary>
		System::ComponentModel::Container* components;

		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		void InitializeComponent(void)
		{
			System::Resources::ResourceManager *  resources = new System::Resources::ResourceManager(__typeof(VNAR2::InstrumentCal));
			this->label1 = new System::Windows::Forms::Label();
			this->OKbutton = new System::Windows::Forms::Button();
			this->Cancelbutton = new System::Windows::Forms::Button();
			this->RxPhaseButton = new System::Windows::Forms::Button();
			this->RxAmpButton = new System::Windows::Forms::Button();
			this->label2 = new System::Windows::Forms::Label();
			this->TxPhaseButton = new System::Windows::Forms::Button();
			this->TxAmpButton = new System::Windows::Forms::Button();
			this->label3 = new System::Windows::Forms::Label();
			this->label4 = new System::Windows::Forms::Label();
			this->label5 = new System::Windows::Forms::Label();
			this->RxPhaseStat = new System::Windows::Forms::Label();
			this->RxAmpStat = new System::Windows::Forms::Label();
			this->TxPhaseStat = new System::Windows::Forms::Label();
			this->TxAmpStat = new System::Windows::Forms::Label();
			this->progressBar1 = new System::Windows::Forms::ProgressBar();
			this->label6 = new System::Windows::Forms::Label();
			this->label7 = new System::Windows::Forms::Label();
			this->SuspendLayout();
			// 
			// label1
			// 
			this->label1->Font = new System::Drawing::Font(S"Verdana", 15.75F, System::Drawing::FontStyle::Bold, System::Drawing::GraphicsUnit::Point, (System::Byte)0);
			this->label1->Location = System::Drawing::Point(128, 16);
			this->label1->Name = S"label1";
			this->label1->Size = System::Drawing::Size(426, 29);
			this->label1->TabIndex = 0;
			this->label1->Text = S"Detector Calibration";
			this->label1->TextAlign = System::Drawing::ContentAlignment::MiddleCenter;
			// 
			// OKbutton
			// 
			this->OKbutton->DialogResult = System::Windows::Forms::DialogResult::OK;
			this->OKbutton->Location = System::Drawing::Point(392, 424);
			this->OKbutton->Name = S"OKbutton";
			this->OKbutton->Size = System::Drawing::Size(101, 30);
			this->OKbutton->TabIndex = 1;
			this->OKbutton->Text = S"Save";
			this->OKbutton->Click += new System::EventHandler(this, OKbutton_Click);
			// 
			// Cancelbutton
			// 
			this->Cancelbutton->DialogResult = System::Windows::Forms::DialogResult::Cancel;
			this->Cancelbutton->Location = System::Drawing::Point(536, 424);
			this->Cancelbutton->Name = S"Cancelbutton";
			this->Cancelbutton->Size = System::Drawing::Size(105, 29);
			this->Cancelbutton->TabIndex = 2;
			this->Cancelbutton->Text = S"Cancel";
			// 
			// RxPhaseButton
			// 
			this->RxPhaseButton->Font = new System::Drawing::Font(S"Verdana", 9.75F, System::Drawing::FontStyle::Bold, System::Drawing::GraphicsUnit::Point, (System::Byte)0);
			this->RxPhaseButton->Location = System::Drawing::Point(464, 120);
			this->RxPhaseButton->Name = S"RxPhaseButton";
			this->RxPhaseButton->Size = System::Drawing::Size(176, 48);
			this->RxPhaseButton->TabIndex = 3;
			this->RxPhaseButton->Text = S"Refl Phase Detector Calibration";
			this->RxPhaseButton->Click += new System::EventHandler(this, RxPhaseButton_Click);
			// 
			// RxAmpButton
			// 
			this->RxAmpButton->Font = new System::Drawing::Font(S"Verdana", 9.75F, System::Drawing::FontStyle::Bold, System::Drawing::GraphicsUnit::Point, (System::Byte)0);
			this->RxAmpButton->Location = System::Drawing::Point(464, 200);
			this->RxAmpButton->Name = S"RxAmpButton";
			this->RxAmpButton->Size = System::Drawing::Size(176, 48);
			this->RxAmpButton->TabIndex = 4;
			this->RxAmpButton->Text = S"Refl Amplitude Detector Calibration";
			this->RxAmpButton->Click += new System::EventHandler(this, RxAmpButton_Click);
			// 
			// label2
			// 
			this->label2->Font = new System::Drawing::Font(S"Verdana", 9.75F, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, (System::Byte)0);
			this->label2->Location = System::Drawing::Point(96, 120);
			this->label2->Name = S"label2";
			this->label2->Size = System::Drawing::Size(346, 51);
			this->label2->TabIndex = 5;
			this->label2->Text = S"Connect approximately one meter long 50-ohm cable, shorted at far end, to Tx conn" 
				S"ector.";
			// 
			// TxPhaseButton
			// 
			this->TxPhaseButton->Font = new System::Drawing::Font(S"Verdana", 9.75F, System::Drawing::FontStyle::Bold, System::Drawing::GraphicsUnit::Point, (System::Byte)0);
			this->TxPhaseButton->Location = System::Drawing::Point(464, 272);
			this->TxPhaseButton->Name = S"TxPhaseButton";
			this->TxPhaseButton->Size = System::Drawing::Size(176, 48);
			this->TxPhaseButton->TabIndex = 6;
			this->TxPhaseButton->Text = S"Trans Phase Detector Calibration";
			this->TxPhaseButton->Click += new System::EventHandler(this, TxPhaseButton_Click);
			// 
			// TxAmpButton
			// 
			this->TxAmpButton->Font = new System::Drawing::Font(S"Verdana", 9.75F, System::Drawing::FontStyle::Bold, System::Drawing::GraphicsUnit::Point, (System::Byte)0);
			this->TxAmpButton->Location = System::Drawing::Point(464, 344);
			this->TxAmpButton->Name = S"TxAmpButton";
			this->TxAmpButton->Size = System::Drawing::Size(176, 48);
			this->TxAmpButton->TabIndex = 7;
			this->TxAmpButton->Text = S"Trans Amplitude Detector Calibration";
			this->TxAmpButton->Click += new System::EventHandler(this, TxAmpButton_Click);
			// 
			// label3
			// 
			this->label3->Font = new System::Drawing::Font(S"Verdana", 9.75F, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, (System::Byte)0);
			this->label3->Location = System::Drawing::Point(96, 344);
			this->label3->Name = S"label3";
			this->label3->Size = System::Drawing::Size(352, 48);
			this->label3->TabIndex = 8;
			this->label3->Text = S"Connect approximately three meter long (plus or minus one-half meter) 50-ohm cabl" 
				S"e from Rx to Tx.";
			// 
			// label4
			// 
			this->label4->Location = System::Drawing::Point(136, 56);
			this->label4->Name = S"label4";
			this->label4->Size = System::Drawing::Size(415, 28);
			this->label4->TabIndex = 9;
			this->label4->Text = S"(This calibration normally needs to be run only one time.)";
			this->label4->TextAlign = System::Drawing::ContentAlignment::MiddleCenter;
			// 
			// label5
			// 
			this->label5->Font = new System::Drawing::Font(S"Verdana", 9.75F, System::Drawing::FontStyle::Underline, System::Drawing::GraphicsUnit::Point, (System::Byte)0);
			this->label5->Location = System::Drawing::Point(24, 80);
			this->label5->Name = S"label5";
			this->label5->Size = System::Drawing::Size(67, 19);
			this->label5->TabIndex = 10;
			this->label5->Text = S"Status";
			// 
			// RxPhaseStat
			// 
			this->RxPhaseStat->Image = (__try_cast<System::Drawing::Image *  >(resources->GetObject(S"RxPhaseStat.Image")));
			this->RxPhaseStat->Location = System::Drawing::Point(24, 112);
			this->RxPhaseStat->Name = S"RxPhaseStat";
			this->RxPhaseStat->Size = System::Drawing::Size(56, 49);
			this->RxPhaseStat->TabIndex = 11;
			this->RxPhaseStat->Visible = false;
			// 
			// RxAmpStat
			// 
			this->RxAmpStat->Image = (__try_cast<System::Drawing::Image *  >(resources->GetObject(S"RxAmpStat.Image")));
			this->RxAmpStat->Location = System::Drawing::Point(24, 192);
			this->RxAmpStat->Name = S"RxAmpStat";
			this->RxAmpStat->Size = System::Drawing::Size(56, 49);
			this->RxAmpStat->TabIndex = 12;
			this->RxAmpStat->Visible = false;
			// 
			// TxPhaseStat
			// 
			this->TxPhaseStat->Image = (__try_cast<System::Drawing::Image *  >(resources->GetObject(S"TxPhaseStat.Image")));
			this->TxPhaseStat->Location = System::Drawing::Point(24, 272);
			this->TxPhaseStat->Name = S"TxPhaseStat";
			this->TxPhaseStat->Size = System::Drawing::Size(56, 49);
			this->TxPhaseStat->TabIndex = 13;
			this->TxPhaseStat->Visible = false;
			// 
			// TxAmpStat
			// 
			this->TxAmpStat->Image = (__try_cast<System::Drawing::Image *  >(resources->GetObject(S"TxAmpStat.Image")));
			this->TxAmpStat->Location = System::Drawing::Point(24, 344);
			this->TxAmpStat->Name = S"TxAmpStat";
			this->TxAmpStat->Size = System::Drawing::Size(56, 49);
			this->TxAmpStat->TabIndex = 14;
			this->TxAmpStat->Visible = false;
			// 
			// progressBar1
			// 
			this->progressBar1->Location = System::Drawing::Point(32, 472);
			this->progressBar1->Maximum = 1024;
			this->progressBar1->Name = S"progressBar1";
			this->progressBar1->Size = System::Drawing::Size(608, 20);
			this->progressBar1->TabIndex = 15;
			// 
			// label6
			// 
			this->label6->Font = new System::Drawing::Font(S"Verdana", 9.75F, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, (System::Byte)0);
			this->label6->Location = System::Drawing::Point(96, 272);
			this->label6->Name = S"label6";
			this->label6->Size = System::Drawing::Size(352, 48);
			this->label6->TabIndex = 16;
			this->label6->Text = S"Connect approximately three meter long (plus or minus one-half meter) 50-ohm cabl" 
				S"e from Rx to Tx.";
			// 
			// label7
			// 
			this->label7->Font = new System::Drawing::Font(S"Verdana", 9.75F, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, (System::Byte)0);
			this->label7->Location = System::Drawing::Point(96, 200);
			this->label7->Name = S"label7";
			this->label7->Size = System::Drawing::Size(344, 48);
			this->label7->TabIndex = 17;
			this->label7->Text = S"Short Tx connector.";
			// 
			// InstrumentCal
			// 
			this->AutoScaleBaseSize = System::Drawing::Size(7, 16);
			this->ClientSize = System::Drawing::Size(670, 516);
			this->Controls->Add(this->label7);
			this->Controls->Add(this->label6);
			this->Controls->Add(this->progressBar1);
			this->Controls->Add(this->TxAmpStat);
			this->Controls->Add(this->TxPhaseStat);
			this->Controls->Add(this->RxAmpStat);
			this->Controls->Add(this->RxPhaseStat);
			this->Controls->Add(this->label5);
			this->Controls->Add(this->label4);
			this->Controls->Add(this->label3);
			this->Controls->Add(this->TxAmpButton);
			this->Controls->Add(this->TxPhaseButton);
			this->Controls->Add(this->label2);
			this->Controls->Add(this->RxAmpButton);
			this->Controls->Add(this->RxPhaseButton);
			this->Controls->Add(this->Cancelbutton);
			this->Controls->Add(this->OKbutton);
			this->Controls->Add(this->label1);
			this->Font = new System::Drawing::Font(S"Verdana", 9.75F, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, (System::Byte)0);
			this->FormBorderStyle = System::Windows::Forms::FormBorderStyle::Fixed3D;
			this->Location = System::Drawing::Point(128, 239);
			this->Name = S"InstrumentCal";
			this->Text = S"Detector Cal";
			this->ResumeLayout(false);

		}		

private: VNADevice* VNA;					// Vector Network Analyzer hardware object
private: CalDataSet* Cal;					// Calibration Data Set
private: String* StartUpDir;				// Startup directory
private: int Iphase __gc[], Qphase __gc[];	// hold phase detector results from sweep
private: int Mag __gc[ ,];					// hold amplitude detector results from sweep

private: System::Void RxPhaseButton_Click(System::Object *  sender, System::EventArgs *  e)
		 {

			 // Reflection Phase Detector Calibration

			VNA_RXBUFFER *RxBuf = new VNA_RXBUFFER;
			VNA_TXBUFFER *TxBuf = new VNA_TXBUFFER;
			long long int Fdesired;

			// run a sweep of 1024 points, calibrating Rx phase detector
			for (long i=0; i<1024; i++)
			{
				// Compute spot frequency

				Fdesired = Convert::ToInt64(200000.0+( i*(120000000.0-200000.0)/1024.0));

				TxBuf->TxAccum = Fdesired * VNA_XTAL_CONST;
				TxBuf->IDAClevel = MAX_DDS_LEVEL;		// Max transmit level
				TxBuf->ReplyType = 0;
				TxBuf->IntegrationCount = 16;
				TxBuf->QDAClevel = THREE_FIVEDB_LEVEL;	// Reference level

				VNA->WriteRead(TxBuf, RxBuf);

				Iphase[i] = RxBuf->ReflPI;
				Qphase[i] = RxBuf->ReflPQ;

				progressBar1->Value = i;
			}
			Cal->RxDet->PhaseCal(Iphase, Qphase);
			RxPhaseStat->Visible = true;
		 }

private: System::Void RxAmpButton_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			 // Reflection Amplitude Detector Calibration
			 
			VNA_RXBUFFER *RxBuf = new VNA_RXBUFFER;
			VNA_TXBUFFER *TxBuf = new VNA_TXBUFFER;
			long long int Fdesired;

			// run a sweep of 21 frequencies, calibrating Refl Amplitude detector
			for (long FreqIdx=0; FreqIdx<21; FreqIdx++)
			{
				// Compute spot frequency

				if (FreqIdx < 9)
					Fdesired = Convert::ToInt64((FreqIdx + 2) * 100000);	// every 100 KHz starting at 200 khz.
				else
					Fdesired = Convert::ToInt64((FreqIdx-8) * 10000000);	// every ten MHz.

				TxBuf->TxAccum = Fdesired * VNA_XTAL_CONST;

				// Measure at 0, -1, -2, -20 db amplitude levels by controlling TxDAC level
				
 				TxBuf->IDAClevel = MAX_DDS_LEVEL;		// 0 dbm - Max transmit level
				TxBuf->ReplyType = 0;
				TxBuf->IntegrationCount = 16;
				TxBuf->QDAClevel = THREE_FIVEDB_LEVEL;	// Reference level

                VNA->WriteRead(TxBuf, RxBuf);
				Mag[FreqIdx, 0] = RxBuf->ReflMQ;		// Store ADC count for 0 dbm

				TxBuf->IDAClevel = ONEDB_DDS_LEVEL;		// -1 dbm level
                VNA->WriteRead(TxBuf, RxBuf);
				Mag[FreqIdx, 1] = RxBuf->ReflMQ;		// Store ADC count for -1 dbm

				TxBuf->IDAClevel = TWODB_DDS_LEVEL;		// -2 dbm level
                VNA->WriteRead(TxBuf, RxBuf);
				Mag[FreqIdx, 2] = RxBuf->ReflMQ;		// Store ADC count for -2 dbm

				TxBuf->IDAClevel = TWENTYDB_DDS_LEVEL;	// -20 dbm level
                VNA->WriteRead(TxBuf, RxBuf);
				Mag[FreqIdx, 3] = RxBuf->ReflMQ;		// Store ADC count for -20 dbm

				progressBar1->Value = FreqIdx * progressBar1->Maximum/20;
			}

			Cal->RxDet->AmpCal(Mag);
			RxAmpStat->Visible = true;
		 }

private: System::Void TxPhaseButton_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			 // Transmission Phase Detector Calibration

			VNA_RXBUFFER *RxBuf = new VNA_RXBUFFER;
			VNA_TXBUFFER *TxBuf = new VNA_TXBUFFER;
			long long int Fdesired;

			// run a sweep of ~1024 points, calibrating Tx phase detector
			// skip really low frequencies and really high frequencies
			for (long i=0; i<1024; i++)
			{
				// Compute spot frequency

				Fdesired = Convert::ToInt64(200000.0+( i*(120000000.0-200000.0)/1024.0));

				TxBuf->TxAccum = Fdesired * VNA_XTAL_CONST;	
				TxBuf->IDAClevel = MAX_DDS_LEVEL;		// Max transmit level
				TxBuf->ReplyType = 0;
				TxBuf->IntegrationCount = 16;
				TxBuf->QDAClevel = THREE_FIVEDB_LEVEL;	// Reference level

				VNA->WriteRead(TxBuf, RxBuf);

				Iphase[i] = RxBuf->TranPI;
				Qphase[i] = RxBuf->TranPQ;

				progressBar1->Value = i;
			}
			Cal->TxDet->PhaseCal(Iphase, Qphase);
			TxPhaseStat->Visible = true;
		 }

private: System::Void TxAmpButton_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			 // Transmission Amplitude detector Calibration
			 
			VNA_RXBUFFER *RxBuf = new VNA_RXBUFFER;
			VNA_TXBUFFER *TxBuf = new VNA_TXBUFFER;
			long long int Fdesired;

			// run a sweep of 21 frequencies, calibrating Trans Amplitude detector
			for (long FreqIdx=0; FreqIdx<21; FreqIdx++)
			{
				// Compute spot frequency

				if (FreqIdx < 9)
					Fdesired = Convert::ToInt64((FreqIdx + 2) * 100000);	// every 100 KHz starting at 200 khz.
				else
					Fdesired = Convert::ToInt64((FreqIdx-8) * 10000000);	// every ten MHz.

				TxBuf->TxAccum = Fdesired * VNA_XTAL_CONST;
				TxBuf->ReplyType = 0;
				TxBuf->IntegrationCount = 16;
				TxBuf->QDAClevel = THREE_FIVEDB_LEVEL;	// Reference level

				// Measure at 0, -1, -2, -20 db amplitude levels by controlling TxDAC level
				
 				TxBuf->IDAClevel = MAX_DDS_LEVEL;		// 0 dbm - Max transmit level
                VNA->WriteRead(TxBuf, RxBuf);
				Mag[FreqIdx, 0] = RxBuf->TranMQ;		// Store ADC count for 0 dbm

				TxBuf->IDAClevel = ONEDB_DDS_LEVEL;		// -1 dbm level
                VNA->WriteRead(TxBuf, RxBuf);
				Mag[FreqIdx, 1] = RxBuf->TranMQ;		// Store ADC count for -1 dbm

				TxBuf->IDAClevel = TWODB_DDS_LEVEL;		// -2 dbm level
                VNA->WriteRead(TxBuf, RxBuf);
				Mag[FreqIdx, 2] = RxBuf->TranMQ;		// Store ADC count for -2 dbm

				TxBuf->IDAClevel = TWENTYDB_DDS_LEVEL;	// -20 dbm level
                VNA->WriteRead(TxBuf, RxBuf);
				Mag[FreqIdx, 3] = RxBuf->TranMQ;		// Store ADC count for -20 dbm

				progressBar1->Value = FreqIdx * progressBar1->Maximum/20;
			}
			Cal->TxDet->AmpCal(Mag);
			TxAmpStat->Visible = true;
		 }

private: System::Void OKbutton_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			FileStream* fs;
			BinaryWriter* bw;

			String * filename = String::Concat(StartUpDir, S"\\detector.ica");
			try
			{
				// Create a filestream & binary writer

				fs = new FileStream(filename, FileMode::Create, FileAccess::Write);
				bw = new BinaryWriter(fs);
			}
			catch(System::Exception* pe)
			{
				MessageBox::Show(S"Error. Could not Write Detector Calibration file.", pe->Message,
					MessageBoxButtons::OK, MessageBoxIcon::Error);
				return;
			}

			// Define header to match file identifying type and version

			String* recognized = new String(S"VNA Detector Calibration Data Set Version 1.0.0");
			bw->Write(recognized);		// put string header on outfile

			// write the AD8302 Phase Detector constants and error tables
			bw->Write(Cal->RxDet->centerPhase);
			bw->Write(Cal->RxDet->lowerPhase);
			bw->Write(Cal->RxDet->upperPhase);
			for (int degree = 0; degree<360; degree++)
				bw->Write(Cal->RxDet->pherror[degree]);

			bw->Write(Cal->TxDet->centerPhase);
			bw->Write(Cal->TxDet->lowerPhase);
			bw->Write(Cal->TxDet->upperPhase);
			for (int degree = 0; degree<360; degree++)
				bw->Write(Cal->TxDet->pherror[degree]);

			// write the AD8302 Amplitude Detector tables

			for (int i=0; i<21; i++)
				for (int level = 0; level<4; level++)
                    bw->Write(Cal->RxDet->MagTable[i, level]);

			for (int i=0; i<21; i++)
				for (int level = 0; level<4; level++)
                    bw->Write(Cal->TxDet->MagTable[i, level]);

			fs->Flush();
			fs->Close();

		 }


};
}