//
//    Copyright 2004, Thomas C. McDermott, N5EG
//    This file is part of VNAR - the Vector Network Analyzer program.
//
//    VNAR is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    VNAR is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with VNAR, if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//

#pragma once

using namespace System;
using namespace System::ComponentModel;
using namespace System::Collections;
using namespace System::Windows::Forms;
using namespace System::Data;
using namespace System::Drawing;


namespace VNAR2
{
	/// <summary> 
	/// Summary for MarkerEntry
	///
	/// WARNING: If you change the name of this class, you will need to change the 
	///          'Resource File Name' property for the managed resource compiler tool 
	///          associated with all .resx files this class depends on.  Otherwise,
	///          the designers will not be able to interact properly with localized
	///          resources associated with this form.
	/// </summary>
	public __gc class MarkerEntry : public System::Windows::Forms::Form
	{

	public: unsigned int Marker __gc[];

	public: 
		MarkerEntry(unsigned int MarkerIn __gc[])
		{
			InitializeComponent();

			Marker = new unsigned int __gc[5];

			for (int i=0; i<5; i++)							// read in marker frequencies
                Marker[i] = MarkerIn[i];

				Marker1Freq->Text = Marker[0].ToString();		// and display in dialog box
				Marker2Freq->Text = Marker[1].ToString();
				Marker3Freq->Text = Marker[2].ToString();
				Marker4Freq->Text = Marker[3].ToString();
				Marker5Freq->Text = Marker[4].ToString();
		}
        
	protected: 
		void Dispose(Boolean disposing)
		{
			if (disposing && components)
			{
				components->Dispose();
			}
			__super::Dispose(disposing);
		}
	private: System::Windows::Forms::Label *  label1;
	private: System::Windows::Forms::TextBox *  Marker1Freq;
	private: System::Windows::Forms::TextBox *  Marker2Freq;
	private: System::Windows::Forms::TextBox *  Marker3Freq;
	private: System::Windows::Forms::TextBox *  Marker4Freq;
	private: System::Windows::Forms::TextBox *  Marker5Freq;
	private: System::Windows::Forms::Label *  label2;
	private: System::Windows::Forms::Label *  label3;
	private: System::Windows::Forms::Label *  label4;
	private: System::Windows::Forms::Label *  label5;
	private: System::Windows::Forms::Label *  label6;
	private: System::Windows::Forms::Label *  label7;
	private: System::Windows::Forms::Button *  OKButton;
	private: System::Windows::Forms::Button *  CancelButton;

	private:
		/// <summary>
		/// Required designer variable.
		/// </summary>
		System::ComponentModel::Container* components;

		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		void InitializeComponent(void)
		{
			this->label1 = new System::Windows::Forms::Label();
			this->Marker1Freq = new System::Windows::Forms::TextBox();
			this->Marker2Freq = new System::Windows::Forms::TextBox();
			this->Marker3Freq = new System::Windows::Forms::TextBox();
			this->Marker4Freq = new System::Windows::Forms::TextBox();
			this->Marker5Freq = new System::Windows::Forms::TextBox();
			this->label2 = new System::Windows::Forms::Label();
			this->label3 = new System::Windows::Forms::Label();
			this->label4 = new System::Windows::Forms::Label();
			this->label5 = new System::Windows::Forms::Label();
			this->label6 = new System::Windows::Forms::Label();
			this->label7 = new System::Windows::Forms::Label();
			this->OKButton = new System::Windows::Forms::Button();
			this->CancelButton = new System::Windows::Forms::Button();
			this->SuspendLayout();
			// 
			// label1
			// 
			this->label1->Font = new System::Drawing::Font(S"Microsoft Sans Serif", 12, System::Drawing::FontStyle::Bold, System::Drawing::GraphicsUnit::Point, (System::Byte)0);
			this->label1->Location = System::Drawing::Point(72, 8);
			this->label1->Name = S"label1";
			this->label1->Size = System::Drawing::Size(104, 24);
			this->label1->TabIndex = 0;
			this->label1->Text = S"Markers";
			this->label1->TextAlign = System::Drawing::ContentAlignment::TopCenter;
			// 
			// Marker1Freq
			// 
			this->Marker1Freq->Location = System::Drawing::Point(104, 72);
			this->Marker1Freq->Name = S"Marker1Freq";
			this->Marker1Freq->Size = System::Drawing::Size(112, 20);
			this->Marker1Freq->TabIndex = 1;
			this->Marker1Freq->Text = S"";
			// 
			// Marker2Freq
			// 
			this->Marker2Freq->Location = System::Drawing::Point(104, 104);
			this->Marker2Freq->Name = S"Marker2Freq";
			this->Marker2Freq->Size = System::Drawing::Size(112, 20);
			this->Marker2Freq->TabIndex = 2;
			this->Marker2Freq->Text = S"";
			// 
			// Marker3Freq
			// 
			this->Marker3Freq->Location = System::Drawing::Point(104, 136);
			this->Marker3Freq->Name = S"Marker3Freq";
			this->Marker3Freq->Size = System::Drawing::Size(112, 20);
			this->Marker3Freq->TabIndex = 3;
			this->Marker3Freq->Text = S"";
			// 
			// Marker4Freq
			// 
			this->Marker4Freq->Location = System::Drawing::Point(104, 168);
			this->Marker4Freq->Name = S"Marker4Freq";
			this->Marker4Freq->Size = System::Drawing::Size(112, 20);
			this->Marker4Freq->TabIndex = 4;
			this->Marker4Freq->Text = S"";
			// 
			// Marker5Freq
			// 
			this->Marker5Freq->Location = System::Drawing::Point(104, 200);
			this->Marker5Freq->Name = S"Marker5Freq";
			this->Marker5Freq->Size = System::Drawing::Size(112, 20);
			this->Marker5Freq->TabIndex = 5;
			this->Marker5Freq->Text = S"";
			// 
			// label2
			// 
			this->label2->Location = System::Drawing::Point(24, 72);
			this->label2->Name = S"label2";
			this->label2->Size = System::Drawing::Size(56, 16);
			this->label2->TabIndex = 6;
			this->label2->Text = S"Marker 1";
			this->label2->TextAlign = System::Drawing::ContentAlignment::BottomLeft;
			// 
			// label3
			// 
			this->label3->Location = System::Drawing::Point(24, 104);
			this->label3->Name = S"label3";
			this->label3->Size = System::Drawing::Size(56, 16);
			this->label3->TabIndex = 7;
			this->label3->Text = S"Marker 2";
			this->label3->TextAlign = System::Drawing::ContentAlignment::BottomLeft;
			// 
			// label4
			// 
			this->label4->Location = System::Drawing::Point(24, 136);
			this->label4->Name = S"label4";
			this->label4->Size = System::Drawing::Size(56, 16);
			this->label4->TabIndex = 8;
			this->label4->Text = S"Marker 3";
			this->label4->TextAlign = System::Drawing::ContentAlignment::BottomLeft;
			// 
			// label5
			// 
			this->label5->Location = System::Drawing::Point(24, 168);
			this->label5->Name = S"label5";
			this->label5->Size = System::Drawing::Size(56, 16);
			this->label5->TabIndex = 9;
			this->label5->Text = S"Marker 4";
			this->label5->TextAlign = System::Drawing::ContentAlignment::BottomLeft;
			// 
			// label6
			// 
			this->label6->Location = System::Drawing::Point(24, 200);
			this->label6->Name = S"label6";
			this->label6->Size = System::Drawing::Size(56, 16);
			this->label6->TabIndex = 10;
			this->label6->Text = S"Marker 5";
			this->label6->TextAlign = System::Drawing::ContentAlignment::BottomLeft;
			// 
			// label7
			// 
			this->label7->Location = System::Drawing::Point(104, 40);
			this->label7->Name = S"label7";
			this->label7->Size = System::Drawing::Size(112, 24);
			this->label7->TabIndex = 11;
			this->label7->Text = S"Frequency, Hz.        ( 0 turns off Marker )";
			this->label7->TextAlign = System::Drawing::ContentAlignment::MiddleCenter;
			// 
			// OKButton
			// 
			this->OKButton->DialogResult = System::Windows::Forms::DialogResult::OK;
			this->OKButton->Location = System::Drawing::Point(40, 248);
			this->OKButton->Name = S"OKButton";
			this->OKButton->TabIndex = 12;
			this->OKButton->Text = S"OK";
			this->OKButton->Click += new System::EventHandler(this, OKButton_Click);
			// 
			// CancelButton
			// 
			this->CancelButton->DialogResult = System::Windows::Forms::DialogResult::Cancel;
			this->CancelButton->Location = System::Drawing::Point(144, 248);
			this->CancelButton->Name = S"CancelButton";
			this->CancelButton->TabIndex = 13;
			this->CancelButton->Text = S"Cancel";
			// 
			// MarkerEntry
			// 
			this->AcceptButton = this->OKButton;
			this->AutoScaleBaseSize = System::Drawing::Size(5, 13);
			this->ClientSize = System::Drawing::Size(264, 294);
			this->Controls->Add(this->CancelButton);
			this->Controls->Add(this->OKButton);
			this->Controls->Add(this->label7);
			this->Controls->Add(this->label6);
			this->Controls->Add(this->label5);
			this->Controls->Add(this->label4);
			this->Controls->Add(this->label3);
			this->Controls->Add(this->label2);
			this->Controls->Add(this->Marker5Freq);
			this->Controls->Add(this->Marker4Freq);
			this->Controls->Add(this->Marker3Freq);
			this->Controls->Add(this->Marker2Freq);
			this->Controls->Add(this->Marker1Freq);
			this->Controls->Add(this->label1);
			this->FormBorderStyle = System::Windows::Forms::FormBorderStyle::Fixed3D;
			this->Name = S"MarkerEntry";
			this->Text = S"Marker Entry";
			this->ResumeLayout(false);

		}		



private: System::Void OKButton_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			 try
			 {
                 Marker[0] = Convert::ToInt32(Marker1Freq->Text);
                 Marker[1] = Convert::ToInt32(Marker2Freq->Text);
                 Marker[2] = Convert::ToInt32(Marker3Freq->Text);
                 Marker[3] = Convert::ToInt32(Marker4Freq->Text);
                 Marker[4] = Convert::ToInt32(Marker5Freq->Text);
			 }
			 catch (Exception * pe)
			 {
				MessageBox::Show(pe->Message, "Error");
			 }
		 }
};
}