//---------------------------------------------------------------------------

#ifndef LCDMainH
#define LCDMainH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include "JvHidControllerClass.hpp"
#include <Buttons.hpp>
#include <Dialogs.hpp>
//---------------------------------------------------------------------------
#define cCodeMercenariesVID 0x07C0
#define cIOWarriorPID       0x1500
#define cLCDEnableReportID  0x04
#define cLCDWriteReportID   0x05
#define cLCDReadReportID    0x06
#define cEnable             0x01
#define cDisable            0x00

#pragma pack(push, 1)
  typedef struct
  {
    unsigned char ReportID;
    unsigned char LCDBytes[7];
  }
  TIOWarriorOutputReport;
#pragma pack(pop)
//---------------------------------------------------------------------------
class TLCDMainForm : public TForm
{
__published:	// IDE-managed Components
        TSaveDialog *SaveDialog;
        TJvHidDeviceController *HidCtl;
        TLabel *IOWarriorAvailable;
        TListBox *HistoryListBox;
        TCheckBox *EnableChk;
        TSpeedButton *WriteBtn;
        TEdit *Write1;
        TEdit *Write2;
        TEdit *Write3;
        TEdit *Write4;
        TEdit *Write5;
        TEdit *Write6;
        TEdit *Write7;
        TSpeedButton *ReadBtn;
        TEdit *Read1;
        TSpeedButton *SaveBtn;
        TCheckBox *RSBit;
        void __fastcall FormActivate(TObject *Sender);
        void __fastcall HidCtlDeviceChange(TObject *Sender);
        void __fastcall EnableChkClick(TObject *Sender);
        void __fastcall WriteBtnClick(TObject *Sender);
        void __fastcall ReadBtnClick(TObject *Sender);
        void __fastcall SaveBtnClick(TObject *Sender);
        void __fastcall HidCtlDeviceData(TJvHidDevice *HidDev,
          BYTE ReportID, const Pointer Data, WORD Size);
private:	// User declarations
public:		// User declarations
        TEdit *Edits[8];
        TJvHidDevice *IOWarrior;
        __fastcall TLCDMainForm(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TLCDMainForm *LCDMainForm;
//---------------------------------------------------------------------------
#endif
