from myhdl import *
import random
from config import *

def divideBy10(clk, reset, start, done, dividend, quotient, initialDividend):
	"""
		Divide a unsigned 30-bit (COUNT_WIDTH) number by 10.
			The remainder is returned in divdend
	"""

	State = enum('STATE1', 'IDLE')
	state = Signal(State.IDLE)
	ten = Signal(intbv(0)[COUNT_WIDTH:])
	k = Signal(intbv(0)[5:])
	mask = Signal(intbv(0)[COUNT_WIDTH-3:])

	@always(clk.negedge, reset.negedge)
	def logic():
		if reset == ACTIVE_LOW:
			state.next = State.IDLE
			done.next = INACTIVE_HIGH
		elif start == ACTIVE_LOW:
			state.next = State.STATE1
			done.next = INACTIVE_HIGH
			ten.next = 10 << (COUNT_WIDTH - 4)
			mask.next = 1 << (COUNT_WIDTH - 4)
			quotient.next = 0
			dividend.next = initialDividend
			k.next = COUNT_WIDTH - 4
		else:
			if state == State.STATE1:
				if ten <= dividend:
					quotient.next = quotient + mask
					dividend.next = dividend - ten
				mask.next = mask >> 1
				ten.next = ten >> 1
				if k == 0:
					done.next = ACTIVE_LOW
					state.next = State.IDLE
				else:
					k.next = k - 1
			elif state == State.IDLE:
				pass
			else:
				state.next = State.IDLE
	return logic

def testBench():

	clk, reset, start, done = [Signal(bool(INACTIVE_HIGH)) for k in range(4)]
	dividend, quotient, initialDividend = [Signal(intbv(0)[COUNT_WIDTH:]) for k in range(3)]

	DIV = divideBy10(clk, reset, start, done, dividend, quotient, initialDividend)

	HALF_PERIOD = delay(1)
	@always(HALF_PERIOD)
	def clockGen():
		clk.next = not clk

	@instance
	def testDivideBy10():
		reset.next = ACTIVE_LOW
		yield clk.posedge
		reset.next = INACTIVE_HIGH
		maxv = 0
		minv = 0xffffffff
		vals = (0, 10, 123, 12345678, 87654321)

		for k in range(5):
			#v = random.randint(0, 2**COUNT_WIDTH)
			#v = 80231209
			v = vals[k]
			maxv = max(v, maxv)
			minv = min(v, minv)
			#print 'div:        %8d' % (v,)
			initialDividend.next = v
			start.next = ACTIVE_LOW
			yield clk.negedge
			start.next = INACTIVE_HIGH
			yield clk.negedge
			while done == INACTIVE_HIGH:
				yield clk.posedge
			yield delay(10)
			q = v / 10
			r = v % 10
			#print 'v:', v, '  q:', quotient
			print 'v: %10d  q: %10d   r: %10d' % (v, quotient, dividend)
			if q != quotient:
				print 'Error: q=%10d  quotient=%10d' % (q, quotient)
			if r != dividend:
				print 'Error: r=%10d  remainder=%10d' % (r, dividend)
			#print
		print 'min: %8d  max: %8d' % (minv, maxv)
		raise StopSimulation
	return instances()

def test1():
	tb = testBench()
	Simulation(tb).run(10000)

def test2():
	clk, reset, start, done = [Signal(bool(INACTIVE_HIGH)) for k in range(4)]
	dividend, quotient, initialDividend = [Signal(intbv(0)[32:]) for k in range(3)]

	toVerilog(divideBy10, clk, reset, start, done, dividend, quotient, initialDividend)


if __name__ == '__main__':
	test2()