#!/usr/bin/env python
# -*- coding: utf-8 -*-

# hamlibio.py  4/2012 7/2012 2/2013 MSE
# use with Remote.py
# Remote rig control using Hamlib rigctld protocol

#   Copyright (C) 2012, 2013 Martin S. Ewing, AA6E
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

import socket

NL = '\n'

class HamlibIO (object):
    def __init__(self, host='127.0.0.1', port=4532):
        self.mysock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        self.mysock.connect( (host, port) )
        self.mysock.sendall("m\n")  # software reset
        response = self.mysock.recv(1024)
        
    def send0(self, p):     # Use hamlib to send to the rig, return what comes back.
        self.mysock.sendall(p+NL)
        response = self.mysock.recv(1024)
        return response
    
    def send1(self, p):         # Send w/o expecting any return
        self.mysock.sendall(p+NL)
        
    def send(self,p):           # Send a command expecting no response, 
                                # but return hamlib error code or zero
        r = self.send0(p)
        if r.startswith("RPRT"):    # 'RPTR nnn\n" is error format
            return int(r[4:-1])
        return 0                # normal return
    
    def recv(self,p):           # Send command requesting data
        r = self.send0(p)       # returns tuple (error or zero, value)
        if r.startswith("RPRT"):    # 'RPTR nnn\n" is error format
            return (int(r[4:-1]), "0")    # error no., zero value
        else:
            return (0, r)       # no error with response string
    
    def send_cmd(self,p):	# send raw ascii command to radio w/o return
        self.send1("w"+p)
        
    def recv_cmd(self,p):       # send raw ascii command with return
        a,r =self.recv("w"+p)
        return (a, r)   	

    def close(self):
        self.mysock.close()

