# Calculate ARRL Antenna Book Total Loss (Eq. 16)
adB = 0.3;  #  LINE LOSS IN dB 
SWR = linspace(1., 20., 300);
refl_coef = (SWR - 1) ./ (SWR + 1);
mllr = 10 ^ (adB ./ 10);
Total_loss = 10 .* log10((mllr .^ 2 .- abs(refl_coef) .^ 2) ./ ...
(mllr .* (1 .- abs(refl_coef) .^ 2)));
# Commands for plotting using gnuplot or FLTK/OpenGL
#plot(SWR, Total_loss);
#title(sprintf("*** TOTAL LOSS DUE TO SWR FOR %g dB MATCHED LINE LOSS ***", adB));
#xlabel "SWR"
#ylabel "TOTAL LOSS"
#grid("on");
#pause;
# Write output to a datafile for external plotting
fp = fopen("/home/mwright/swr_1.txt", "w", "native");
for n = 1:300
  fprintf(fp, "%g, %g\n", SWR(n), Total_loss(n));
endfor
fclose(fp);
