/*
 * Copyright (C) 2013 Thomas M. Alldread
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package va7ta.app.nimblesigsweepgen;

import va7ta.app.nimblesigsweepgen.R;
import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.SeekBar;
import android.widget.SeekBar.OnSeekBarChangeListener;
import android.widget.TextView;

public class SetModFreqHz extends Activity{

			private static final String TAG = "NimbleSig.SetModFreqHz";
		    private static final boolean D = true;
		    
		    
			private Button mModFreq_SetButton;

			private float modFrqHz_Flt=0; 
			private int modFrqHz_Int=0; 
		    private String newModFrqHzA_Str="0";
		    private String currentModFrqHzA_Str="0";
			private float start_posCrs_Flt=0; 
			private int start_posCrs_Int=0; 
			private float lastFineCorrection=0;
			private float fineCorrection=0;
			private boolean fineBarAutoCentre=false;
			private boolean courseBarAutoAdj=false;
			
			
			@Override
			public void onCreate(Bundle icicle) {
		    super.onCreate(icicle);
		    	if(D) Log.e(TAG, "+++ SET MOD FREQUENCY +++");

		        Intent currentValIntent = getIntent();
		        if(currentValIntent.hasExtra("modFrqHzVal")){
		            currentModFrqHzA_Str = currentValIntent.getStringExtra("modFrqHzVal");
		            currentModFrqHzA_Str = stripSpaces(currentModFrqHzA_Str);
		        }
		    	// Set up the window layout
		    	setContentView(R.layout.activity_nimble_sig_rfgen_set_mod_freq);
		        TextView ModFrqHzAValStr =(TextView) findViewById(R.id.modFrqHzValue);
		        ModFrqHzAValStr.setText(currentModFrqHzA_Str);            
		    	TextView ModFrqHzAdjTitle = (TextView) findViewById(R.id.titleSetModFreq); 
		    	ModFrqHzAdjTitle.setText("Modulation Frequency - Hz.");
		    	
		    	
		        start_posCrs_Flt=Float.parseFloat(currentModFrqHzA_Str);    //you need to give starting position value of SeekBar 
		        start_posCrs_Int=(int) (start_posCrs_Flt); 
		        modFrqHz_Flt=start_posCrs_Flt; 
		        SeekBar crsModFrqHzA_Bar=(SeekBar) findViewById(R.id.courseModFrqAdj_Bar); 
		        crsModFrqHzA_Bar.setProgress(start_posCrs_Int); 
		        SeekBar medModFrqHzA_Bar=(SeekBar) findViewById(R.id.medModFrqAdj_Bar); 
		        medModFrqHzA_Bar.setProgress(1000); 
		        SeekBar fineModFrqHzA_Bar=(SeekBar) findViewById(R.id.fineModFrqAdj_Bar); 
		        fineModFrqHzA_Bar.setProgress(100); 
		        SeekBar extraFineModFrqHzA_Bar=(SeekBar) findViewById(R.id.extraFineModFrqAdj_Bar); 
		        extraFineModFrqHzA_Bar.setProgress(10); 

		        
		        crsModFrqHzA_Bar.setOnSeekBarChangeListener(new OnSeekBarChangeListener() { 

		            @Override 
		            public void onStopTrackingTouch(SeekBar seekBar) { 
		                // TODO Auto-generated method stub 
		/*
		            	if (modFrqHz_Flt >= 0){
		            		milliDegrees *= (int)1000;
		            	}
		            	if (modFrqHz_Flt < 0){
		            		milliDegrees = (int)(360-modFrqHz_Flt)*1000;
		            	}
		            	
		                newModFrqHzA_mDeg = String.valueOf(milliDegrees);
//		            	sendMessage("pa"+newModFrqHzA_mDeg);
		*/
		            	lastFineCorrection = 0;
//		                SeekBar fineModFrqHzA_Bar=(SeekBar) findViewById(R.id.fineModFrqAdj_Bar);
//		                fineModFrqHzA_Bar.setProgress(2500);
		            } 

		            @Override 
		            public void onStartTrackingTouch(SeekBar seekBar) { 
		                // TODO Auto-generated method stub 

		            } 

		            @Override 
		            public void onProgressChanged(SeekBar seekBar, int progress,boolean fromUser) { 
		                // TODO Auto-generated method stub 
		            	if(!courseBarAutoAdj){//skip if adjustment from finer seek bars
			            	// To convert it as modFrqHz_Flt value 
			                modFrqHz_Flt=((int)progress/1000)*1000; 
			                newModFrqHzA_Str = String.valueOf(modFrqHz_Flt);
			                upDateModFrqHzAVal(modFrqHz_Flt);
		            	}else courseBarAutoAdj=false;
		            } 
		        }); //crsModFrqHzA_Bar
		 
		        medModFrqHzA_Bar.setOnSeekBarChangeListener(new OnSeekBarChangeListener() { 

		            @Override 
		            public void onStopTrackingTouch(SeekBar seekBar) { 
		                // TODO Auto-generated method stub 
		                // To convert it as modFrqHz_Flt value 
		                SeekBar crsModFrqHzA_Bar=(SeekBar) findViewById(R.id.courseModFrqAdj_Bar);
		                int newProgress = (int)modFrqHz_Flt;
		                courseBarAutoAdj=true;
		                crsModFrqHzA_Bar.setProgress(newProgress);
		                fineBarAutoCentre=true;
		                SeekBar fineModFrqHzA_Bar=(SeekBar) findViewById(R.id.medModFrqAdj_Bar);
		                fineModFrqHzA_Bar.setProgress(1000);
		                lastFineCorrection = 0;
		                
		            } 

		            @Override 
		            public void onStartTrackingTouch(SeekBar seekBar) { 
		                // TODO Auto-generated method stub 

		            } 

		            @Override 
		            public void onProgressChanged(SeekBar seekBar, int progress,boolean fromUser) { 
		                // TODO Auto-generated method stub 
		            	if(!fineBarAutoCentre){
		            		fineCorrection=progress-1000;
		            		fineCorrection=((int)fineCorrection/100)*100;
		            		modFrqHz_Flt=((int)((modFrqHz_Flt+.5)/100))*100;
			                modFrqHz_Flt += (fineCorrection-lastFineCorrection);            
			                lastFineCorrection = fineCorrection;
			                float test1 = modFrqHz_Flt;
			                newModFrqHzA_Str = String.valueOf(modFrqHz_Flt);
			                upDateModFrqHzAVal(modFrqHz_Flt);
		            	}
		                else fineBarAutoCentre = false;
		            } 
		        }); //medModFrqHzA_Bar
		 
		        fineModFrqHzA_Bar.setOnSeekBarChangeListener(new OnSeekBarChangeListener() { 

		            @Override 
		            public void onStopTrackingTouch(SeekBar seekBar) { 
		                // TODO Auto-generated method stub 
		                // To convert it as modFrqHz_Flt value 
		                SeekBar crsModFrqHzA_Bar=(SeekBar) findViewById(R.id.courseModFrqAdj_Bar);
		                int newProgress = (int)modFrqHz_Flt;
		                courseBarAutoAdj=true;
		                crsModFrqHzA_Bar.setProgress(newProgress);
		                fineBarAutoCentre=true;
		                SeekBar fineModFrqHzA_Bar=(SeekBar) findViewById(R.id.fineModFrqAdj_Bar);
		                fineModFrqHzA_Bar.setProgress(100);
		                lastFineCorrection = 0;
		                
		            } 

		            @Override 
		            public void onStartTrackingTouch(SeekBar seekBar) { 
		                // TODO Auto-generated method stub 

		            } 

		            @Override 
		            public void onProgressChanged(SeekBar seekBar, int progress,boolean fromUser) { 
		                // TODO Auto-generated method stub 
		            	if(!fineBarAutoCentre){
		            		fineCorrection=progress-100;
		            		fineCorrection=((int)fineCorrection/10)*10;
		            		modFrqHz_Flt=((int)((modFrqHz_Flt+.5)/10))*10;
			                modFrqHz_Flt += (fineCorrection-lastFineCorrection);            
			                lastFineCorrection = fineCorrection;
			                float test1 = modFrqHz_Flt;
			                newModFrqHzA_Str = String.valueOf(modFrqHz_Flt);
			                upDateModFrqHzAVal(modFrqHz_Flt);
		            	}
		                else fineBarAutoCentre = false;
		            } 
		        }); //fineModFrqHzA_Bar
		 
		        extraFineModFrqHzA_Bar.setOnSeekBarChangeListener(new OnSeekBarChangeListener() { 

		            @Override 
		            public void onStopTrackingTouch(SeekBar seekBar) { 
		                // TODO Auto-generated method stub 
		                // To convert it as modFrqHz_Flt value 
		                SeekBar crsModFrqHzA_Bar=(SeekBar) findViewById(R.id.courseModFrqAdj_Bar);
		                int newProgress = (int)modFrqHz_Flt;
		                courseBarAutoAdj=true;
		                crsModFrqHzA_Bar.setProgress(newProgress);
		                fineBarAutoCentre=true;
		                SeekBar fineModFrqHzA_Bar=(SeekBar) findViewById(R.id.extraFineModFrqAdj_Bar);
		                fineModFrqHzA_Bar.setProgress(10);
		                lastFineCorrection = 0;
		            } 

		            @Override 
		            public void onStartTrackingTouch(SeekBar seekBar) { 
		                // TODO Auto-generated method stub 

		            } 

		            @Override 
		            public void onProgressChanged(SeekBar seekBar, int progress,boolean fromUser) { 
		                // TODO Auto-generated method stub 
		            	if(!fineBarAutoCentre){
			            	if(!fineBarAutoCentre){
			            		fineCorrection=progress-10;
				                modFrqHz_Flt += (fineCorrection-lastFineCorrection);            
				                lastFineCorrection = fineCorrection;
				                float test1 = modFrqHz_Flt;
				                newModFrqHzA_Str = String.valueOf(modFrqHz_Flt);
				                upDateModFrqHzAVal(modFrqHz_Flt);
			            	}
		            	}
		                else fineBarAutoCentre = false;	           
		            }
		        }); //extraFineModFrqHzA_Bar
		        
		 
		    }//onCreate 
			
			
		    public void upDateModFrqHzAVal(float val) {
		        TextView ModFrqHzA_ValLabel = (TextView) findViewById(R.id.modFrqHzValue);
		        modFrqHz_Int = (int)(val);
		        ModFrqHzA_ValLabel.setText(String.valueOf(modFrqHz_Int));
		    }

		    @Override
		    public synchronized void onResume() {
		        super.onResume();
		    	if(D) Log.e(TAG, "+++ ON RESUME +++");
		       

		        //VFO A modFrqHz SET button with a listener that for click events
		        mModFreq_SetButton = (Button) findViewById(R.id.updateModFrqHzBtn);
		        mModFreq_SetButton.setOnClickListener(new OnClickListener() {
		        	public void onClick(View v) {
		                TextView modFrqHzValue=(TextView) findViewById(R.id.modFrqHzValue);
		                newModFrqHzA_Str = modFrqHzValue.getText().toString();
		            	Intent newModFrqHzA_Val=new Intent(getApplicationContext(), NimbleSigSweepGenMain.class);
		            	newModFrqHzA_Val.putExtra("valModFrqHzA",newModFrqHzA_Str);
		        		finish ();
		        	}
		        });
		        
		    }//onResume
		    
		    private String stripSpaces(String str){
		        int l=str.length();
		        int i=0;
		        char tempChr[]=str.toCharArray();
		        String tempStr="";
		        while(i<l){
		        	if(tempChr[i] !=' '){
		        		tempStr+=String.valueOf(tempChr[i]);
		        	}
		        	i++;
		        }
		    	return tempStr;
		    }

		    @Override
		    public void finish() {
		      // Prepare data intent 
		      Intent newModFrqHzA_ValIntent = new Intent();
		      newModFrqHzA_ValIntent.putExtra("valModFrqHzA", newModFrqHzA_Str);
		      // Activity finished ok, return the data
		      setResult(RESULT_OK, newModFrqHzA_ValIntent);
		      super.finish();
		    } 
		   
		    @Override
		    public synchronized void onPause() {
		        super.onPause();
//			        if(D) Log.e(TAG, "- ON PAUSE -");
		    }

		    @Override
		    public void onStop() {
		        super.onStop();
//			        if(D) Log.e(TAG, "-- ON STOP --");
		    }

		    @Override
		    public void onDestroy() {
		        super.onDestroy();
//			        if(D) Log.e(TAG, "--- ON DESTROY ---");
		    }


		}

