
#if defined(__GNUC__)  &&  defined(__MSP430__)
	#include <legacymsp430.h>
#else
	#include "io430.h"
#endif
#include "bin2hexS.h"

int bin2hexS(char *v, int nBytes, char *s, int mode)
{
/*
  Convert a binary value to hex ascii digits with leading zeros
	v		- Pointer to value
	nBytes	- char 1, int 2, long 4
	s		- Pointer to output
	mode		- APPENDSP == append a blank,
			  APPENDCRLF == append a crlf,
			  APPENDCR == append cr, otherwise append nothing
*/
static const char hex[] = {'0','1','2','3','4','5','6','7','8','9','a','b','c','d','e','f'};
int i;
char ix;
char *start = s;


    v += nBytes - 1;		// Point to least significant byte
    for (i = 0; i < nBytes; i++)
    {
      	ix = *v--;
       	*s++ = hex[(ix & 0xf0)>>4];
        *s++ = hex[ix & 0xf];
    }
    if (mode & APPENDSP)
		*s++ = ' ';
	if (mode & APPENDCR)
		*s++ = '\r';
  	else if (mode & APPENDCRLF)
    {
     	*s++ = '\r';
        *s++ = '\n';
    }
	if (!(mode & APPENDNOTERM))
		*s = 0;
    return s - start;
}	// end bin2hex()

