
//#include <msp430.h>
#include <legacymsp430.h>
#include "str2bin.h"

long str2bin(char *s, int ndigits)
{
/*
	Convert a string of decimal ASCII digits to a long
	if ndigits is zero <s> must point to a null-terminated digit string
	or the string of digits followed by a non-numeric character.
	Otherwise, <ndigits> specifies the number of ascii digits to be converted.
*/
int n = 0;
long x=0;
char ch, neg=0;

	if (*s == '-')
	{
		neg = 1;
		s++;
	}
	while (1)
	{
		ch = *s++;
		if ((ch < 0x30) || (ch > 0x39) || ((ndigits > 0) && (n >= ndigits)))
			break;
		x = (x * 10) + ((int)ch &0xf);
		n++;
	}
	if (neg)
		x = -x;
	return x;
}
