/**************************************
Quadrature Encoder Installable Module
Version 1.0 25 March 2015

eqep.c
**************************************/
#include <linux/kernel/linux/include/module.h>
#include <linux/kernel/linux/include/kernel.h>
#include <linux/kernel/linux/include/init.h>
#include <linux/kernel/linux/include/proc_fs.h>
#include <linux/kernel/linux/include/asm/uaccess.h>

#define MODULE_VERSION "1.0"
#define MODULE_NAME "EQEP proc Module"

static struct proc_dir_entry *eqep_file;
static char   eqep_data;

/**************************************
  FUNCTION:   eqep_init

  DESCRIPTION: Function that attaches the installable
               module to the kernel. User mode programs
               will open /proc/eqep in order to read 
               or write.

  INPUTS:      None

  OUTPUTS:     kernel module attached to the file 
               system on /proc/eqep

  RETURNS:     Success or error code

  NOTES:       None

  CONTEXT:     This function will only be called from 
               Linux kernel context.

**************************************/

static int eqep_init(void)
{
long *hardware_register;

   /* Create the proc entry and make itreadable and 
   writable by all - 0666 */
   eqep_file = create_proc_entry("eQEP", 0666, NULL);   
   if (NULL == eqep_file )
   {
      return -ENOMEM;
   }
   /* set the fields for the file system data */
   eqep_file->data = &eqep_data;
   eqep_file->read_proc = &eqep_read;
   eqep_file->write_proc = &eqep_write;
   eqep_file->owner = THIS_MODULE;

   /* initialize the eQEP hardware */
   hardware_register  = QPOSMAX0_REG; // Maximum value for QPOSCNT register
   *hardware_register = 0xffffffff;
   hardware_register  = QPOSCNT0_REG; // the position register
   *hardware_register = 0x7fffffff;   // set to center value
   hardware_register  = QDECCTL0_REG; // control register
   *hardware_register =  0x00000000;  // Quadrature count mode
                                      // 2x resolution
                                      // all others are default
   hardware_register  = EQEP0_INA_PIN_MUX_REG;
   *hardware_register = OMAP_MUX_MODE_1;
   hardware_register  = EQEP0_INB_PIN_MUX_REG;
   *hardware_register = OMAP_MUX_MODE_1;
   /* notify the user that the module is initialized */
   printk(KERN_INFO "%s %s initialized\n", MODULE_NAME, MODULE_VERSION);
   return 0;
}
/**************************************
  FUNCTION:   eqep_exit

  DESCRIPTION: Function that detaches the installable
               module to the kernel.

  INPUTS:      None

  OUTPUTS:     kernel module detached from the file 
               system
               
  RETURNS:     Nothing

  NOTES:       None

  CONTEXT:     This function will only be called from 
               Linux kernel context.

**************************************/

static void eqep_exit(void)
{

   /* Remove the proc entry and make itreadable and 
   writable by all - 0666 */
   remove_proc_entry("eQEP", NULL);   
   /* notify the user that the module is removed */
   printk(KERN_INFO "%s %s removed\n", MODULE_NAME, MODULE_VERSION);
}
/* compiler macros that connect the module to the kernel */
module_init(eqep_init);
module_exit(eqep_exit);
MODULE_AUTHOR("Ray Mack");
MODULE_DESCRIPTION("eQEP proc module");
EXPORT_NO_SYMBOLS;
