/******************************************************************************

    analog_in.c

    Created on: 19 August 2015
    
      Author: Ray Mack

*******************************************************************************/
#include <stdbool.h>
#include <stdint.h>
#include <ti/sysbios/knl/Task.h>
#include <ti/sysbios/BIOS.h>
#include "inc/hw_gpio.h"
#include "inc/hw_memmap.h"
#include "inc/hw_types.h"
#include "driverlib/gpio.h"
#include "driverlib/pin_map.h"
#include "driverlib/adc.h"
#include "driverlib/sysctl.h"

uint32_t ADC_data[8];

/****************************************************************************

How it works:


*****************************************************************************/


void init_analog_in(void)
{
  
  // Port E has only analog input connections.  This port is enabled in another
  // function Note that PORTD has already been enabled as part of the SPI setup
  SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOE);
  SysCtlPeripheralEnable(SYSCTL_PERIPH_ADC0);
  
  //
  // Configure the ADC to use PLL at 480 MHz divided by 24 to get an ADC
  // clock of 20 MHz.
  //
  ADCClockConfigSet(ADC0_BASE, ADC_CLOCK_SRC_PLL | ADC_CLOCK_RATE_FULL, 24);  


  /* Setup the internal ADC pins used */
  GPIOPinTypeADC(GPIO_PORTE_BASE, GPIO_PIN_0 | GPIO_PIN_1 | GPIO_PIN_2 | GPIO_PIN_3 | GPIO_PIN_4 | GPIO_PIN_5);
  GPIOPinTypeADC(GPIO_PORTD_BASE, GPIO_PIN_4 | GPIO_PIN_5 | GPIO_PIN_6 | GPIO_PIN_7);
  
  // Set up the ADC Reference source
  ADCReferenceSet(ADC0_BASE, ADC_REF_EXT_3V);
  
  

  // Set up the ADC system to scan the pins We will use Sample Sequencer Zero
  // since it allows 8 channels to be scanned.

  //
  // Enable the first sample sequencer to capture the value of channels 0 through 7 when
  // the processor trigger occurs.
  //
  ADCSequenceConfigure(ADC0_BASE, 0, ADC_TRIGGER_PROCESSOR, 0);
  ADCSequenceStepConfigure(ADC0_BASE, 0, 0, ADC_CTL_CH0);
  ADCSequenceStepConfigure(ADC0_BASE, 0, 1, ADC_CTL_CH1);
  ADCSequenceStepConfigure(ADC0_BASE, 0, 2, ADC_CTL_CH2);
  ADCSequenceStepConfigure(ADC0_BASE, 0, 3, ADC_CTL_CH3);
  ADCSequenceStepConfigure(ADC0_BASE, 0, 4, ADC_CTL_CH4);
  ADCSequenceStepConfigure(ADC0_BASE, 0, 5, ADC_CTL_CH5);
  ADCSequenceStepConfigure(ADC0_BASE, 0, 6, ADC_CTL_CH6);
  ADCSequenceStepConfigure(ADC0_BASE, 0, 7, ADC_CTL_IE | ADC_CTL_END | ADC_CTL_CH7);
  ADCSequenceEnable(ADC0_BASE, 0);

}

/*****************************************************************************
  FUNCTION:    run_internal_ADC

  DESCRIPTION: This function reads the 8 channels of ADC data and stores it in the
               local database.

  INPUTS:      None
               
  OUTPUTS:     Updated hardware switch configuration

  RETURNS:     Nothing.

  NOTES:       None.

  CONTEXT:     This function only runs in user task context.

*****************************************************************************/

void run_internal_ADC(void)
{
int32_t number_read;
   
  // Trigger the first sample sequence.
  ADCProcessorTrigger(ADC0_BASE, 0);
  // Wait until the sample sequence has completed.
  while(!ADCIntStatus(ADC0_BASE, 0, false))
  {
  }
  //
  // Read the 8 values from the ADC.
  //
  number_read = ADCSequenceDataGet(ADC0_BASE, 0, ADC_data);
  if (number_read != 8)
  {
    // not sure what to do with this error for now 
  }

}
