import os
import numpy as np
import cmath as cma
from math import *

qinduc = 200
qcap = 1000
iin = 1.414
# input current is 1.414 A for 100 W into 50 ohms


while (1):
   freq = float(input("frequency (MHz) -ve to exit "))
   if (freq < 0):
        exit()
   ra = float(input(" Load r "))
   xa = float(input(" Load x "))
   za = complex(ra, xa)

# Type 1 - Shunt C/Series L
   if (ra < 50):
        x = sqrt(ra*(50-ra))-xa
        zseries = complex(0,x)
        lseries = x/(2*pi*freq*1e6)
        if (x/qinduc/ra> 0.2):
            ra = ra + x/qinduc
            za = za + x/qinduc    # add series resistance of inductor to antenna R to get closer solution
        b=sqrt((50-ra)/ra)/50
        zshunt = complex(0,-1/b)
        cshunt = b/2/pi/freq/1e6
        zin = 1/(1/zshunt+1/(za+zseries))
        zshunt = zshunt + 1/b/qcap
        zseries = zseries + x/qinduc
#        zin=zshunt*(za+zseries)/(zshunt+zseries+za)
        rho = abs(cma.sqrt(((zin.real-50)**2 + (zin.imag)**2)/((zin.real+50)**2 + (zin.imag)**2)))
        swr = abs((1+rho)/(1-rho))
        ia=iin*zshunt/(zshunt+zseries+za)
        ishunt = iin*(zseries+za)/(zshunt+zseries+za)
        vcap = abs(ishunt*zshunt)
        pcap = abs(ishunt)**2*zshunt.real
        iarms = abs(ia)
        pseries = iarms*iarms*zseries.real
        pa = iarms*iarms*za.real
        print( "Type 1 Shunt C/Series L configuration")
        print( "Freq %6.2f" % freq)
        print( "Lseries %6.2f uH  Cshunt %6.2f pF" % (1.0e6*lseries, 1.0e12*cshunt))
        print( "Input Z  %6.2f %6.2f j" % (zin.real, zin.imag))
        print( "rho %6.2f SWR %6.2f " % (rho, swr))
        print( "Ant current %6.2f %6.2fj A" % (ia.real, ia.imag))
        print( "Ant power %6.2f W  " % pa)
        print( "Coil power %6.2f W " % pseries)
        print( "Capacitor voltage, power %6.2f V %6.2f W" % (vcap,pcap))

## Type 3 Shunt L series C
#
#        b = -sqrt((50-ra)/ra)/50
#        zshunt = complex(-1/b/qinduc,-1/b)
#        lshunt = -1./(2.*pi*freq*b)
#        x = -sqrt(ra*(50-ra))-xa
#        zseries = complex(x/qcap,x)
#        cseries = -1.e6/(2*pi*freq*x)
#        zin=zshunt*(za+zseries)/(zshunt+zseries+za)
#        rho = abs(cma.sqrt(((zin.real-50)**2 + (zin.imag)**2)/((zin.real+50)**2 + (zin.imag)**2)))
#        swr = abs((1+rho)/(1-rho))
#        ia=iin*zshunt/(zshunt+zseries+za)
#        ishunt = iin*(zseries+za)/(zshunt+zseries+za)
#        iarms = abs(ia)
#        vcap = abs(ia*zseries)
#        pcap = abs(ia)**2*zseries.real
#        pinduc = abs(ishunt)**2*zshunt.real
#        pa = iarms*iarms*za.real
#        print "\nType 3 Shunt L/Series C configuration"
#        print "Freq %6.2f" % freq
#        print "Lshunt%6.2f uH  Cseries %6.2f pF" % (lshunt, cseries)
#        print "Input Z  %6.2f %6.2fj" % (zin.real, zin.imag)
#        print "rho %6.2f SWR %6.2f " % (rho, swr)
#        print "Ant current %6.2f %6.2fj" % (ia.real, ia.imag)
#        print "Ant power %6.2f  " % pa
#        print "Shunt current %6.2f %6.2fj" % (ishunt.real, ishunt.imag)
#        print "Coil power %6.2f " % pinduc
#        print "Capacitor voltage, power %6.2f V %6.2f W " % (vcap, pcap)

   else:
# if ra < 50 then the square roots below willbe negative. sp slo[]7
    
## Type 4 Series C/Shunt L
##7.1

## Shunt element is L, want b < 0
#        b = (xa - sqrt(ra/50)*sqrt(ra*ra+xa*xa-50*ra))/(ra*ra+xa*xa)
#        if b < 0:
#            zshunt = complex(-1/b/qinduc,-1/b)
#            lshunt = -1.0/(2.0*pi*freq*b)
### Series C so  x < 0
#            x = 1/b+50*xa/ra-50/(b*ra)
#            zseries = complex(x/qcap,x)
#            cseries = -1e6/(x*2*pi*freq)
#            zin=zseries+zshunt*za/(zshunt+za)
#            rho = sqrt(((zin.real-50)**2 + (zin.imag)**2)/((zin.real+50)**2 + (zin.imag)**2))
#            swr = abs((1+rho)/(1-rho))
#            ishunt = iin*za/(za+zshunt)
#            ishrms = abs(ishunt)
#            pshunt = ishrms*ishrms*zshunt.real
#            ia = iin*zshunt/(za+zshunt)
#            iarms = abs(ia)
#            vcap = abs(iin*zseries)
#            pcap = iin*iin*zseries.real
#            pa = iarms*iarms*za.real
#            print "\nType 4 Series C/Shunt L configuration"
#            print "Freq %6.2f" % freq
#            print "Lshunt %6.2f uH  Cseries %6.2f pF" % (lshunt, cseries)
#            print "Input Z  %6.2f %6.2fj" % (zin.real, zin.imag)
#            print "rho %6.2f SWR %6.2f " % (rho, swr)
#            print "Ant current %6.2f %6.2fj" % (ia.real, ia.imag)
#            print "Ant power %6.2f  " % pa
#            print "Shunt current %6.2f %6.2fj" % (ishunt.real, ishunt.imag)
#            print "Coil power %6.2f " % pshunt
#            print "Capacitor voltage, power %6.2f V %6.2f W " % (vcap, pcap)
#    
    ## Type 2 - Series L/Shunt C
    ##
    ##  shunt element is C so b > 0
        b = (xa +sqrt(ra/50)*sqrt(ra*ra+xa*xa-50*ra))/(ra*ra+xa*xa)
        zshunt = complex(-1/b/qcap,-1/b)
        cshunt = b/(2.*pi*freq*1e6)
    ## series L so x > 0
        x = 1.0/b+50*xa/ra-50/(b*ra)
        zseries = complex(x/qinduc,x)
        lseries = x/(2.*pi*freq*1e6)
        zin=zseries+zshunt*za/(zshunt+za)
        rho = sqrt(((zin.real-50)**2 + (zin.imag)**2)/((zin.real+50)**2 + (zin.imag)**2))
        swr = abs((1+rho)/(1-rho))
        pinduc = iin*zseries.real
        ia = iin*zshunt/(za+zshunt)
        ishunt = iin*za/(za+zshunt)
        vcap = abs(ishunt*zshunt)
        pcap = abs(ishunt)**2*zshunt.real
        iarms = abs(ia)
        pa = iarms*iarms*za.real
        print("Type 2 Series L/Shunt C configuration")
        print("Freq %6.2f" % freq)
        print("Lseries %6.2f uH  Cshunt %6.2f pF" % (1.0e6*lseries, 1.0e12*cshunt))
        print("Input Z  %6.2f %6.2f j" % (zin.real, zin.imag))
        print("rho %6.2f SWR %6.2f " % (rho, swr))
        print("Ant current %6.2f %6.2fj A" % (ia.real, ia.imag))
        print("Ant power %6.2f W  " % pa)
        print("Coil power %6.2f W " % pinduc)
        print("Capacitor voltage, power %6.2f V %6.2f W" % (vcap,pcap))

