#!/usr/bin/python3
#
#
#
#  Program to read temperature from the Max31865, once a second
# and save it in a file named temperature.txt
#
# It does this for five minutes
#
#
# Jim Koehler, Comox, BC, January, 2018
#
###############################################

import max31865
import RPi.GPIO as GPIO
import time, math
import test_GPIO as GP
import os

oven_status = 0

def oven_on():
    GP.fan_on()
    GP.on_led_on()
    GP.ready_off()
    GP.off_led_off()
    return 1
    
def oven_off():
    GP.on_led_off()
    GP.off_led_on()
    GP.ready_on()
    return 0    

max = max31865.max31865(8, 9, 10, 11)
temp = max.readTemp()
print(round(temp, 2))
GP.init_gpio()

fp = open("temperature.txt", 'w')
fp.write('#'+time.strftime('%a_%d_%b_%Y_%H_%M_%S\r\n\n', time.localtime()))

GP.off_led_on()
GP.ready_on()

t = 0
while (t < 500):

    if GP.start_pressed(): oven_status = oven_on()
    if GP.stop_pressed(): oven_status = oven_off()
    if GP.halt_pressed():
        GP.fan_off()
        break
    temp = round(max.readTemp(), 2)
    if (temp > 150.0): oven_status = oven_off()
    print(temp)
    str='{0}\t{1}\t{2}\n\r'.format(t, temp, 10 * oven_status)
    fp.write(str)
    t+=1
    time.sleep(0.9)


fp.close()
GP.fan_off()
GP.ready_on()
GPIO.cleanup()
os.system("gnuplot temp.gp")
os.system("feh temp.png&")

          
