#
# program to plot a scan of admittance vs frequency
# 
#
# Jim Koehler, Comox, December 2017
#
#

# usage, called  by:
#
# gnuplot -c admitplot_l.gp centre_f a b c a1 b1
#
# where centre_f is the central frequency in Hz,
# where a, b and c are the best fit parameters to G curve,
# a1, b1 are best fit parameters to phase curve
#
# last changes made June, 2019
#
#
set terminal push
set terminal png
set output "adm.png"
unset logscale y
unset logscale x
set grid mxtics mytics xtics ytics
#set grid
#unset xrange
set y2range [-1.5:1.5]
set title "Centre Frequency: ". ARG1
set ylabel "Siemens"
set y2label "Radians"
set xlabel "Frequency in Hz"
f(x) =  ARG4 / (1.0 + (ARG2*(x-ARG3))**2)
g(x) = atan(ARG5 * (ARG6 - x))
plot "adm.txt" u ($1 - ARG1):2 axes x1y1 w points t "G" lt rgb "black", \
"" u ($1 - ARG1):4 axes x1y2 w points t "Phase" lt rgb "red", \
f(x) axes x1y1  lt rgb "blue", \
g(x) axes x1y2  lt rgb "green"

set terminal pop

