#!/usr/bin/python3
"""

 Program: freq_cal.py
 Jim Koehler, Comox, April, 2019
 
 
"""

from breezypythongui import EasyFrame
import serial


class SetFreq(EasyFrame):

    def __init__(self):
        """Sets up the window and widgets."""
        EasyFrame.__init__(self, title = "Frequency Calibration")
        self.setSize(450, 90)
        self.setResizable(False)
        self.setBackground("#c00fffc00")

        # Label and field for the frequency
        
        self.addLabel(text = "Frequency (Hz)",
                      row = 0, column = 2, background = "#d80fffd80")
        self.freqField = self.addIntegerField(value = 15000000,
                                               row = 1,
                                               column = 2,
                                               width = 10)

        # command buttons
        self.addButton(text = "<<", row = 1, column = 0, command = self.minus_ten)
        self.addButton(text = "<", row = 1, column = 1, command = self.minus_one)
        self.addButton(text = ">", row = 1, column = 3, command = self.plus_one)
        self.addButton(text = ">>", row = 1, column = 4, command = self.plus_ten)
        
        self.comm = serial.Serial('/dev/ttyACM0', baudrate = 115200, timeout = 0.3)
        self.comm.readlines()    # flush the read buffer
        f = self.freqField.getNumber()
        msg_string = "f " + str(f) + "\r"
        self.comm.write(bytearray(msg_string, "ascii"))

    # The event handling method for the buttons
    def minus_ten(self):
        f=self.freqField.getNumber()
        f -= 10
        self.freqField.setNumber(f)
        f = self.freqField.getNumber()
        msg_string = "f " + str(f) + "\r"
        self.comm.write(bytearray(msg_string, "ascii"))
 		
    def minus_one(self):
        f=self.freqField.getNumber()
        f -= 1
        self.freqField.setNumber(f)
        f = self.freqField.getNumber()
        msg_string = "f " + str(f) + "\r"
        self.comm.write(bytearray(msg_string, "ascii"))
		
    def plus_ten(self):
        f=self.freqField.getNumber()
        f += 10
        self.freqField.setNumber(f)
        f = self.freqField.getNumber()
        msg_string = "f " + str(f) + "\r"
        self.comm.write(bytearray(msg_string, "ascii"))
		
    def plus_one(self):
        f=self.freqField.getNumber()
        f += 1
        self.freqField.setNumber(f)
        f = self.freqField.getNumber()
        msg_string = "f " + str(f) + "\r"
        self.comm.write(bytearray(msg_string, "ascii"))
        
    def set_freq(f):
        return
		

#Instantiate and pop up the window."""
if __name__ == "__main__":
    SetFreq().mainloop()
