#!/usr/bin/python3
"""

 Jim Koehler, Comox, April, 2019


"""

from breezypythongui import EasyFrame
import math
import os

class Transfer(EasyFrame):

    def __init__(self):
        """Sets up the window and widgets."""
        EasyFrame.__init__(self, title = "Transfer Response Program")
        self.setSize(450, 200)
        self.setResizable(False)
        self.setBackground("#c00fffc00")

        # Label and field for the lower frequency pound
        self.addLabel(text = "Lower boundary (MHz)",
                      row = 0, column = 0, background = "#d80fffd80")
        self.lowerField = self.addFloatField(value = 1.0,
                                               row = 0,
                                               column = 0,
                                               width = 8,
                                               precision = 2)

        # Label and field for the upper frequency bound
        self.addLabel(text = "Upper boundary (MHz)",
                      row = 1, column = 0, background = "#d80fffd80")
        self.upperField = self.addFloatField(value = 600.0,
                                              row = 1,
                                              column = 0,
                                              width = 8,
                                              precision = 2)

        # Label and field for the number of points
        self.addLabel(text = "Number of points",
                      row = 2, column = 0, background = "#d80fffd80")
        self.numberField = self.addIntegerField(value = 100,
                                              row = 2,
                                              column = 0,
                                              width = 4)

         # Label and field for the filename
        self.addLabel(text = "Base filename",
                      row = 3, column = 0, background = "#d80fffd80")
        self.filenameField = self.addTextField(text = "****",
                                              row = 3,
                                              column = 0,
                                              width = 10)

        self.addLabel(text = '', row = 0, column = 1, background = "#c00fffc00")


        # The command buttons
        self.CalButton =  self.addButton(text = "Cal.", row = 4, column = 0,
                       columnspan = 2, command = self.startCal)

        self.MeasButton =  self.addButton(text = "Meas.", row = 4, column = 2,
                          columnspan = 2, command = self.startMeas,
                          state = "disabled")

      # The event handling method for the button
    def startCal(self):
        self.MeasButton["state"] = "disabled"
        b = self.lowerField.getNumber()
        u = self.upperField.getNumber()
        n = self.numberField.getNumber()
        mess = "./make_trans_cal.py "
        mess += str(int(b * 1e6)) + " "
        mess += str(int(u * 1e6)) + " "
        mess += str(int(n)) + " "
        os.system(mess)
        self.MeasButton["state"] = "normal"

    def startMeas(self):
        mess = "./trans_scan.py "
        filename = self.filenameField.getText()
        if filename == "****":
            filename = "temporary"
        mess += filename
        os.system(mess)


#Instantiate and pop up the window."""
if __name__ == "__main__":
    Transfer().mainloop()
