#!/usr/bin/python3
"""

 Jim Koehler, Comox, April, 2019
 
 
"""

from breezypythongui import EasyFrame
import math
import os

class Scan(EasyFrame):

    def __init__(self):
        """Sets up the window and widgets."""
        EasyFrame.__init__(self, title = "Imedance Program")
        self.setSize(450, 200)
        self.setResizable(False)
        self.setBackground("#c00fffc00")

        # Label and field for the lower frequency pound
        self.addLabel(text = "Lower boundary (MHz)",
                      row = 0, column = 0, background = "#d80fffd80")
        self.lowerField = self.addFloatField(value = 1.0,
                                               row = 0,
                                               column = 0,
                                               width = 8,
                                               precision = 2)

        # Label and field for the upper frequency bound
        self.addLabel(text = "Upper boundary (MHz)",
                      row = 1, column = 0, background = "#d80fffd80")
        self.upperField = self.addFloatField(value = 600.0,
                                              row = 1,
                                              column = 0,
                                              width = 8,
                                              precision = 2)

        # Label and field for the number of points
        self.addLabel(text = "Number of points",
                      row = 2, column = 0, background = "#d80fffd80")
        self.numberField = self.addIntegerField(value = 100,
                                              row = 2,
                                              column = 0,
                                              width = 4)
                                              
         # Label and field for the filename
        self.addLabel(text = "Base filename",
                      row = 3, column = 0, background = "#d80fffd80")
        self.filenameField = self.addTextField(text = "****",
                                              row = 3,
                                              column = 0,
                                              width = 10)
                                              
        self.addLabel(text = '', row = 0, column = 1, background = "#c00fffc00")                                              
                                              
       # radio button group for Y or Z
        self.addLabel(text="Type", row = 0, column=3, background = "#d80fffd80")
        self.typeGroup=self.addRadiobuttonGroup( row = 1, column = 3)
        defaultRB = self.typeGroup.addRadiobutton(text="Z")
        self.typeGroup.setSelectedButton(defaultRB)
        self.typeGroup.addRadiobutton(text="Y")
                                                       

        # radio button group for logarithmic or linear
        self.addLabel(text="Scale", row = 2, column=3)
        self.scaleGroup=self.addRadiobuttonGroup( row = 3, column = 3)
        defaultRB = self.scaleGroup.addRadiobutton(text="Lin.")
        self.scaleGroup.setSelectedButton(defaultRB)
        self.scaleGroup.addRadiobutton(text="Log.")
                                                       



        # The command button
        self.addButton(text = "Scan", row = 4, column = 0,
                       columnspan = 2, command = self.startScan)

    # The event handling method for the button
    def startScan(self):
        b = self.lowerField.getNumber()
        u = self.upperField.getNumber()
        n = self.numberField.getNumber()
        filename = self.filenameField.getText()
        if self.typeGroup.getSelectedButton()["text"] == "Z":
            mess = "./z_scan.py "
        else:
            mess = "./y_scan.py "
        mess += str(int(b * 1e6)) + " "
        mess += str(int(u * 1e6)) + " "
        mess += str(int(n)) + " "
        if filename == "****":
            filename = "temporary"
        mess += filename + " "
        if self.scaleGroup.getSelectedButton()["text"] == "Lin.":
            mess += "1\r"
        else:
            mess += "0\r"
        
        os.system(mess)
		

#Instantiate and pop up the window."""
if __name__ == "__main__":
    Scan().mainloop()
