#
# program to plot a scan of transmission vs frequency
#
# Jim Koehler, Comox, December 2017
#
# amended April, 2019 to set limits to the xrange as passed arguments
# and to automatically switch from linear to logarithmic if the
# ratio of high to low frequency is greater than or equal to ten
#
set terminal push
set terminal png
set output "scan.png"
set yrange [-40 :0]
#set logscale x
unset logscale x
#if ((ARG2 / ARG1) >= 10) {set logscale x}
set grid mxtics mytics xtics ytics
set y2tics -3.0, 1.0
set ytics nomirror
set xrange [(ARG1/1000000):(ARG2/1000000)]
set title "Transmission vs Frequency"
set ylabel "dB"
set y2label "Radians"
set xlabel "Frequency in MHz"
plot "trans.txt" u ($1/1000000):2 w lines t "Magnitude" lt rgb "black" axis x1y1, "" u ($1/1000000):3 w lines t "Phase" lt rgb "red" axis x1y2
set terminal pop

