// =====================================================================================================================================================================================================
// (c) 2021 Lynn Hansen, KU7Q															                                                                                                               |
// This Source Code Form is subject to the terms of the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007. A copy of this license can be found here: https://choosealicense.com/licenses/gpl-3.0/|
// =====================================================================================================================================================================================================




// THIS FILE CONTAINS CODE TO CONNECT TO AND MANAGE ESP8266 WIFI MODULE


void SetESPState(uint8_t action)
{
	//bWiFi pressed, update wifi state
	String txt = "";
	blockISR = true; //block decoders while connecting to esp
	blockHMI = millis() + 5000;
	if (action == 0)
	{
		//disconnect
		if (hmiPage != HMI_HOME)
		{
			Tx2HMI("page Home");
		}
		if (client)
		{
			SerialOut("Stopping Client", true);
			client.stop();
		}
		if (flexAPI)
		{
			flexAPI.stop();
			SerialOut("Stopping flexAPI", true);
			Tx2HMI("Home.bRx.txt=`Disconnecting Flex Slice A   `");
			Tx2HMI("Home.bRx.txt=`Disconnecting Flex Slice A   `");
		}
		WiFi.disconnect();
		WiFi.endAP();
		ESP.end();
		Tx2HMI("Home.bRx.txt=`WiFi Disconnected       ");
		Tx2HMI("gFlexCon=0");
		Tx2HMI("gFlexCon=0");
		Tx2HMI("Config.bWiFi.txt=`Enable WiFi`");
		Tx2HMI("Config.bWiFi.bco=BASEBCO");
	}
	else if (action == 1)
	{
		//start station mode	
		Tx2HMI("Home.bRx.txt=`Connecting to " + gSSID + "...  `");		
		ESP.end();
		delay(10);
		ESP.begin(115200);
		WiFi.init(ESP);

		WiFi.disconnect(); // to clear the way. not persistent

		WiFi.setPersistent(); // set the following WiFi connection as persistent

		WiFi.endAP(); // to disable default automatic start of persistent AP at startup

		//set station properties
		char ssid[29];
		char key[29];
		gSSID.toCharArray(ssid, 29); //convert these to a char array
		gStaKey.toCharArray(key, 29);

		unsigned int i[5] = { 0, 0, 0, 0, 0 };
		char str[17];

		gStaAdrs.toCharArray(str, 17);
		sscanf(str, "%u.%u.%u.%u", &i[0], &i[1], &i[2], &i[3]);
		IPAddress ip(i[0], i[1], i[2], i[3]);
		gSubnet.toCharArray(str, 17);
		sscanf(str, "%u.%u.%u.%u", &i[0], &i[1], &i[2], &i[3]);
		IPAddress nm(i[0], i[1], i[2], i[3]);
		gGW.toCharArray(str, 17);
		sscanf(str, "%u.%u.%u.%u", &i[0], &i[1], &i[2], &i[3]);
		IPAddress gw(i[0], i[1], i[2], i[3]);

		WiFi.config(ip, gw, gw, nm);

		Tx2HMI("Home.bRx.txt=`Establishing WiFi connection...  '");

		if (WiFi.status() == WL_NO_MODULE)
		{
			Tx2HMI("Home.bRx.txt=`WiFi module failed!        `");
			gWiFi = 0;
			Tx2HMI("gWiFi=0");
			Tx2HMI("gWiFi=0");
			delay(2000);
			goto ExitHr;
		}
		WiFi.begin(ssid, key);

		// waiting for connection to Wifi network set with the SetupWiFiConnection sketch

		for (int i = 0; i < 6; i++)
		{
			if (WiFi.status() != WL_CONNECTED)
			{
				delay(1000);
				//SerialOut('.', false);
			}
		}
		if (WiFi.status() != WL_CONNECTED)
		{
			Tx2HMI("Home.bRx.txt=`IP Connection Failed!        `");
			delay(2000);
			gWiFi = 0;
			Tx2HMI("gWiFi=0"); //turn off wifi
			Tx2HMI("gWiFi=0");
			goto ExitHr;
		}

		server.begin();

		ip = WiFi.localIP();
		int32_t rssi = WiFi.RSSI();
		Tx2HMI("Home.bRx.txt=`Connected to " + gSSID + " - RSSI:" + String(rssi) + "  `");
		delay(2000);
	}
ExitHr:
	gWiFiPrev = gWiFi; //reset trigger
	blockISR = false;
	blockHMI = 0;
}


String Tx2ESP(int dest, String txt)
{
	String reply = "";

	if (dest == ESP_FLEX && gFlexCon)
	{
		//SerialOut(txt, true);	

		if (ISRActive)
		{
			//if we're in an ISR que this command and return with no reply
			espTxQue = txt;
			return reply;
		}

		if (espTxQue.length() > 0)
		{
			//swap with txt and send que
			String temp = txt;
			txt = espTxQue;
			espTxQue = temp;
		}
		else if (txt.length() < 1)
		{
			//called without txt to chk for tx que commands
			if (espTxQue.length() > 0)
			{
				txt = espTxQue; //see if anything is pending
				espTxQue = ""; //reset que
			}
			else
			{
				return reply;
			}
		}
	}

	char msg[100];

	if (gWiFi && dest == ESP_FLEX)
	{
		//format command to tx to flex
		txt = "c" + String(gFlexCmdNum) + txt + "\r\n";
CreateSlc:
		gFlexCmdNum++;
		txt.toCharArray(msg, txt.length() + 1);
		flexAPI.write(msg, txt.length());
		flexAPI.flush();
		//don't call this if we're in an ISR
		if (!ISRActive)
		{
			//wait 100 ms for reply to come in		
			uint32_t waitTmr = millis();
			while (100ul < millis() - waitTmr)
			{
				if (flexAPI.available())
				{
					break;
				}				
			}
			reply = Flex_ChkRx(); //send cmd to rx so it can compare rx to what was sent
			if (reply.indexOf("|slice create") > -1)
			{
				txt = reply;
				goto CreateSlc; //slice 0 doesn't exist (from slice list), send slice create cmd
			}
		}
	}
	return reply;
}
