// =====================================================================================================================================================================================================
// (c) 2021 Lynn Hansen, KU7Q															                                                                                                               |
// This Source Code Form is subject to the terms of the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007. A copy of this license can be found here: https://choosealicense.com/licenses/gpl-3.0/|
// =====================================================================================================================================================================================================



// THIS FILE CONTAINS CODE THAT MANAGES I/O FROM THE USER


void SetEncoderCtrl(int curDir)
{
	//WARNING!!!
	//This routine is called during the ISR
	//Don't call any routines that can't operate during ISR here!!!
	// NOTE: Tx2HMI() and Tx2ESP() have been fixed to put cmd in hmiTxQue or espTxQue if it's busy in ISR
	//
	//change the current gEncoder selected control by the value in curDir
	int temp = 0; //temp var for calcs
	uint8_t val = 0; //temp byte value for calcs
	String cmd = ""; //for hmi cmd
	float g = 0;

	gEncoderChng = true; //calls ChkEncoderChng() from Main loop to send changes to HMI
	blockHMI = millis() + 550; //stop processing HMI updates until change here is cleared

	//SerialOut("hmiPage=" + String(hmiPage) + ", gEncoder=" + String(gEncoder), true);
	if (hmiPage == HMI_HOME)
	{
		//change item if switch not pressed	
		switch (gEncoder)
		{
		case HMI_HOME_PG_FREQ:
			//only tx every 30 mS to allow radio to process last transmission
			//change freq by selected unit if we're not locked or PTT is active
			temp = !digitalRead(PTT_OUT) + !digitalRead(KEY_OUT);			
			if (gLock == false && temp == false)
			{				
				int32_t temp = gFreqRadio + (curDir * gUnit);				
				if (temp < 100000)
				{
					//we rolled below 100k, move gUnit
					if (gUnit > 100000)
					{
						gUnit = gUnit / 10;
						if (gUnit < 100000)
						{
							gUnit = 100000;
						}
					}
					return;
				}
				gFreqRadio = uint(temp);
				gFreqRadioPrev = 0; //force update
				//calling this may be what's causing audio lockups with flex radio
				if (gRadio != RADIO_TYPE_FLEX)
				{
					ChkFreqChange();
				}
			}
			else
			{
				goto Override;
			}
			break;
		case HMI_HOME_PG_SPEED:
			//Set gTxLev or Speed depending on selected mode
Override:
			switch (gOMode)
			{
			case MODE_VOICE:
TxLvl:			if ((gTxLev + curDir >= 0) && (gTxLev + curDir <= 100))
				{
					gTxLev += curDir; //this triggers change 											
				}
				break;
			case MODE_RTTY:
				goto TxLvl;
				break;
			case MODE_DIG:
				goto TxLvl;
				break;
			default:
				if ((cTxSpeed + curDir >= 5) && (cTxSpeed + curDir <= 50))
				{
					//we're in CW mode					
					cTxSpeed = cTxSpeed + curDir;
					//Tx2HMI("CW.cTxSpeed.val=" + String(cTxSpeed));
				}
				break;
			}
			break;
		case HMI_HOME_PG_FFTFREQ:
			//change fft freq
			gFFTFreq = gFFTFreq + (curDir * 25);
			if (gFFTFreq > 2975)
			{
				gFFTFreq = 2975;
			}
			else if (gFFTFreq < 200)
			{
				gFFTFreq = 200;
			}
			SetFilterFreq(8);
			//Tx2HMI("gFFTFreq=" + String(int(gFFTFreq / 25)));
			break;
		case HMI_HOME_PG_LPFLTR:
			//change lp filter freq							
			if (gLPFltr + curDir >= 1 && gLPFltr + curDir <= 32)
			{
				gLPFltr += curDir;
				SetFilterFreq(9);
				//Tx2HMI("gLPFltr=" + String(gLPFltr));
				switch (gOMode)
				{
				case MODE_CW:
					cLPFltr = gLPFltr;
					break;
				case MODE_VOICE:
					vLPFltr = gLPFltr;
					break;
				case MODE_RTTY:
					rLPFltr = gLPFltr;
					break;
				case MODE_DIG:
					vLPFltr = gLPFltr;
					break;
				}
			}
			break;
		case HMI_HOME_PG_NFLTR:
			//change notch freq									
			if (gNFltr + curDir >= 1 && gNFltr + curDir <= 32)
			{
				gNFltr += curDir;
				SetFilterFreq(10);
				//Tx2HMI("gNFltr=" + String(gNFltr));
				switch (gOMode)
				{
				case MODE_CW:
					cNFltr = gNFltr;
					break;
				case MODE_VOICE:
					vNFltr = gNFltr;
					break;
				case MODE_RTTY:
					rNFltr = gNFltr;
					break;
				case MODE_DIG:
					vNFltr = gNFltr;
					break;
				}
			}
			break;
		case HMI_HOME_PG_MEMCH:
			//change mem sel
			if (gLock == false)
			{
				FindNextMem(curDir);
			}
			break;
		case HMI_HOME_PG_FFTGAIN:
			//change fft gain
			gFFTGain += (curDir * 2);
			if (gFFTGain < 0)
			{
				gFFTGain = 1; //negative values invert phase and increase volumne
			}
			//if - set to 0. - gain just inverts phase
			g = gFFTGain + (gFFTLv - 50.0);
			if (g < 0)
			{
				g = LEV_OFF;
			}
			Amp_FFT.gain(g);
			Amp_FFT.update();			
			//Tx2HMI("Home.fftGain.val=" + String(gFFTGain));
			break;
		case HMI_HOME_PG_VOLGAIN:
			//change volume gain
			gVolGain += (curDir);
			if (gVolGain < 0)
			{
				gVolGain = LEV_OFF;
			}
			//Tx2HMI("Home.volGain.val=" + String(gVolGain));
			break;
		case HMI_HOME_PG_SQGAIN:
			//change squelch gain
			gSqGain += (curDir * 2);
			if (gSqGain < 1)
			{
				gSqGain = 1;
			}
			//Tx2HMI("Home.sqGain.val=" + String(gSqGain));
			break;
		}
	}
	else if (hmiPage == HMI_BAND)
	{
		switch (gEncoder)
		{
		case HMI_BAND_PG_RADIO:
			//change selected radio
			if (curDir == -1 && gRadio == 0)
			{
				//roll over - gRadio is unsigned int
				gRadio = RADIO_TYPE_NUMRADIOS - 1;
			}
			else
			{
				gRadio += curDir;
				if (gRadio >= RADIO_TYPE_NUMRADIOS)
				{
					gRadio = 0;
				}
			}
			//Tx2HMI("gRadio=" + String(gRadio));
			break;
		case HMI_BAND_PG_BAUD:
			if (curDir == 1)
			{
				gAction = 8; //inc baud and update screen baud rate when we leave the ISR
			}
			else if (curDir == -1)
			{
				gAction = 9; //dec baud
			}
			break;
		}
	}
	else if (hmiPage == HMI_CW)
	{
		switch (gEncoder)
		{
		case HMI_CW_PG_KEYER:
			cKeyrMod = cKeyrMod + curDir;
			if (cKeyrMod == KEYER_MODE_MAX)
			{
				cKeyrMod = 0; //roll over
			}
			else if (cKeyrMod > 200)
			{
				cKeyrMod = KEYER_MODE_MAX - 1;
			}
			//Tx2HMI("CW.cKeyrMod.val=" + String(cKeyrMod));
			break;
		case HMI_CW_PG_SIDETONE:
			//change sidetone level
			if ((cSideTn + curDir >= 0) && (cSideTn + curDir <= 30))
			{
				cSideTn += curDir;
			}
			//Tx2HMI("CW.cSideTn.val=" + String(cSideTn));
			break;
		case HMI_CW_PG_SPEED:
			//change tx speed
			if ((cTxSpeed + curDir >= 5) && (cTxSpeed + curDir <= 50))
			{
				cTxSpeed += curDir;
			}
			//Tx2HMI("CW.cTxSpeed.val=" + String(cTxSpeed));
			break;
		case HMI_CW_PG_FARNSP:
			//change farnsworth spacing
			if ((cFarnSp + curDir >= 5) && (cFarnSp + curDir <= 50))
			{
				cFarnSp += curDir;
			}
			Tx2HMI("CW.cFarnSp.val=" + String(cFarnSp));
			break;
		case HMI_CW_PG_LPFLTR:
			if ((cLPFltr + curDir >= 1) && (cLPFltr + curDir <= 32))
			{
				cLPFltr += curDir;
			}
			//Tx2HMI("CW.cLPFltr.val=" + String(cLPFltr));
			break;
		case HMI_CW_PG_NFLTR:
			if ((cNFltr + curDir >= 1) && (cNFltr + curDir <= 32))
			{
				cNFltr += curDir;
			}
			//Tx2HMI("CW.cNFltr.val=" + String(gNFltr));
			break;
		}
	}
	else if (hmiPage == HMI_VOICE)
	{
		switch (gEncoder)
		{
		case HMI_VOICE_PG_EQ0:
			if (gEQSel == false)
			{
				//setting rx
				val = gRx0;
			}
			else
			{
				val = gTx0;
			}
			if ((val + curDir >= 0) && (val + curDir <= 20))
			{
				if (gEQSel == false)
				{
					gRx0 += curDir;
				}
				else
				{
					gTx0 += curDir;
				}
			}
			break;
		case HMI_VOICE_PG_EQ1:
			if (gEQSel == false)
			{
				//setting rx
				val = gRx1;
			}
			else
			{
				val = gTx1;
			}
			if ((val + curDir >= 0) && (val + curDir <= 20))
			{
				if (gEQSel == false)
				{
					gRx1 += curDir;
				}
				else
				{
					gTx1 += curDir;
				}
			}
			break;
		case HMI_VOICE_PG_EQ2:
			if (gEQSel == false)
			{
				//setting rx
				val = gRx2;
			}
			else
			{
				val = gTx2;
			}
			if ((val + curDir >= 0) && (val + curDir <= 20))
			{
				if (gEQSel == false)
				{
					gRx2 += curDir;
				}
				else
				{
					gTx2 += curDir;
				}
			}
			break;
		case HMI_VOICE_PG_EQ3:
			if (gEQSel == false)
			{
				//setting rx
				val = gRx3;
			}
			else
			{
				val = gTx3;
			}
			if ((val + curDir >= 0) && (val + curDir <= 20))
			{
				if (gEQSel == false)
				{
					gRx3 += curDir;
				}
				else
				{
					gTx3 += curDir;
				}
			}
			break;
		case HMI_VOICE_PG_EQ4:
			if (gEQSel == false)
			{
				//setting rx
				val = gRx4;
			}
			else
			{
				val = gTx4;
			}
			if ((val + curDir >= 0) && (val + curDir <= 20))
			{
				if (gEQSel == false)
				{
					gRx4 += curDir;
				}
				else
				{
					gTx4 += curDir;
				}
			}
			break;
		case HMI_VOICE_PG_TXLEV:
			if ((vTxLev + curDir >= 0) && (vTxLev + curDir <= 100))
			{
				vTxLev += curDir; //this will trigger change event				
			}
			//Tx2HMI("Voice.vTxLev.val=" + String(vTxLev));
			break;
		case HMI_VOICE_PG_LPFLTR:
			if ((vLPFltr + curDir >= 1) && (vLPFltr + curDir <= 32))
			{				
				vLPFltr += curDir;
			}
			//Tx2HMI("Voice.vLPFltr.val=" + String(vLPFltr));
			break;
		case HMI_VOICE_PG_NFLTR:
			if ((vNFltr + curDir >= 1) && (vNFltr + curDir <= 32))
			{				
				vNFltr += curDir;
			}
			//Tx2HMI("Voice.vNFltr.val=" + String(vNFltr));
			break;
		}
	}
	else if (hmiPage == HMI_RTTY)
	{
		switch (gEncoder)
		{
		case HMI_RTTY_PG_FREQ:
			gRtyFrq += curDir;
			if (gRtyFrq > 200)
			{
				gRtyFrq = RTTY_FREQ_2295; //255 is -1, roll backwards 
			}
			else if (gRtyFrq >= RTTY_FREQ_MAX)
			{
				gRtyFrq = RTTY_FREQ_2125;
			}
			//Tx2HMI("RTTY.gRtyFrq.val=" + String(gRtyFrq));
			break;
		case HMI_RTTY_PG_SHIFT:
			gRtySft += curDir;
			if (gRtySft > 200)
			{
				gRtySft = RTTY_SHIFT_850; //roll over
			}
			else if (gRtySft >= RTTY_SHIFT_MAX)
			{
				gRtySft = RTTY_SHIFT_170;
			}
			//Tx2HMI("RTTY.gRtySft.val=" + String(gRtySft));
			break;
		case HMI_RTTY_PG_STOP:
			gRtyStp += curDir;
			if (gRtyStp > 200)
			{
				gRtyStp = RTTY_STOP_2; //roll over
			}
			else if (gRtyStp >= RTTY_STOP_MAX)
			{
				gRtyStp = RTTY_STOP_1;
			}
			//Tx2HMI("RTTY.gRtyStp.val=" + String(gRtyStp));
			break;
		case HMI_RTTY_PG_BAUD:
				gRtyBaud += curDir;
				if (gRtyBaud > 200)
				{
					gRtyBaud = RTTY_BAUD_100; //roll over
				}
				else if (gRtyBaud >= RTTY_BAUD_MAX)
				{
					gRtyBaud = RTTY_BAUD_45;
				}
				//Tx2HMI("RTTY.gRtyBaud.val=" + String(gRtyBaud));
				break;		
		case HMI_RTTY_PG_TXLEV:
			if ((rTxLev + curDir >= 0) && (rTxLev + curDir <= 100))
			{				
				rTxLev += curDir;
			}
			//Tx2HMI("RTTY.rTxLev.val=" + String(rTxLev));
			break;
		case HMI_RTTY_PG_LPFLTR:
			if ((rLPFltr + curDir >= 1) && (rLPFltr + curDir <= 32))
			{				
				rLPFltr += curDir;
			}
			//Tx2HMI("RTTY.rLPFltr.val=" + String(rLPFltr));
			break;
		case HMI_RTTY_PG_NFLTR:
			if ((rNFltr + curDir >= 1) && (rNFltr + curDir <= 32))
			{				
				rNFltr += curDir;
			}
			//Tx2HMI("RTTY.rNFltr.val=" + String(rNFltr));
			break;
		}
	}
	else if (hmiPage == HMI_DIG)
	{
		switch (gEncoder)
		{
		case HMI_DIG_PG_TXLEV:
			if ((dTxLev + curDir >= 0) && (dTxLev + curDir <= 100))
			{				
				dTxLev += curDir;
			}
			//Tx2HMI("Dig.dTxLev.val=" + String(dTxLev));
			break;
		case HMI_DIG_PG_VOXLEV:
			if ((gDigVoxLev + curDir >= 0) && (gDigVoxLev + curDir <= 10))
			{
				gDigVoxLev += curDir;
			}
			//Tx2HMI("Dig.gVoxLev.val=" + String(gDigVoxLev));
			break;
		}
	}
	else if (hmiPage == HMI_FREQMEM)
	{		
		//if (gEncoder == 1) -- always force to 1
		{
			hmiFreqMemStartAt = hmiFreqMemStartAt + (10 * curDir);
			if (hmiFreqMemStartAt > 200)
			{
				//went negative
				hmiFreqMemStartAt = 91;
			}
			else if (hmiFreqMemStartAt > 100)
			{
				//roll back
				hmiFreqMemStartAt = 1;
			}
			blockHMI = millis() + 1000; //update hmi with new values before decoding this again
		}
	}
	else if (hmiPage == HMI_LOG)
	{
		//if (gEncoder == 1) - always forced to 1
		{
			if (curDir == -1)
			{
				gAction = 20; //go up
			}
			else if (curDir == 1)
			{
				gAction = 21; //go down
			}
			blockHMI = millis() + 500;
		}
	}
	else if (hmiPage == HMI_HELP)
	{
		hmiHelpPageDir = curDir;
	}
	else if (hmiPage == HMI_PCR)
	{
		switch (gEncoder)
		{
		case HMI_PCR_PG_BW:
			if ((gPCRBW + curDir >= 0) && (gPCRBW + curDir <= 4))
			{
				gPCRBW += curDir;
				gPCREncoderChng = gEncoder; //flag change by encoder
				//Tx2HMI("PCR.gBW.val=" + String(gPCRBW));
			}

			break;
		case HMI_PCR_PG_VOL:
			temp = int(gPCRVol + (curDir * 2));
			//make sure new value is in range
			if ((temp >= 0) && (temp <= 0xff))
			{
				gPCRVol += (curDir * 2);
				gPCREncoderChng = gEncoder;
			}
			//Tx2HMI("PCR.gVol.val=" + String(gPCRVol));
			break;
		case HMI_PCR_PG_SQ:
			temp = int(gPCRSq + (curDir * 2));
			if ((temp >= 0) && (temp <= 0xff))
			{
				gPCRSq += (curDir * 2);
				gPCREncoderChng = gEncoder;
			}
			//Tx2HMI("PCR.gSq.val=" + String(gPCRSq));
			break;
		case HMI_PCR_PG_IF:
			temp = int(gPCRIF + (curDir * 4));
			if ((temp >= 0) && (temp <= 0xff))
			{
				gPCRIF += (curDir * 4);
				gPCREncoderChng = gEncoder;
			}
			//Tx2HMI("PCR.gIF.val=" + String(gPCRIF));
			break;
		case HMI_PCR_PG_DSPNR:
			temp = int(gPCRDSPNR + curDir);
			if ((temp >= 0) && (temp <= 0x0f))
			{
				gPCRDSPNR += curDir;
				gPCREncoderChng = gEncoder;
			}
			//Tx2HMI("PCR.gDSPNR.val=" + String(gPCRDSPNR));
			break;
		}
	}
	else if (hmiPage == HMI_FLEX)
	{
		switch (gEncoder)
		{
		case HMI_FLEX_PG_LO:
			temp = gFlexLO + curDir;
			if (temp >= 0 && temp <= 100)
			{
				gFlexLO = temp;
			}
			//Tx2HMI("Flex.gFlexLO.val=" + String(gFlexLO));
			break;
		case HMI_FLEX_PG_PO:
			temp = gFlexPO + curDir;
			if (temp >= 0 && temp <= 100)
			{
				gFlexPO = temp;
				//Tx2HMI("Flex.gFlexPO.val=" + String(gFlexPO));
			}
			break;
		case HMI_FLEX_PG_TO:
			temp = gFlexTO + curDir;
			if (temp >= 0 && temp <= 100)
			{
				gFlexTO = temp;
			}
			//Tx2HMI("Flex.gFlexTO.val=" + String(gFlexTO));
			break;
		case HMI_FLEX_PG_WNB:
			if ((gFlexWNB & 0x7f) > 5)
			{
				curDir *= 5; //larger increments
			}
			temp = (gFlexWNB & 0x7f) + curDir; //mask off enable bit
			if (temp < 0)
			{
				temp = 0;
			}
			if (temp <= 100)
			{
				gFlexWNB = (gFlexWNB & 0x80) + temp;
				//Tx2HMI("Flex.gFlexWNB.val=" + String(gFlexWNB));
			}
			break;
		case HMI_FLEX_PG_NB:
			if ((gFlexNB & 0x7f) > 5)
			{
				curDir *= 5; //larger increments
			}
			temp = (gFlexNB & 0x7f) + curDir; //mask off enable bit
			if (temp < 0)
			{
				temp = 0;
			}
			if (temp <= 100)
			{
				gFlexNB = (gFlexNB & 0x80) + temp;
				//Tx2HMI("Flex.gFlexNB.val=" + String(gFlexNB));
			}
			break;
		case HMI_FLEX_PG_NR:
			if ((gFlexNR & 0x7f) > 5)
			{
				curDir *= 5; //larger increments
			}
			temp = (gFlexNR & 0x7f) + curDir; //mask off enable bit
			if (temp < 0)
			{
				temp = 0;
			}
			if (temp <= 100)
			{
				gFlexNR = (gFlexNR & 0x80) + temp;
				//Tx2HMI("Flex.gFlexNR.val=" + String(gFlexNR));
			}
			break;
		case HMI_FLEX_PG_AF:
			if ((gFlexAF & 0x7f) > 5)
			{
				curDir *= 5; //larger increments
			}
			temp = (gFlexAF & 0x7f) + curDir; //mask off enable bit
			if (temp < 0)
			{
				temp = 0;
			}
			if (temp <= 100)
			{
				gFlexAF = (gFlexAF & 0x80) + temp;
				//Tx2HMI("Flex.gFlexAF.val=" + String(gFlexAF));
			}
			break;
		}
	}
	else if (hmiPage == HMI_LEVELS)
	{
		switch (gEncoder)
		{
			case HMI_LEVELS_PG_LN_IN:
				if ((gLnInLv + curDir >= 0) && (gLnInLv + curDir <= 100))
				{
					gLnInLv += curDir;
				}
				break;
			case HMI_LEVELS_PG_MIC_IN:
				if ((gMicInLv + curDir >= 0) && (gMicInLv + curDir <= 100))
				{
					gMicInLv += curDir;
				}
				break;
			case HMI_LEVELS_PG_USB_IN:
				if ((gUSBInLv + curDir >= 0) && (gUSBInLv + curDir <= 100))
				{
					gUSBInLv += curDir;
				}
				break;
			case HMI_LEVLES_PG_USB_OUT:
				if ((gUSBOutLv + curDir >= 0) && (gUSBOutLv + curDir <= 100))
				{
					gUSBOutLv += curDir;
				}
				break;
			case HMI_LEVELS_PG_LN_OUT:
				if ((gLnOutLv + curDir >= 0) && (gLnOutLv + curDir <= 100))
				{
					gLnOutLv += curDir;
				}
				break;
			case HMI_LEVELS_PG_FFT:
				if ((gFFTLv + curDir >= 0) && (gFFTLv + curDir <= 100))
				{
					gFFTLv += curDir;
				}
				break;
		}
	}
	hmiEncoderTimeout = millis(); //restart timeout
	hmiUpdateCtr = 0; //immediate display update	

}

void ChkPaddles()
{
	//key sidetone on left paddle to test
	static bool ditPrev = false;
	static bool dahPrev = false;
	static uint8_t ditDebounce = 0;//must = 5 for valid dit
	static uint8_t dahDebounce = 0;
	static uint8_t lastSent = 0; //tracks last element sent - 1=dit, 2=dah	
	static uint8_t elementCtr = 0; //counts the # of active elements in keyerQue[]
	static uint32_t wdt = 0; //watch dog for stuck key
	static uint32_t keyDownStart = 0; //start of key down, used to time btTxMode indication back to Tx Enab after 1000 mS	
	static bool bothPaddles = false; //goes true when both paddles are pressed together

	static bool alreadyHr = false; //blocks recussion

	bool dit = false;
	bool dah = false;

	if (alreadyHr == true)
	{
		return;
	}
	alreadyHr = true;

	//invert paddle states for readability - paddle inputs are normally high when idle
	if (btPaddle == false)
	{
		//normal paddle input
		dit = !digitalRead(PDL_LEFT); //tip
		dah = !digitalRead(PDL_RIGHT); //ring
	}
	else
	{
		//reverse paddle input
		dit = !digitalRead(PDL_RIGHT); //ring
		dah = !digitalRead(PDL_LEFT); //tip
	}

	bool keyDown = false;

	//debounce for 5 mSec
	if (dit != ditPrev)
	{
		if (ditDebounce < 2)
		{
			ditDebounce++; //wait 4 mS before declaring it valid
			dit = !dit;
		}
		else
		{
			ditDebounce = 0;//reset debounce and allow dit to go through			
		}
	}
	if (dah != dahPrev)
	{
		if (dahDebounce < 2)
		{
			dahDebounce++;
			dah = !dah;
		}
		else
		{
			dahDebounce = 0;
		}
	}

	if (cKeyrMod == KEYER_PASSTHRU || gDisLeft == true)
	{
		//just pass dits and dahs to key and PTT toward radio
		goto Paddles;
	}

	//que processor

	if (elementCtr > 0)
	{
		//dec or inc keyerQue[0] until it reaches 0 - if positive, we're key down, if negative we're spacing
		if (keyerQue[0] > 0)
		{
			//counting down key down time
			keyerQue[0]--;
			keyDown = true;
		}
		else if (keyerQue[0] < 0)
		{
			//counting up space time
			keyerQue[0]++;
		}
		if (keyerQue[0] == 0)
		{
			//we've reached the end of this period, rotate keyerQue[] to see if there's more to send
			for (int i = 1; i < 20; i++)
			{
				keyerQue[i - 1] = keyerQue[i];
				keyerQue[i] = 0;
			}
			elementCtr--;
			if (keyerQue[0] != 0)
			{
				//que is not empty, sent next element
				keyDown = true;
				if (keyerQue[0] >= keyerDitDur * 2)
				{
					lastSent = 2; //this element is a dah						
				}
				else if (keyerQue[0] < 0)
				{
					bothPaddles = false; //only look for both paddles after space
				}
				else if (keyerQue[0] < keyerDitDur * 2)
				{
					lastSent = 1; //this element is a dit										
				}
			}
			else
			{
				if (cKeyrMod == KEYER_IAMBIC_B && bothPaddles == true && dit == false && dah == false)
				{
					//if we're done sending see if we squeezed during input - send opposite chr as lastSent
					//SerialOut("Squeeze released, dit = " + String(dit) + ", dah = " + String(dah) + ", lastSent = " + String(lastSent), true);
					bothPaddles = false;
					//release squeezed, add opposite chr
					if (lastSent == 1)
					{
						SerialOut("adding extra dah", true);
						keyerQue[elementCtr] = keyerDitDur * 3; //add a dah after ending space						
					}
					else
					{
						ditPrev = dit;
						SerialOut("adding extra dit", true);
						keyerQue[elementCtr] = keyerDitDur; //add a dit						
					}
					elementCtr++;
					keyerQue[elementCtr] = -keyerDitDur; //add ending space
					elementCtr++;
				}
			}
		}
	}
	else
	{
		//this is where we send chrs from hmi_bTx

		//que is empty, check for tx buffer data
		//chk to see if we have a chr to send from Home.bTx.txt
		if (hmi_bTx.length() > 0 && hmi_bTx != "Tx:" && hmi_bTx != char(0xff) && gPlay == true)
		{
			//load chr elements from first chr in hmi_bTx then remove it from string & send string back to display
			String txChar = hmi_bTx.charAt(0);

			//chk for pause
			if (txChar == '*')
			{				
				alreadyHr = false;
				return;
			}

			hmi_bTx.remove(0, 1);
			if (hmi_bTx.length() == 0)
			{
				hmi_bTx = char(0xff); //end - send 'Tx:' to bTx.txt	after last digit sent
			}
			if (txChar == ' ')
			{
				//add word space 
				keyerQue[elementCtr] = -(keyerDitFarnsDur * 4); //only add four dit times instead of 7 because we already have 3 from the last chr space
				elementCtr++;
			}
			else
			{
				txChar.toLowerCase();
				String txt = TxChar2Morse(txChar); //convert chr to morse symbols then stuff the elements here and clear the buffer								
				for (uint i = 0; i < txt.length(); i++)
				{
					if (txt.charAt(i) == '.')
					{
						keyerQue[elementCtr] = keyerDitDur; //dit
						elementCtr++;
						//add element space
						keyerQue[elementCtr] = -keyerDitDur;
						elementCtr++;
					}
					else if (txt.charAt(i) == '-')
					{
						keyerQue[elementCtr] = keyerDitDur * 3; //dah
						elementCtr++;
						//add element space
						keyerQue[elementCtr] = -keyerDitDur;
						elementCtr++;
					}
				}
				//add chr space at the end of letter
				keyerQue[elementCtr - 1] = -(keyerDitFarnsDur * 3); //replace last interdigit space with chr space					
			}
		}

		//que completed, see if we have paddles still pressed 					
		if (dit == true && dah == true)
		{
			//both squeezed
			if (cKeyrMod == KEYER_IAMBIC_A || cKeyrMod == KEYER_IAMBIC_B)
			{
				if (lastSent == 2)
				{
					//last element sent was a dah, add a dit
					lastSent = 1; //toggle for next pass
					keyerQue[elementCtr] = keyerDitDur;
				}
				else
				{
					//add a dah 
					lastSent = 2;
					keyerQue[elementCtr] = keyerDitDur * 3;
				}
				elementCtr++;
			}
			else if (cKeyrMod == KEYER_ULTIMATIC)
			{
				//lastSent holds first element of squeezed chr
				bothPaddles = true;
				if (lastSent == 2)
				{
					//if dit was first, send continous dahs
					keyerQue[elementCtr] = keyerDitDur * 3;
				}
				else
				{
					//else if dah was first, send continous dits
					keyerQue[elementCtr] = keyerDitDur;
				}
				elementCtr++;
			}
			else if (cKeyrMod == KEYER_BUG)
			{
				//just send dits
				keyerQue[elementCtr] = keyerDitDur;
				elementCtr++;
			}
			//add a space
			keyerQue[elementCtr] = -(keyerDitDur);
			elementCtr++;
		}
		else if (cKeyrMod == KEYER_BUG && dit == false)
		{
			if (dah == true && dahPrev == true)
			{
				//hold dah as long as wanted
				keyDown = true;
			}
			else if (dah == false && dahPrev == true)
			{
				//add a space at end
				keyerQue[elementCtr] = -(keyerDitDur);
				elementCtr++;
				dahPrev = dah;
			}
		}
		else if (dit == true && ditPrev == true)
		{
			//add another dit			
			lastSent = 1;
			keyerQue[elementCtr] = keyerDitDur;
			elementCtr++;
			//add a space
			keyerQue[elementCtr] = -(keyerDitDur);
			elementCtr++;
		}
		else if (dah == true && dahPrev == true)
		{
			//add another dah			
			lastSent = 2;
			keyerQue[elementCtr] = keyerDitDur * 3;
			elementCtr++;
			//add a space
			keyerQue[elementCtr] = -(keyerDitDur);
			elementCtr++;
		}
	}

	//chk paddle positions
	//If gDisLeft is true, use left paddle as a straight key so a straight key can be plugged into the Rmt PTT jack and used in this mode

Paddles:
	if (gDisLeft == true)
	{
		//left paddle disabled - use it as a straight key. This allows a straight key to be plugged into the Rmt PTT jack so the op can switch between the keyer and straight key easily
		bool leftPdl = false;
		//figure out which signal is left paddle
		if (btPaddle == false)
		{
			leftPdl = dit;
		}
		else
		{
			leftPdl = dah;
		}
		if (leftPdl == true)
		{
			wdt++;
			keyDown = true;
		}
		else
		{
			wdt = 0;
		}
		if (btPaddle == false)
		{
			ditPrev = dit;
		}
		else
		{
			dahPrev = dah;
		}
	}
	else if (cKeyrMod == KEYER_STRAIGHT)
	{
		if (dit == true)
		{
			wdt++;
			keyDown = true;
		}
		else
		{
			wdt = 0;
		}
		ditPrev = dit;
	}
	else if (cKeyrMod == KEYER_PASSTHRU)
	{
		//just send dit to Key Out and dah to PTT toward radio so we can use radio's keyer
		if (gTxMode != RADIO_TX_OFF)
		{
			if (dit == true || btTuneTx == true)
			{
				digitalWrite(KEY_OUT, LOW);
				pttWatchDog = millis(); //start watchdog
			}
			else
			{
				digitalWrite(KEY_OUT, HIGH);
			}
			ditPrev = dit;

			if (dah == true)
			{
				digitalWrite(PTT_OUT, LOW);
				//SerialOut("Dah keying radio", true);
				pttWatchDog = millis(); //start watchdog
			}
			else
			{
				digitalWrite(PTT_OUT, HIGH);
			}
			dahPrev = dah;
		}
		alreadyHr = false;
		return; //nothing left to do in this mode
	}
	else if (gDisLeft == false && ((cKeyrMod == KEYER_IAMBIC_A) || (cKeyrMod == KEYER_IAMBIC_B) || (cKeyrMod == KEYER_ULTIMATIC)))
	{
		if (dit != ditPrev)
		{
		BugMode:
			ditPrev = dit;
			if (dit == true)
			{
				//new dit - add a dit and space to keyerQue
				keyerQue[elementCtr] = keyerDitDur;
				elementCtr++;
				keyerQue[elementCtr] = -(keyerDitDur);
				elementCtr++;
				if (cKeyrMod == KEYER_ULTIMATIC && bothPaddles == false)
				{
					//save beginning element
					lastSent = 1;
				}
			}
		}
		else if (dah != dahPrev)
		{
			dahPrev = dah;
			if (dah == true)
			{
				//new dah - add a dah and space to keyerQue
				keyerQue[elementCtr] = keyerDitDur * 3; //dah timer
				elementCtr++;
				keyerQue[elementCtr] = -(keyerDitDur);
				elementCtr++;
				if (cKeyrMod == KEYER_ULTIMATIC && bothPaddles == false)
				{
					//save beginning element
					lastSent = 2;
				}
			}
		}
		if (dit == true && dah == true)
		{
			bothPaddles = true; //this sequence involved both paddles being pressed at the same time - treat special if Iambic-B or Ultimatic
		}
	}
	else if (cKeyrMod == KEYER_BUG)
	{
		if (dit != ditPrev)
		{
			goto BugMode;
		}
		else if (dah != dahPrev)
		{
			dahPrev = dah;
			if (dah == true)
			{
				wdt++;
				//new dah - add a dah to keyerQue - user can hold it longer if wanted
				keyerQue[elementCtr] = keyerDitDur * 2; //partial dah timer
				elementCtr++;
			}
			else
			{
				wdt = 0;
			}
		}
	}

	//control output based on options - turn off after 10 sec of key down
	if ((keyDown == true && wdt < 10000) || btTuneTx == true)
	{
		if (gTxModeSet2 != RADIO_TX_OFF)
		{
			gTxModeSet2 = RADIO_TX_PADDLE; //tx indicator will be reset after KEY_OUT goes high for >500 mS
			keyDownStart = millis();
			digitalWrite(KEY_OUT, LOW);
		}
		pttWatchDog = millis(); //start watchdog			
		float temp = cSideTn / 100.0;		
		Sidetone.amplitude(temp); //range is 0 to 30 with 0 being off - set amplitued 0 to .3			
	}
	else
	{
		if (gTxModeSet2 > RADIO_TX_ENAB && (millis() - keyDownStart > 1000))
		{
			gTxModeSet2 = RADIO_TX_ENAB; //reset red TX indicator back to green TX Enab
		}
		digitalWrite(KEY_OUT, HIGH);	
		Sidetone.amplitude(LEV_OFF);				
		if (keyDown == false)
		{
			wdt = 0;
		}
	}

	//failsafe
	if (elementCtr > 20)
	{
		elementCtr = 20;
	}
	alreadyHr = false;

}

void ChkPTT()
{
	//key PTT if tip of paddles is low (Ring of Mic jack is in parallel to dash paddle)	
	static bool alreadyHr = false; //blocks recurssion	
	static uint8_t keySource = 0; //0=not keyed by any source, 1=keyed by paddle

	if (alreadyHr == true)
	{
		return;
	}

	if (gTxModeSet2 == RADIO_TX_OFF)
	{
		digitalWrite(PTT_OUT, HIGH); //unkey ptt
		keySource = 0; //reset
		return;
	}

	alreadyHr = true;
	//in voice mode, the two options are PTT off/on. In any other mode there's three options, Tx Disabled, Tx Enabled, Txing
	int paddle = digitalRead(PDL_LEFT); //tip is also PTT

	//check current state
	switch (keySource)
	{
	case 0:
		if (paddle == LOW)
		{
			//we just keyed up - switch to tx mode			
			keySource = 1;
			gTxModeSet2 = RADIO_TX_PADDLE;
			digitalWrite(PTT_OUT, LOW);
			SetOutputSource(1, true); //tx mode	
			pttWatchDog = millis(); //start watchdog				
			//SerialOut("Paddle pressed", true);
		}
		break;
	case 1:
		if (paddle == LOW)
		{
			//already keyed by paddle, exit
			alreadyHr = false;
			return;
		}
		else
		{
			//paddle just released, unkey and reset btTxMode					
			keySource = 0;
			digitalWrite(PTT_OUT, HIGH);
			gTxModeSet2 = RADIO_TX_ENAB;
			SetOutputSource(0, true); //rx mode
			//SerialOut("Paddle released", true);
		}
		break;
	}

	alreadyHr = false;
}

uint8_t ChkRJ45SwitchBoards()
{
	//read rj45 data pins to determine which boards are installed. Installed boards pull their data pin low and we'll set their bit high in boards and return it
	uint8_t temp = 0;
	uint8_t boards = 0;
	pinMode(RJ_SW_DATA_1, INPUT_PULLUP); //make sure they're inputs with weak pullups
	pinMode(RJ_SW_DATA_2, INPUT_PULLUP);
	pinMode(RJ_SW_DATA_3, INPUT_PULLUP);
	pinMode(RJ_SW_DATA_4, INPUT_PULLUP);
	delay(10);
	boards = !digitalRead(RJ_SW_DATA_1); //pin will be low if board is installed, invert it so this var shows 1 for active boards
	temp = !digitalRead(RJ_SW_DATA_2);
	boards += (temp << 1);
	temp = !digitalRead(RJ_SW_DATA_3);
	boards += (temp << 2);
	temp = !digitalRead(RJ_SW_DATA_4);
	boards += (temp << 3);
	//SerialOut("RJ45 Boards= " + String(boards, HEX), true);
	Tx2HMI("Radio.gBoards.val=" + String(boards)); //update hmi so it shows highlights the installed boards
	Tx2HMI("Radio.gBoards.val=" + String(boards));
	return boards;

}



void ChkRTTYTxBuffer()
{
	static bool alreadyHr = false;

	//chk if we have chrs waiting in RTTY tx buffer, if so, get next chr and send it to TxRTTYChr()
	if (alreadyHr == true || rttyTxBusy == true || gPlay == false)
	{
		return;
	}
	alreadyHr = true;

	if (hmi_bTx.length() > 0 && hmi_bTx != "Tx:" && hmi_bTx != char(0xff) && gPlay == true)
	{
		//load chr elements from first chr in hmi_bTx then remove it from string & send string back to display
		//SerialOut("hmi_bTx=" + hmi_bTx, true);
		char txChar = hmi_bTx.charAt(0);
		hmi_bTx.remove(0, 1);
		if (hmi_bTx.length() == 0)
		{
			hmi_bTx = char(0xff); //end - send 'Tx:' to bTx.txt				
		}
		//search rttyChr[] table to find match to ascii string - then stuff the chr in rttyTxChr and set busy flag
		for (int i = 0; i < 0x40; i++)
		{
			if (txChar == rttyChr[i])
			{
				rttyTxChr = i; //we only send the 5 lsb so it doesn't matter if the chr is from the figures level				
				rttyTxBusy = true; //send it
				break;
			}
		}
	}
	alreadyHr = false;
}



void ISR_ChkDecoder()
{
	//this is an Interrupt Service Routine called every mSec to check selected mode decoder

	//ignore everything else if audio is recording 
	//if (gAudioMode == AUDIO_RECORD || blockISR || ISRActive == true)
	// 5-19-21: Seems to record Ok while servicing this ISR
	if (blockISR || ISRActive == true)
	{
		//ignore this ISR during record - use ISR_ChkRecord instead
		 //ignore while loading and saving files or if we're already running an ISR
		return;
	}

	ISRActive = true; //blocks Tx2HMI() if ISR is running - causes audio noise on tuning

	noInterrupts();
		
	switch (gOMode)
	{
	case MODE_CW:
		DemodMorse();
		break;
	case MODE_RTTY:
		DemodRTTY();
		break;
	case MODE_DIG:
		//future	
		break;
	case MODE_BEACON:
		DemodMorse();
		break;
	}

	ChkEncoder();

	if (gOMode == MODE_CW || gOMode == MODE_BEACON)
	{
		ChkPaddles(); //chks for paddle activity and sends morse tx buffer if it has anything in it
	}
	else if (gOMode == MODE_VOICE || gOMode == MODE_DIG)
	{
		ChkPTT(); //use key tip input to key PTT
	}
	else if (gOMode == MODE_RTTY)
	{
		ChkRTTYTxBuffer(); //chks RTTY tx buffer and sends it
		if (rttyTxBusy == true && gPlay == true)
		{
			TxRTTYChr(); //service rtty tx routine
		}
	}

	interrupts();

	myUsb.Task(); //serviced in the KeyboardPress_ISR routine
	
	ISRActive = false;

}


void ISR_ChkRecord()
{
	//called every .2 mS
	if (gAudioMode == AUDIO_RECORD && !blockISR && !ISRActive)
	{
		ISRActive = true;
		SD_ContinueRecording();	//only while recording
		ISRActive = false;		
	}
}


void DoAction()
{
	//perform action from gAction
	String txt = "";
	String cmd = "";
	String reply = "";
	gActionPrev = gAction; //so we don't load something else	
	if (gAction < 100)
	{
		//controls
		//SerialOut("gAction=" + String(gAction), true);
		//generic actions
		switch (gAction)
		{
		case 1: //Home.bMemDn			
			FindNextMem(-1); //dec to next valid memory location
			gEncoder = HMI_HOME_PG_MEMCH;
			gEncoderPrev = 0xff;
			hmiEncoderTimeout = millis();//start timeout
			break;
		case 2: //Home.bMemUp		
			FindNextMem(1); //inc to next valid memory location
			gEncoder = HMI_HOME_PG_MEMCH;
			gEncoderPrev = 0xff;
			hmiEncoderTimeout = millis();
			break;
		case 3: //Home.bStop pressed, kill current tx buffer		
			hmi_bTx = char(0xff);
			ChkTxBuffer();
			break;
		case 4:
			//future
			break;
		case 5: //bSave pressed on TxMem page						
			UpdateTxMemSave();
			break;
		case 6: //radio type down btn
			gRadio--;
			if (gRadio > RADIO_TYPE_NUMRADIOS)
			{
				gRadio = RADIO_TYPE_NUMRADIOS - 1;
			}
			SetRadioBaud();			
			break;
		case 7: //radio type up btn
			gRadio++;
			if (gRadio >= RADIO_TYPE_NUMRADIOS)
			{
				gRadio = 0;
			}
			SetRadioBaud();			
			break;
		case 8: //Band.bBaud pressed or encoder turned up, inc baud
			ChangeBaudRate(1);
			break;
		case 9: //encoder turned down, dec
			ChangeBaudRate(-1);
			break;
		case 10: //fft pressed, update gFreq from hmi			
			UpdateHMIEveryPoll(); //get updated gFreqRadio and update radio
			//SerialOut("hmi freq changed radio freq", true);
			break;
		case 11: //bPrev button pressed, pop prev freq & modes off the stack
			//if we have valid prev data, go back to last freq and move the arrays up one
			//SerialOut("bPrev pressed", true);
			if (prevFreq[0] >= 100000)
			{
				gFreqRadio = prevFreq[0];
				ChkFreqChange();
				gRMode = prevRMode[0];
				gOMode = prevOMode[0];
				lastStableFreq = gFreqRadio;
				lastStableRMode = gRMode;
				lastStableOMode = gOMode;
				//move everything up one
				for (int i = 0; i < 9; i++)
				{
					prevFreq[i] = prevFreq[i + 1];
					prevRMode[i] = prevRMode[i + 1];
					prevOMode[i] = prevOMode[i + 1];
				}
				/* debugg
				for (int i = 0; i < 10; i++)
				{
					SerialOut(String(i) + "= " + String(prevFreq[i]), true);
				}
				*/
			}
			break;
		case 12: //clear Rx buffers		
			blockISR = true; //so these don't get overwritten in ISR
			hmi_bRx = "Rx:";
			hmi_rxM_ptr = 0; //reset array
			for (int i = 0; i < 11; i++)
			{
				hmi_rxM[i] = "";
			}
			SerialOut("Deleted Rx Buffer", true);
			blockISR = false;
			break;
		case 20: //scroll log up
			hmiLogOffset+=11;
			if (hmiLogOffset > gLogNumEntries)
			{
				hmiLogOffset = gLogNumEntries;
				//hmiLogOffset = 1; //go back to bottom
			}			
			Tx2HMI("Log.h1.val=" + String(hmiLogOffset));
			Tx2HMI("Log.h1.val=" + String(hmiLogOffset));			
			SerialOut("h1 offset= " + String(hmiLogOffset), true);
			break;
		case 21: //scroll log down
			hmiLogOffset -= 11;
			if (hmiLogOffset < 1)
			{
				hmiLogOffset = 0;
				//hmiLogOffset = gLogNumEntries; //go back to top
			}			
			Tx2HMI("Log.h1.val=" + String(hmiLogOffset));
			Tx2HMI("Log.h1.val=" + String(hmiLogOffset));
			SerialOut("h1 offset= " + String(hmiLogOffset), true);
			break;
		case 30: //save log entry
			SaveLogEntryFromHMI();
			break;	
		case 35: //save FreqMem
			SaveEditPgFromHMI(); //save editPgTxt[] values
			break;
		case 40: //cw keyer mode down		
			cKeyrMod--; //goes to 255 if dec from 0
			if (cKeyrMod > KEYER_MODE_MAX)
			{
				cKeyrMod = KEYER_MODE_MAX - 1; //roll over
			}
			break;
		case 41: //cw keyer mode up
			cKeyrMod++;
			if (cKeyrMod >= KEYER_MODE_MAX)
			{
				cKeyrMod = 0; //roll over
			}
			break;
		case 50: //rtty baud down
			gRtyBaud--;
			if (gRtyBaud > RTTY_BAUD_MAX)
			{
				gRtyBaud = RTTY_BAUD_MAX - 1;
			}
			break;
		case 51: //rtty baud up
			gRtyBaud++;
			if (gRtyBaud >= RTTY_BAUD_MAX)
			{
				gRtyBaud = RTTY_BAUD_45;
			}
			break;
		case 52: //rtty freq down
			gRtyFrq--;
			if (gRtyFrq > RTTY_FREQ_MAX)
			{
				gRtyFrq = RTTY_FREQ_MAX - 1;
			}
			break;
		case 53: //rtty freq up
			gRtyFrq++;
			if (gRtyFrq >= RTTY_FREQ_MAX)
			{
				gRtyFrq = RTTY_FREQ_2125;
			}
			break;
		case 54: //rtty shift down
			gRtySft--;
			if (gRtySft > RTTY_SHIFT_MAX)
			{
				gRtySft = RTTY_SHIFT_MAX - 1;
			}
			break;
		case 55: //rtty shift up
			gRtySft++;
			if (gRtySft >= RTTY_SHIFT_MAX)
			{
				gRtySft = RTTY_SHIFT_170;
			}
			break;
		case 56: //rtty stop down
			gRtyStp--;
			if (gRtyStp > RTTY_STOP_MAX)
			{
				gRtyStp = RTTY_STOP_MAX - 1;
			}

			break;
		case 57: //rtty stop up
			gRtyStp++;
			if (gRtyStp >= RTTY_STOP_MAX)
			{
				gRtyStp = RTTY_STOP_1;
			}
			break;
		}
	}
	else if (gAction == 100)
	{
		//send previously downloaded tData.txt from Input page
		hmi_bTx = hmi_tData;
		SerialOut("hmi_bTx= " + hmi_tData, true);
		SetTxMemState(true);
	}
	else if (gAction > 100 && gAction <= 110)
	{
		//not voice buffer, subtract gAction offset and inc to gOMode range in tx gBuffx
		hmi_bTx = hmiTxMem[(gAction - 101) + (gOMode * 10)];
		SetTxMemState(true); //start keyer
	}
	else if (gAction > 110 && gAction <= 120)
	{
		//audio recording seletect for play back
		gAudioVMsg = gAction - 110;
		if (gAudioRecSrc == AUDIO_SRC_LINEIN)
		{
			gAudioVMsg += 10; //offset by 10 for Rx>SD audio
		}
		String temp = "";
		if (gShareDB == false)
		{
			temp = String((gRadioSel + 1), HEX) + "-"; //add selected radio to file name
		}
		SD_StartPlaying("/TXMEM/VMSG" + temp + String(gAudioVMsg) + ".wav"); //send file name to SD_StartPlaying
	}
	else if (gAction >= 150 && gAction < 170)
	{
		//flex actions		
		if (gWiFi == 1)
		{
			switch (gAction)
			{
			case 150: //first connect to radio
				if (!gFlexCon)
				{
					//we're on Flex page, return home and update bRx				
					Tx2HMI("page Home");
					Tx2HMI("page Home");
					Tx2HMI("Home.bRx.txt=`Connecting to Flex via WiFi  `");
					Tx2HMI("Home.bRx.txt=`Connecting to Flex via WiFi  `");
					gFlexCon = true;
					//chk list to see if select slice is active, if no, create it					
					Flex_Initialize();
					if (gFlexCon)
					{
						Flex_TxFreq(gFreqRadio);
						Flex_TxMode();
						Tx2HMI("gFlexCon=1");
						Tx2HMI("gFlexCon=1");
					}
					Tx2HMI("Home.bRx.txt=`Rx:`");
					Tx2HMI("Home.bRx.txt=`Rx:`");
				}
				break;
			case 151:
				//close slice a
				Tx2HMI("page Home");
				Tx2HMI("page Home");
				Tx2HMI("Home.bRx.txt=`Closing Flex Slice A  `");
				Tx2HMI("Home.bRx.txt=`Closing Flex Slice A  `");
				gWiFi = 1; //temporarily enable so the next command goes out				
				reply = Tx2ESP(ESP_FLEX, "|slice r 0");
				gWiFi = 0;
				gFlexCon = false;
				Tx2HMI("gFlexCon=0");
				Tx2HMI("gFlexCon=0");
				flexAPI.stop();
				Tx2HMI("gWiFi=0");
				Tx2HMI("gWiFi=0");
				SetESPState(0); //disconnect wifi
				delay(2000);
				Tx2HMI("Home.bRx.txt=``");
				Tx2HMI("Home.bRx.txt=``");
				break;
			case 152:
				//disconnect from slice a but leave it running
				Tx2HMI("page Home");
				Tx2HMI("page Home");
				Tx2HMI("Home.bRx.txt=`Disconnecting WiFi  `");
				Tx2HMI("Home.bRx.txt=`Disconnecting WiFi  `");
				gFlexCon = false;
				Tx2HMI("gFlexCon=0");
				Tx2HMI("gFlexCon=0");
				flexAPI.stop();
				gWiFi = 0;
				Tx2HMI("gWiFi=0");
				Tx2HMI("gWiFi=0");
				SetESPState(0); //disconnect wifi				
				delay(2000);
				Tx2HMI("Home.bRx.txt=``");
				Tx2HMI("Home.bRx.txt=``");
				break;
			case 155:
				//start tune				
				reply = Tx2ESP(ESP_FLEX, "|atu start");
				break;
			case 156:
				//bypass atu				
				reply = Tx2ESP(ESP_FLEX, "|atu bypass");
				break;
			case 160:
				//enable WNB	
				gFlexWNBPrev = gFlexWNB;
				reply = Tx2ESP(ESP_FLEX, "|slice s 0 wnb=1 wnb_level=" + String(gFlexWNB & 0x7f));
				break;
			case 161:
				//disable WNB
				reply = Tx2ESP(ESP_FLEX, "|slice s 0 wnb=0");
				gFlexWNB &= 0x7f; //clear enable flag
				gFlexWNBPrev = gFlexWNB;
				hmiWait4Reply = 0;
				Tx2HMI("Flex.gFlexWNB.val=" + String(gFlexWNB));
				Tx2HMI("Flex.gFlexWNB.val=" + String(gFlexWNB));
				break;
			case 162:
				//enable NB
				gFlexNBPrev = gFlexNB;
				reply = Tx2ESP(ESP_FLEX, "|slice s 0 nb=1 nb_level=" + String(gFlexNB & 0x7f));
				break;
			case 163:
				//disable NB
				reply = Tx2ESP(ESP_FLEX, "|slice s 0 nb=0");
				gFlexNB &= 0x7f; //clear enable flag
				gFlexNBPrev = gFlexNB;
				hmiWait4Reply = 0;
				Tx2HMI("Flex.gFlexNB.val=" + String(gFlexNB));
				Tx2HMI("Flex.gFlexNB.val=" + String(gFlexNB));
				break;
			case 164:
				//enable NR
				gFlexNRPrev = gFlexNR;
				reply = Tx2ESP(ESP_FLEX, "|slice s 0 nr=1 nr_level=" + String(gFlexNR & 0x7f));
				break;
			case 165:
				//disable NR
				reply = Tx2ESP(ESP_FLEX, "|slice s 0 nr=0");
				gFlexNR &= 0x7f; //clear enable flag
				gFlexNRPrev = gFlexNR;
				hmiWait4Reply = 0;
				Tx2HMI("Flex.gFlexNR.val=" + String(gFlexNR));
				Tx2HMI("Flex.gFlexNR.val=" + String(gFlexNR));
				break;
			case 166:
				//enable auto-peaking/notch filter
				gFlexAFPrev = gFlexAF;
				if (gRMode < 2)
				{
					//peaking on CW
					reply = Tx2ESP(ESP_FLEX, "|slice s 0 apf=1 apf_level=" + String(gFlexAF & 0x7f));
				}
				else
				{
					//notch on other modes
					reply = Tx2ESP(ESP_FLEX, "|slice s 0 anf=1 anf_level=" + String(gFlexAF & 0x7f));
				}
				break;
			case 167:
				//disable auto-peaking filter
				if (gRMode < 2)
				{
					//peaking for CW
					reply = Tx2ESP(ESP_FLEX, "|slice s 0 apf=0");
				}
				else
				{
					//notch for all others
					reply = Tx2ESP(ESP_FLEX, "|slice s 0 anf=0");
				}
				gFlexAF &= 0x7f; //clear enable flag
				gFlexAFPrev = gFlexAF;
				hmiWait4Reply = 0;
				Tx2HMI("Flex.gFlexAF.val=" + String(gFlexAF));
				Tx2HMI("Flex.gFlexAF.val=" + String(gFlexAF));
				break;
			}
		}
	}
	gAction = 0; //reset for next time
	gActionPrev = 0;
	Tx2HMI("gAction=0");
	Tx2HMI("gAction=0");
	Tx2HMI("gAction=0");
	ChkEncoderChng(); //treat it like an encoder change
}



void KeyboardPress_ISR(int key)
{
	//process normal USB keyboard input
	//this is an ISR so don't send data to display	
	//noInterrupts();
	keyboardChr = key; //this will be picked up in ChkChr2HMI routine
	//interrupts();
	//enable this to capture key codes from keyboard
	//Serial.print(String(key) + " ");

}

void SetRMode()
{
	//if gRMode != gRModePrev mode changed on radio, update hmi
	TxMode2Radio();
	hmiWait4Reply = 0;
	Tx2HMI("gRMode=" + String(gRMode));
	Tx2HMI("gRMode=" + String(gRMode));
	hmiAnnounce |= VOICE_SAY_gRMode;
	gRModePrev = gRMode;
	//SerialOut("Mode on HMI updated, gRMode=" + String(gRMode) + ", gRModePrev=" + String(gRModePrev)), true);	
}

void SetOMode()
{
	//called if gOMode != gOModePrev

	//SerialOut("===> gOMode=" + String(gOMode) + ", gOModePrev=" + String(gOModePrev), true);
	//mode changed, set audio path, tone freq & filters
	if (gTxModeSet2 > RADIO_TX_OFF && gRMode == MODE_VOICE)
	{
		gTxModeSet2 = RADIO_TX_OFF; //set to PTT if in voice mode
	}
	digitalWrite(PTT_OUT, HIGH);
	SetTxPath();
	SetOutputSource(0, true);//set output to rx path
	SetFilterFreq(7);
	UpdateTxMem(gOMode);
	hmiWait4Reply = 0;
	Tx2HMI("gOMode=" + String(gOMode));
	Tx2HMI("gOMode=" + String(gOMode));
	hmiAnnounce |= VOICE_SAY_gOMode;
	gOModePrev = gOMode;
}

void SetTxMemState(bool play)
{
	static bool alreadyHr = false;

	if (alreadyHr)
	{
		return;
	}
	alreadyHr = true;

	if (play)
	{
		//actual keying is done in ChkPaddles() - it extracts chrs from hmi_bTx

		//if we're not txing, start sending bTx
		gPlay = true; //play btn pressed on tx buffer		
		if (gPlayPrev == false)
		{
			SerialOut("========================>> gPlay= " + String(gPlay), true);
			if (gOMode == MODE_CW)
			{				
				
				if (hmi_bTx.charAt(0) == '*')
				{
					//we are paused by the buffer, remove pause so we can continue
					hmi_bTx.remove(0, 1);
				}				
			}
			else if (gOMode == MODE_RTTY)
			{
				//set up RTTY modulator and key ptt
				SerialOut(" =======================>> turning on RTTY cxr", true);
				SetOutputSource(1, true); //turn on output path	
				RTTY.frequency(rttyFreq[gRtyFrq]);				
				RTTY_KEY.amplitude(0.0); //start at mark, set to rttyFreqShift[gRtySft] to key space
				float lev = float(gTxLev * .7) / 100; //anything over gain of .7 causes distortion			
				RTTY.amplitude(lev); //turn on osc															
				if (gTxMode != RADIO_TX_OFF)
				{
					gTxModeSet2 = RADIO_TX_PADDLE;
					digitalWrite(PTT_OUT, LOW);
					//SerialOut("RTTY keying radio", true);
					pttWatchDog = millis(); //start watchdog
				}
				delay(15); //pre tx mark
			}
			ChkTxBuffer();
		}		
	}
	else
	{
		//it's off or paused
		gPlay = false;
		if (gOMode == MODE_RTTY && gPlayPrev == true)
		{
			//drop out ptt and turn off RTTY modulator
			SerialOut(" =======================>> turning off RTTY cxr", true);			
			RTTY.amplitude(0.0);
			RTTY_KEY.amplitude(0.0); //mark
			delay(20); //wait 20 mSec to drop chr			
			SetOutputSource(0, true); //turn on rx	
			//sgtl5000_1.muteLineout();										
			if (gTxMode != RADIO_TX_OFF)
			{
				gTxModeSet2 = RADIO_TX_ENAB;
				digitalWrite(PTT_OUT, HIGH);
			}
		}
		gPlayPrev = false;
	}
	gPlayPrev = gPlay;
	alreadyHr = false;
}

void ChkMouse()
{
	/*
	if mouse active, perform the following actions:
	No buttons - do nothing
	Left button 0x01 - hold to drag freq
	Right button 0x02 - inc gEncoder
	Both buttons or Center button 0x04 - reset gEncoder
	Side option button 0x08 - dec gUnit
	Side option button 0x10 - inc gUnit

	*/

	static uint32_t mouseDebounce = millis();

	if (mouse.available())
	{
		if (millis() - mouseDebounce > 100)
		{
			uint8_t val = gEncoder;
			int btns = mouse.getButtons();
			SerialOut("mouse btns= " + String(btns, HEX), true);
			if ((btns & 0x01 && btns & 0x02) || btns & 0x04)
			{
				//reset gEncoder if both l&r or roller button pressed
				gEncoder = 0;
				gEncoderPrev = 0xff; //force update
			}
			else if (btns & 0x01) //hold left button and drag x and/or y to change freq if we're not locked or transmitting
			{
				//left or down = dec freq, right or up = inc freq
				int curDir = ((mouse.getMouseX() - mouse.getMouseY()) / 5); //desense mouse				
				SetEncoderCtrl(curDir);
			}
			else if (btns & 0x02)
			{
				val++;
				SetEncoder(val); //right button encoder up
			}
			else if (btns & 0x08)
			{
				//dec selected freq unit
				if (gUnit > 1)
				{
					gUnit /= 10;
				}
				else
				{
					gUnit = 100000000; //roll to max
				}
				gEncoder = 0; //reset if active
				gEncoderPrev = 0xff;
			}
			else if (btns & 0x10)
			{
				//inc selected freq unit
				gUnit *= 10;
				if (gUnit > 100000000)
				{
					gUnit = 1; //roll to min
				}
				gEncoder = 0; //reset if active
				gEncoderPrev = 0;
			}

			//if no btns, check wheel and adjust encoder
			if (btns == 0)
			{
				int curDir = mouse.getWheel();
				if (curDir != 0)
				{
					//adjust selected gEncoder value
					SetEncoderCtrl(curDir);
				}
			}

		}

		//other mouse inputs

		//int i = mouse.getMouseY();
		//SerialOut("mouse y = " + String(i), true);
		//i = mouse.getWheelH();
		//SerialOut("mouse wheelH = " + String(i), true);


		mouse.mouseDataClear();
		mouseDebounce = millis();
	}

}

void ChkEncoder()
{
	//called every 1 mS from ISR -
	// DON'T CALL ANY ROUTINES THAT WRITE TO COMM PORTS OR USE DELAY() FUNCTIONS - causes uProc to lock up

	//NOTE: Don't debounce these inputs - we're looking for the edge to fall on a or b to determine direction

	//roll polarities for easier code reading

	bool a = !digitalRead(ROTARY_A);
	bool b = !digitalRead(ROTARY_B);
	bool sw = !digitalRead(ROTARY_SW); // !=0 when encoder pressed

	static int curDir = 0; //indicates which way to move - a=low first, dec, b=low first, inc	
	static bool alreadyHr = false;

	static bool lastA = a; //track a input change
	static bool lastB = b; //track b input change
	static bool lastSw = sw; //track switch change
	static uint32_t rotaryTimer = 0; //rotary change timer
	static uint32_t swTimer = 0; //detects switch down time

	if (alreadyHr == true)
	{
		//nothing to do
		return;
	}

	alreadyHr = true;

	//detect switch press & release
	if (sw == true && lastSw == false)
	{
		swTimer = millis(); //switch just pressed, start switch down timer and wait for swTimer to time out
	}
	else if (sw == false && lastSw == true && swTimer > 0)
	{
		//switch just released, inc gEncoder if a & b not changed
		uint32_t tmr = millis() - swTimer;
		//if we've waited 50 mS inc gEncoder and reset, else wait
		if (tmr > 50)
		{
			uint8_t val = gEncoder;
			val++;
			SetEncoder(val);
			hmiEncoderTimeout = millis(); //restart timeout	
			swTimer = 0; //reset time so we can start again
			curDir = 0;
			rotaryTimer = 0;
			if (gEncoder == 1 && hmiPage == HMI_HOME && gVocal == true)
			{
				gEncoder = 0; //reset it if using gVocal
				hmiAnnounce = VOICE_SAY_Freq + VOICE_SAY_gRMode + VOICE_SAY_gOMode; //say freq & modes
			}
		}
	}

	//detect encoder COS on trailing edge
	//if both inputs are false and the rotaryTimer hasn't started, check for trailing edge to trigger
	if (!(a + b + rotaryTimer))
	{
		if (lastA == true && lastB == false)
		{
			curDir = 1;
			swTimer = 0;
			rotaryTimer = millis(); //start rotary timer
		}
		else if (lastA == false && lastB == true)
		{
			curDir = -1;
			swTimer = 0;
			rotaryTimer = millis();
		}
	}

	//execute rotary change if rotary timer times out	
	if (curDir != 0 && rotaryTimer != 0)
	{
		uint32_t tmr = millis() - rotaryTimer;
		//wait 50 mS to process change then reset
		if (tmr > 50)
		{
			if (sw == 0)
			{
				//sw not pressed, process knob turn				
				SetEncoderCtrl(curDir);
			}
			else
			{
				gEncoder = 0; //reset encoder if turning with sw pressed				
				gEncoderPrev = 0xff; //force update to be sent to HMI
				if (hmiPage == HMI_HOME)
				{
					//change step if switch pressed	and encoder turned								
					if (curDir == -1)
					{
						gUnit *= 10;
						if (gUnit > 100000000)
						{
							gUnit = 1;
						}
					}
					else if (curDir == 1)
					{
						gUnit /= 10;
						if (gUnit < 1)
						{
							gUnit = 100000000;
						}
					}
					hmiUpdateCtr = 0; //immediate display update					
				}
			}
			curDir = 0;
			rotaryTimer = 0;
			swTimer = 0;
		}
	}
	lastA = a;
	lastB = b;
	lastSw = sw;
	alreadyHr = false;

}


void SetEncoder(uint8_t val)
{
	//adjust new value for gEncoder is within bounds for the selected page 
	//SerialOut("Encode Pressed - val=" + String(val) + ", gEncoder=" + String(gEncoder), true);
	switch (hmiPage)
	{
	case HMI_HOME:
		if (val == 255)
		{
			//this negative for a uint8_t number
			val = HMI_HOME_PG_MAX_CTRL - 1;
		}
		else if (val >= HMI_HOME_PG_MAX_CTRL)
		{
			val = 0;
		}

		switch (gOMode)
		{
		case MODE_VOICE:
			if (val == 2)
			{
				val = 3; //skip fft freq
			}
			break;
		case MODE_RTTY:
			if (val == 2)
			{
				val = 3; //skip fft freq
			}
			break;
		case MODE_DIG:
			if (val == 2)
			{
				val = 3; //skip fft freq
			}
			break;
		}
		break;
	case HMI_BAND:
		if (val == 255)
		{
			val = HMI_BAND_PG_MAX_CTRL - 1;
		}
		else if (val >= HMI_BAND_PG_MAX_CTRL)
		{
			val = 0;
		}
	case HMI_CW:
		if (val == 255)
		{
			val = HMI_CW_PG_MAX_CTRL - 1;
		}
		else if (val >= HMI_CW_PG_MAX_CTRL)
		{
			val = 0;
		}
		break;
	case HMI_VOICE:
		if (val == 255)
		{
			val = HMI_VOICE_PG_MAX_CTRL - 1;
		}
		else if (val >= HMI_VOICE_PG_MAX_CTRL)
		{
			val = 0;
		}
		if ((gEQSel == false && gRxEQ == false) || (gEQSel == true && gTxEQ == false))
		{
			if (val > 0 && val < 6)
			{
				//skip equalizer if selected eq is off
				val = 6;
			}
		}
		break;
	case HMI_RTTY:
		if (val == 255)
		{
			val = HMI_RTTY_PG_MAX_CTRL - 1;
		}
		else if (val >= HMI_RTTY_PG_MAX_CTRL)
		{
			val = 0;
		}
		break;
	case HMI_DIG:
		if (val == 255)
		{
			val = HMI_DIG_PG_MAX_CTRL - 1;
		}
		else if (val >= HMI_DIG_PG_MAX_CTRL)
		{
			val = 0;
		}
		break;
	/*
	//These pages are forced to gEncoder=1 for auto scroll selection
	//This code if for future if we ever add addition controls for the encoder
	case HMI_FREQMEM:
		if (val == 255)
		{
			val = HMI_FMEM_PG_MAX_CTRL - 1;
		}
		else if (val >= HMI_FMEM_PG_MAX_CTRL)
		{
			val = 0;
		}
		break;
	case HMI_LOG:
		if (val == 255)
		{
			val = HMI_LOG_PG_MAX_CTRL - 1;
		}
		else if (val >= HMI_LOG_PG_MAX_CTRL)
		{
			val = 0;
		}
		break;
	*/
	case HMI_HELP:
		//exit if gEncoder >0
		val = 1;
		hmiHelpPageDir = 1; //this is so UpdateHMIDisplay can find this
		break;
	case HMI_PCR:
		if (val == 255)
		{
			val = HMI_PCR_PG_MAX_CTRL - 1;
		}
		else if (val >= HMI_PCR_PG_MAX_CTRL)
		{
			val = 0;
		}
		if (gPCRDSP == false && val == 5)
		{
			val = 0; //skip DSPNR if not turned on
		}
		break;
	case HMI_FLEX:
		if (val == 255)
		{
			val = HMI_FLEX_PG_MAX_CTRL - 1;
		}
		else if (val >= HMI_FLEX_PG_MAX_CTRL)
		{
			val = 0;
		}
		//skip unused filters
		if ((gRMode == 4 || gRMode == 5) && val > 3)
		{
			val = 0; //dsp filters not used in fm modes
		}
		else if (gRMode > 6 && val > 5)
		{
			val = 0; //nr and auto filters not used in dig modes
		}
		break;
	case HMI_LEVELS:
		if (val == 255)
		{
			val = HMI_LEVELS_PG_MAX_CTRL - 1;
		}
		else if (val >= HMI_LEVELS_PG_MAX_CTRL)
		{
			val = 0;
		}

		break;
	default:
		val = 0;
		break;
	}

	gEncoder = val;
}



void ChkTxBuffer()
{
	//chk to see if we're txing chrs from Home.bTx.txt	
	if (!playSdWav.isPlaying() && gAudioMode == AUDIO_PLAYBACK)
	{
		//playback is done, turn off buffer				
		SD_StopPlaying();
	}
	if (hmi_bTx == char(0xff))
	{
		hmiWait4Reply = 0;
		Tx2HMI("Home.btPlay.val=0");//reset play btn
		Tx2HMI("Home.btPlay.val=0");
		Tx2HMI("Home.bTx.txt=`Tx:`");
		Tx2HMI("Home.bTx.txt=`Tx:`");
		Tx2HMI("Home.oldOMode.val=255"); //refresh buffer buttons if in CW or RTTY mode
		Tx2HMI("Home.oldOMode.val=255");
		hmi_bTx = "Tx:"; //idle flag		
		SetTxMemState(false); //turn cxr off
	}
	if (gPlay == true)
	{
		//send modified bTx.txt back to display
		hmiWait4Reply = 0;
		//chk for pause chr 
		if (hmi_bTx.charAt(0) == '*')
		{
			Tx2HMI("Home.btPlay.val=0");//reset play btn
			Tx2HMI("Home.btPlay.val=0");
			//pressing play button will pop it off so we can continue
			//hmi_bTx.remove(0, 1);//pop it off string
			//Tx2HMI("Home.bTx.txt=`" + hmi_bTx + "`");
		}
		if (hmi_bTx.length() > 0)
		{
			Tx2HMI("Home.btPlay.val=1");
			Tx2HMI("Home.bTx.txt=`" + hmi_bTx + "`");
		}
		else
		{
			hmi_bTx = char(0xff); //turn off on next call
		}		
	}
	else
	{
		if (hmi_bTx != "Tx:" && hmiPage == HMI_HOME)
		{
			Tx2HMI("Home.bTx.txt=`" + hmi_bTx + "`");
		}
	}
}


void ChkPCCmd()
{
	/*
	PC command uses Serial conole to Rx and Tx messages to a PC onnected to the Teensy  micro-USB port
	* Make sure Serial.print calls are minimized to reduce bad replies
	* Any baud can be set on the host program,
	* This enulates the Kenwood TS-2000 xcvr because it will reply with ID019; to ID; requests
	* gComMode determines what external app is connected
	  - once it's triggered it can only toggle between CAT and TERM mode, debug data (SerialOut()) is turned off until a power cylce
	*/

	static uint8_t pcCmdRxCtr = 0; //counts # of rx bytes - must see cmd start with F or M and end with ;
	uint8_t rxByte = 0;


ChkAgn:
	if (!Serial.available())
	{
		return;
	}

	//data is available on Serial 
	// chkk to see if it's a valid CAT request from a PC program
	rxByte = Serial.read();
	if (rxByte == 10)
	{
		//ignore lf
		goto ChkAgn;
	}
	if (rxByte >= 0x61 && rxByte <= 0x7a)
	{
		//alphanumeric chrs		
		rxByte &= 0xDF; //it's lower case, convert to upper case		
	}

	//echo
	TermOut(String(char(rxByte)), false);

	//enable this to capture chr codes from terminal
	//Serial.print(" "+String(rxByte)+" "); //prints value of chr rx

	if (rxByte == 13)
	{
		//if double cr, start terminal mode
		if (pcCmdRxCtr == 1 && pcCmdRx[0] == 13)
		{
			if (gComMode != COM_MODE_TERM)
			{
				Tx2HMI("Home.bRx.txt=`Entering Terminal Mode, diagnostics off`");
				Tx2HMI("Home.bRx.txt=`Entering Terminal Mode, diagnistucs off`");
			}
			gComMode = COM_MODE_TERM;
			pcCmdRxCtr = 0;
			SendTermMenu(); //send start menu on double cr
			return;
		}
		else if (gComMode == COM_MODE_TERM && pcCmdRxCtr > 0 && hmiPage == HMI_HOME)
		{
			//end of terminal string - send string to bTx.txt to tx it
			SendTxBuffer(pcCmdRxCtr);
			return;
		}
		else if (hmiPage != HMI_HOME)
		{
			//send enter to page
			keyboardChr = 13;
			ChkChr2HMI();
		}
		else if (!pcCmdRxCtr)
		{
			//capture up to two cr to turn on terminal mode
			pcCmdRx[pcCmdRxCtr] = rxByte;
			pcCmdRxCtr++;
			goto ChkAgn;
		}
		pcCmdRxCtr = 0; //reset ctr
		goto ChkAgn; //otherwise ignore

	}
	if (gComMode == COM_MODE_TERM)
	{
		if (rxByte == 27)
		{
			//reset ctr if esc - this means function key follows
			pcCmdRxCtr = 0;
		}
		delay(1); //wait for other chrs of esc sequence
		//accumulate string to tx
		pcCmdRx[pcCmdRxCtr] = rxByte;
		//debug: use to display keycodes
		//Serial.println("keycode= " + String(rxByte) + " ");
		pcCmdRxCtr++;
		//look for esc key, ctrl+1 to 0, or function key preamble 27 91 
		//NOTE: Terminal must be set to Dec 100 emulateion to get Alt+F key codes
		if (pcCmdRx[0] == 27)
		{
			if (((pcCmdRxCtr == 1 || pcCmdRxCtr == 2) && !Serial.available()) || (pcCmdRx[1] == 91 && pcCmdRxCtr > 2))
			{
				ProcessTerminalCmd(pcCmdRxCtr); //process function keys
			}
		}
		else if (!Serial.available())
		{
			//single chr, just send it to keyboard processor			
			keyboardChr = rxByte;
			ChkChr2HMI();
		}
		goto ChkAgn;
	}

	//if we get to here, chk for cat commands
	if (pcCmdRxCtr == 0)
	{
		if (rxByte != 'F' && rxByte != 'M' && rxByte != 'R' && rxByte != 'T' && rxByte != 'I')
		{
			goto ChkAgn;
		}
	}

	pcCmdRx[pcCmdRxCtr] = rxByte;
	pcCmdRxCtr++;
	if (pcCmdRxCtr > pcCmdRxLen)
	{
		pcCmdRxCtr = 0; //start over if cmd is too long
		goto ChkAgn;
	}
	if (rxByte == ';')
	{
		//code to display incoming traffic in bRx.txt since we can't use serial monitor

		String temp = "";
		for (int i = 0; i < pcCmdRxCtr; i++)
		{
			temp += char(pcCmdRx[i]);
		}
		//Tx2HMI("Home.bRx.txt=`" + temp + "`");		

		//we have received a full command - process it
		pcCmdRx[0] &= 0xDF; //convert to upper case
		pcCmdRx[1] &= 0xDF;
		char sFrq[12] = { '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 0x00 }; //put frq digits here

		if (pcCmdRx[0] == 'F')
		{
			if (pcCmdRx[1] == 'A' || pcCmdRx[1] == 'B' || pcCmdRx[1] == 'C')
			{
				//vfo A or b, or subVFO freq query or set
				if (pcCmdRxCtr == 3)
				{
#ifdef enabSerialOut
					if (gComMode != COM_MODE_CAT)
					{
						hmiWait4Reply = 0;
						Tx2HMI("Home.bRx.txt=`CAT Mode started, diagnostics off`"); //notify user 
						Tx2HMI("Home.bRx.txt=`CAT Mode started, diagnostics off`"); //notify user 
						gComMode = COM_MODE_CAT; //block diagnostic reports on Serial() - they interfer with external apps trying to talk to this device
					}
#endif // enabSerialOut
					//return gFreq
				RtnFrq:				CalcKenwoodFreq(sFrq);
					//SerialOut("F" + String(char(pcCmdRx[1])) + String(sFrq) + ";", true);
					char buf[15] = { 'F', pcCmdRx[1], '0', '0', '0', '0',  '0',  '0',  '0',  '0',  '0',  '0',  '0', ';',  0 };
					for (int i = 0; i < 11; i++)
					{
						buf[i + 2] = sFrq[i];
					}
					Serial.write(buf, 14); //reply to selected cmd	
					Serial.flush();
					//Tx2HMI("Home.bRx.txt=`" + String(buf) + "`");
				}
				else if (pcCmdRxCtr == 14)
				{
					//set gFreq
					gFreqRadio = ((pcCmdRx[4] & 0x0f) * 100000000) + ((pcCmdRx[5] & 0x0f) * 10000000) + ((pcCmdRx[6] & 0x0f) * 1000000) + ((pcCmdRx[7] & 0x0f) * 100000) + ((pcCmdRx[8] & 0x0f) * 10000)
						+ ((pcCmdRx[9] & 0x0f) * 1000) + ((pcCmdRx[10] & 0x0f) * 100) + ((pcCmdRx[11] & 0x0f) * 10) + (pcCmdRx[12] & 0x0f);
					Tx2HMI("gFreq=" + String(gFreqRadio)); //update HMI freq - this will cascade to radio if one is connected
					Tx2HMI("gFreq=" + String(gFreqRadio));
					goto RtnFrq;
				}
			}
		}
		else if (pcCmdRx[0] == 'M' && pcCmdRx[1] == 'D')
		{
			//mode query or set
			if (pcCmdRxCtr == 3)
			{
				//calc mode digit and return mode
				char mdDigit = 0;
				switch (gRMode)
				{
				case 0: //cw
					mdDigit = '3';
					break;
				case 1: //cwr
					mdDigit = '7';
					break;
				case 2: //lsb
					mdDigit = '1';
					break;
				case 3: //usb
					mdDigit = '2';
					break;
				case 4: //fmn
					mdDigit = '4';
					break;
				case 5: //fmw - force to fmn
					mdDigit = '4';
					break;
				case 6: //am
					mdDigit = '5';
					break;
				case 7: //digL - force to fsk reverse
					mdDigit = '6';
					break;
				case 8: //digH - force to fsk
					mdDigit = '9';
					break;
				}
				char buf[5] = { 'M', 'D', mdDigit, ';', 0 };
				Serial.write(buf, 4); //reply to selected cmd					
				Serial.flush();
				//Tx2HMI("Home.bRx.txt=`Rx: " + String(buf) + "`");
			}
			else if (pcCmdRxCtr == 4)
			{
				//translate kenwood mode to CTR2 mode and set gRMode
				int mdDigit = pcCmdRx[2] - 0x30; //convert ascii to number
				switch (mdDigit)
				{
				case 3:
					gRMode = RADIO_CW; 
					break;
				case 7:
					gRMode = RADIO_CW_R;
					break;
				case 1:
					gRMode = RADIO_LSB; 
					break;
				case 2:
					gRMode = RADIO_USB;
					break;
				case 4:
					gRMode = RADIO_FM_N;
					break;
				case 5:
					gRMode = RADIO_AM;
					break;
				case 6:
					gRMode = RADIO_DIG_L; //NOTE: if radio doesn't support these digL and digR modes, it will revert to previous mode
					break;
				case 9:
					gRMode = RADIO_DIG_H; 
					break;
				}
				char buf[5] = { 'M', 'D', char(mdDigit + 0x30), ';', 0 }; //just reply what we were told, MD; will get actual radio mode
				Serial.write(buf, 4); //reply to selected cmd					
				Serial.flush();
				TxMode2Radio(); //send mode change to radio immediately so radio mode doesn't revert hmi back to previous mode
				//Tx2HMI("Home.bRx.txt=`Tx: " + String(buf) + "`");
			}
		}
		else if (pcCmdRx[0] == 'R' && pcCmdRx[1] == 'X')
		{
			//set rx mode
			gTxModeSet2 = RADIO_TX_ENAB;
			digitalWrite(PTT_OUT, HIGH); //release PTT			
			char buf[4] = { 'R', 'X', '0', ';' };
			Serial.write(buf, 4); //reply to selected cmd					
			Serial.flush();
		}
		else if (pcCmdRx[0] == 'T' && pcCmdRx[1] == 'X' && pcCmdRxCtr == 4)
		{
			//set ptt if tx enabled
			if (gTxMode != RADIO_TX_OFF)
			{
				gTxModeSet2 = RADIO_TX_BTN; //simulate btTxMode press
				digitalWrite(PTT_OUT, LOW);
				SerialOut("======> PC keying radio", true);
				pttWatchDog = millis(); //start watchdog
				char buf[4] = { 'T', 'X', pcCmdRx[2], ';' };
				Serial.write(buf, 4); //reply to selected cmd					
				Serial.flush();
			}
			else
			{
				//SerialOut("Tx mode disabled", true);
			}
		}
		else if (pcCmdRx[0] == 'I' && pcCmdRx[1] == 'D' && pcCmdRxCtr == 3)
		{
			//reply with TS2000 ID#
			char buf[6] = { 'I', 'D', '0', '1', '9', ';' };
			Serial.write(buf, 6);
			Serial.flush();
		}
		else if ((pcCmdRx[0] == 'I' && pcCmdRx[1] == 'F' && pcCmdRxCtr == 3) || (pcCmdRx[0] == 'I' && pcCmdRxCtr == 2))
		{
			//reply if info packet - even if it's a short I; request - no idea why WSJT-T is sending I;
			char buf[40];
			for (int i = 0; i < 40; i++)
			{
				buf[i] = 0x30; //preload with ascii 0s
			}
			buf[0] = 'I';
			buf[1] = 'F';
			CalcKenwoodFreq(sFrq);
			for (int i = 0; i < 11; i++)
			{
				buf[i + 2] = sFrq[i]; //freq
			}
			buf[28] = digitalRead(PTT_OUT) | 0x30; //convert to ascii
			buf[29] = gRMode | 0x30;
			buf[37] = ';';
			buf[38] = 0; //make sure we're terminated
			Serial.write(buf, 38);
			Serial.flush();
			//Tx2HMI("Home.bRx.txt=`" + String(buf) + "`");
		}
		pcCmdRxCtr = 0; //reset for next command
	}
	delay(5);
	goto ChkAgn; //see if there's any more coming in
}



