// =====================================================================================================================================================================================================
// (c) 2021 Lynn Hansen, KU7Q															                                                                                                               |
// This Source Code Form is subject to the terms of the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007. A copy of this license can be found here: https://choosealicense.com/licenses/gpl-3.0/|
// =====================================================================================================================================================================================================


//===================================================================================================================
// SD Audio Record/Playback routines
//===================================================================================================================


void SD_StartRecording()
{
	//save TxMsg #x to .raw file
	if (playSdWav.isPlaying())
	{
		return;
	}
	String temp = "";
	if (gShareDB == false)
	{
		temp = String((gRadioSel + 1), HEX) + "-"; //add selected radio to file name
	}
	String fileName = "/TXMEM/VMSG" + temp + String(gAudioVMsg) + ".wav";

	char fName[25];
	fileName.toCharArray(fName, fileName.length() + 1);
	if (SD.exists(fName))
	{
		SD.remove(fName);
		delay(1000);
	}
	Tx2HMI("Audio.tStat.txt=`Recording " + String(fName) + "`");
	Tx2HMI("Audio.tStat.txt=`Recording " + String(fName) + "`");
	SerialOut("Recording " + String(fName), true);
	myFile = SD.open(fName, FILE_WRITE);
	
	gAudioMode = AUDIO_RECORD;
	SetTxPath();
	if (myFile)
	{		
		if (gAudioRecSrc == AUDIO_SRC_MIC)
		{
			//record from mic			
			SetOutputSource(1, true);			
		}
		else
		{
			//record from Line-In (rx)
			SetOutputSource(0, true);	
			recBytesSaved = 0;
		}		
		Amp_Rec.gain(gAudioRecGain * .05);
		Record_Out.begin(); 
	}
	//leave it open so continue code below works
}

void SD_ContinueRecording()
{
	//called every 2 mSec while gAudioMode = AUDIO_RECORD	
ChkAgn:
	if (Record_Out.available() >= 2)
	{
		byte buffer[512];
		// Fetch 2 blocks from the audio library and copy
		// into a 512 byte buffer.  The Arduino SD library
		// is most efficient when full 512 byte sector size
		// writes are used.
		memcpy(buffer, Record_Out.readBuffer(), 256);
		Record_Out.freeBuffer();
		memcpy(buffer + 256, Record_Out.readBuffer(), 256);
		Record_Out.freeBuffer();
		// write all 512 bytes to the SD card
		//elapsedMicros usec = 0;
		myFile.write(buffer, 512);
		recBytesSaved += 512;
		// Uncomment these lines to see how long SD writes
		// are taking.  A pair of audio blocks arrives every
		// 5802 microseconds, so hopefully most of the writes
		// take well under 5802 us.  Some will take more, as
		// the SD library also must write to the FAT tables
		// and the SD card controller manages media erase and
		// wear leveling.  The Record_Out object can buffer
		// approximately 301700 us of audio, to allow time
		// for occasional high SD card latency, as long as
		// the average write time is under 5802 us.
		//SerialOut("SD write, uSec=", false);
		//SerialOut(String(usec) ,true);
		goto ChkAgn;
	}
}

void SD_StopRecording()
{
	gAudioMode = AUDIO_IDLE;
	SerialOut("stopRecording", true);
	Record_Out.end();
	while (Record_Out.available() > 0)
	{
		myFile.write((byte*)Record_Out.readBuffer(), 256);
		Record_Out.freeBuffer();
		recBytesSaved += 256;
	}
	WriteOutWavHeader(); //CONVERT TO .WAV 
	myFile.close();
	SetOutputSource(0, true);
	Tx2HMI("Audio.tStat.txt=`Recording completed`");
	blockISR = false;
}

void WriteOutWavHeader() 
{ 
	//This code writes a .wav header to the file 
	// update WAV header with final filesize/datasize
	//Adapted from code provided by Jarvus Chen - https://gist.github.com/JarvusChen/fb641cad18eca4988a9e83a9ce65f42f	
	
	
	byte byte1, byte2, byte3, byte4;		
	
	uint32_t chunkSize = recBytesSaved + 36;
	uint32_t subChunk1Size = 16;
	uint16_t audioFormat = 1;
	uint16_t numChannels = 1;
	uint32_t sampleRate = 44100;
	uint16_t bitsPerSample = 16;
	uint32_t byteRate = sampleRate * numChannels * (bitsPerSample / 8);
	uint16_t blockAlign = numChannels * (bitsPerSample / 8);


	myFile.seek(0);
	myFile.write("RIFF");
	byte1 = chunkSize & 0xff;
	byte2 = (chunkSize >> 8) & 0xff;
	byte3 = (chunkSize >> 16) & 0xff;
	byte4 = (chunkSize >> 24) & 0xff;
	myFile.write(byte1);
	myFile.write(byte2);
	myFile.write(byte3); 
	myFile.write(byte4);
	myFile.write("WAVE");
	myFile.write("fmt ");

	byte1 = subChunk1Size & 0xff;
	byte2 = (subChunk1Size >> 8) & 0xff;
	byte3 = (subChunk1Size >> 16) & 0xff;
	byte4 = (subChunk1Size >> 24) & 0xff;
	myFile.write(byte1);
	myFile.write(byte2);
	myFile.write(byte3);
	myFile.write(byte4);
	byte1 = audioFormat & 0xff; 
	byte2 = (audioFormat >> 8) & 0xff;
	myFile.write(byte1);
	myFile.write(byte2);	
	byte1 = numChannels & 0xff; 
	byte2 = (numChannels >>8) & 0xff;
	myFile.write(byte1);  
	myFile.write(byte2);	
	byte1 = sampleRate & 0xff;
	byte2 = (sampleRate >> 8) & 0xff;
	byte3 = (sampleRate >> 16) & 0xff;
	byte4 = (sampleRate >> 24) & 0xff;
	myFile.write(byte1);  
	myFile.write(byte2); 
	myFile.write(byte3);
	myFile.write(byte4);
	byte1 = byteRate & 0xff;
	byte2 = (byteRate >> 8) & 0xff;
	byte3 = (byteRate >> 16) & 0xff;
	byte4 = (byteRate >> 24) & 0xff;
	myFile.write(byte1); 
	myFile.write(byte2); 
	myFile.write(byte3);  
	myFile.write(byte4);
	byte1 = blockAlign & 0xff;
	byte2 = (blockAlign >> 8) & 0xff;
	myFile.write(byte1);  
	myFile.write(byte2);
	byte1 = bitsPerSample & 0xff;
	byte2 = (bitsPerSample >> 8) & 0xff;
	myFile.write(byte1);  
	myFile.write(byte2);
	myFile.write("data");
	byte1 = recBytesSaved & 0xff;
	byte2 = (recBytesSaved >> 8) & 0xff;
	byte3 = (recBytesSaved >> 16) & 0xff;
	byte4 = (recBytesSaved >> 24) & 0xff;
	myFile.write(byte1);  
	myFile.write(byte2); 
	myFile.write(byte3); 
	myFile.write(byte4);	
	Serial.println("===> Header written");
	Serial.print("recBytesSaved: ");
	Serial.println(recBytesSaved);
	
}


void SD_StartPlaying(String fileName)
{	
	if (playSdWav.isPlaying())
	{
		return;
	}	
	char fName[25];
	fileName.toCharArray(fName, fileName.length() + 1);
	if (!SD.exists(fName))
	{
		if (hmiPage == HMI_HOME)
		{
			Tx2HMI("bRx.txt=`Audio File" + String(fName) + " not found`");
			Tx2HMI("bRx.txt=`Audio File" + String(fName) + " not found`");
		}
		else
		{
			Tx2HMI("Audio.tStat.txt=`" + String(fName) + " Does Not Exist!`");
			Tx2HMI("Audio.tStat.txt=`" + String(fName) + " Does Not Exist!`");
			Tx2HMI("Audio.btStart.val=0"); //turn off start btn
			Tx2HMI("Audio.btStart.val=0");
		}
		return;
	}
	else if (hmiPage == HMI_AUDIO)
	{
		Tx2HMI("Audio.tStat.txt=`Playing " + String(fName) + "`");
		Tx2HMI("Audio.tStat.txt=`Playing " + String(fName) + "`");
	}	
	blockISR = true; //while we're playing
	gAudioMode = AUDIO_PLAYBACK;
	Mixer_Tx.gain(0, LEV_OFF);
	Mixer_Tx.gain(1, LEV_OFF);
	Mixer_Tx.gain(2, LEV_OFF);
	Mixer_Tx.gain(3, LEV_MIXER_TX3); //turn on playSdWav path thorugh Mixer_Tx	and Output_Source	
	Output_Source.gain(0, LEV_OFF);
	Output_Source.gain(1, LEV_OFF);	
	Output_Source.gain(2, LEV_OUT_SRC2); //no filters
	Output_Source.gain(3, LEV_OFF);
	SerialOut("Playing..." + String(fName), true);
	AudioNoInterrupts();
	playSdWav.play(fName);		
	AudioInterrupts();
}


//no need to do this while monitoring HMI_Audio - it plays itself
/*
void SD_ContinuePlaying()

{
	if (!playSdWav.isPlaying())
	{
		playSdWav.stop();
		Mixer_Tx.gain(3, LEV_OFF);
		Output_Source.gain(2, LEV_OFF);
		gAudioMode = AUDIO_IDLE;
		SerialOut("endPlaying", true);
		SetOutputSource(0xff); //restore path
	}
}
*/

void SD_StopPlaying()
{
	SerialOut("stopPlaying", true);

	if (playSdWav.isPlaying())
	{
		playSdWav.stop();
	}
	gAudioMode = AUDIO_IDLE;
	hmi_bTx = char(0xff); //clear tx buffer label	
	SetTxPath();
	SetOutputSource(0xff, true); //restore path
	Tx2HMI("Audio.tStat.txt=`Playback completed`");
	blockISR = false;
}

