// =====================================================================================================================================================================================================
// (c) 2021 Lynn Hansen, KU7Q															                                                                                                               |
// This Source Code Form is subject to the terms of the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007. A copy of this license can be found here: https://choosealicense.com/licenses/gpl-3.0/|
// =====================================================================================================================================================================================================



//===================================================================================================================
// SD Voice routines to play voice announcements
//===================================================================================================================


bool ChkVoicePath()
{
	//make sure the voice folder is present
	char path[8] = { '/','V','O','I','C','E','/',0 };
	if (!SD.exists(path))
	{
		//files not installed 
		gVocal = false;
		hmiAnnounce = VOICE_SAY_None;
		Tx2HMI("gVocal=0");
		Tx2HMI("gVocal=0");
		blockHMI = millis() + 1000; //block hmi updates for 1 sec
		return false;
	}
	return true;
}

void Say_Freq()
{
	//say gFreqRadio
	if (!ChkVoicePath())
	{
		return;
	}

	bool started = false; //goes true when we announce the first digit
	uint8_t ptr = 2; //start at sFrq[2] - 100s digit
	uint16_t temp = 0;
	char sFrq[12] = { '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 0x00 }; //put frq digits here
	CalcKenwoodFreq(sFrq); //returns with ascii frq digit in sFrq[]
	//100s digit (100 mhz)
	if (sFrq[ptr] != '0')
	{
		temp = (sFrq[ptr] & 0x0f) * 100; //mask off 0x30
		Say_Digit(temp);
		started = true;
	}
	//10s digit (10 mhz)
	ptr++;
	if (sFrq[ptr] != '0' || started == true)
	{
		temp = (sFrq[ptr] & 0x0f) * 10;
		if (temp > 10)
		{
			//say 20, 30, etc
			Say_Digit(temp);
		}
		else
		{
			ptr++; //got to units digit
			if (temp > 0)
			{
				//say 10, 11, 12, -- 19				
				temp = 10 + (sFrq[ptr] & 0x0f);
			}
			else
			{
				//say 0 to 9				
				temp = sFrq[ptr] & 0x0f;
			}
			Say_Digit(temp);
			started = true;
			goto SayPt1; //jump to say 'point'
		}
	}
	ptr++;
	//1s digit (1 mhz)
	if (sFrq[ptr] != '0' || started == true)
	{
		temp = (sFrq[ptr] & 0x0f);
		if ((temp > 0 && started == false) || started == true)
		{
			Say_Digit(temp);
			started = true;
		}
	}

SayPt1:
	Say_Digit(0xffff); //say 'point'

	//100k digit
	ptr++;
	/* uncomment this to say 100k digit as hundreds
	if (sFrq[ptr] != '0')
	{
		temp = (sFrq[ptr] & 0x0f) * 100; //mask off 0x30
	}
	else
	{
		temp = 0;
	}

	Say_Digit(temp);
	if (temp != 0 && sFrq[ptr + 1] == '0' && sFrq[ptr + 2] == '0')
	{
		//we said the 100k hundreds digit, skip 10k and 1k digits if they're 0
		ptr++; //skip these digits
		ptr++;
		goto SayPt2;
	}
	*/
	// or use this to just say the digit
	temp = sFrq[ptr] & 0x0f;
	Say_Digit(temp);


	//10k digit		
	ptr++;

	//skip the rest if all zeros
	if (sFrq[ptr] == '0' && sFrq[ptr + 1] == '0' && sFrq[ptr + 2] == '0' && sFrq[ptr + 3] == '0' && sFrq[ptr + 4] == '0')
	{
		return;
	}

	/* uncomment this to say tens of digit
	temp = (sFrq[ptr] & 0x0f) * 10;
	if (temp > 10)
	{
		//say 20, 30, etc
		Say_Digit(temp);
	}
	else
	{
		if (temp == 0 && sFrq[ptr - 1] == '0')
		{
			//only say 0 if 100k digit = 0
			Say_Digit(0);
		}
		ptr++; //got to units digit
		if (temp > 0)
		{
			//say 10, 11, 12, -- 19
			temp = 10 + (sFrq[ptr] & 0x0f);
		}
		else
		{
			//say 0 to 9
			temp = sFrq[ptr] & 0x0f;
		}
		Say_Digit(temp);
		goto SayPt2; //jump to say 'point'
	}
	*/
	// this just says 10s digit
	temp = (sFrq[ptr] & 0x0f);
	Say_Digit(temp);

	//1k digit
	ptr++;
	//skip the rest if all zeros
	if (sFrq[ptr] == '0' && sFrq[ptr + 1] == '0' && sFrq[ptr + 2] == '0' && sFrq[ptr + 3] == '0')
	{
		return;
	}

	temp = sFrq[ptr] & 0x0f;
	//uncomment this if saying the tens of digit
	//if (temp != 0)
	//{
	Say_Digit(temp);
	//}

//SayPt2:

	//100s digit
	ptr++;
	//skip the rest if all zeros
	if (sFrq[ptr] == '0' && sFrq[ptr + 1] == '0' && sFrq[ptr + 2] == '0')
	{
		return;
	}

	Say_Digit(0xffff); //say 'point'

	temp = (sFrq[ptr] & 0x0f);
	Say_Digit(temp);

	//10s digit
	ptr++;
	//skip the rest if all zeros
	if (sFrq[ptr] == '0' && sFrq[ptr + 1] == '0')
	{
		return;
	}
	temp = sFrq[ptr] & 0x0f;
	Say_Digit(temp);

	//1s digit
	ptr++;
	temp = sFrq[ptr] & 0x0f;
	if (temp != 0)
	{
		Say_Digit(temp);
	}
}

void Say_Digit(uint16_t digit)
{
	//say digit sent by Say_Freq()
	if (digit != 0xffff)
	{
		SD_StartPlaying("/VOICE/V" + String(digit) + ".wav");
	}
	else
	{
		SD_StartPlaying("/VOICE/VPNT.wav");
	}

	uint32_t waitTmr = millis();
	while (playSdWav.isPlaying())
	{
		if (5000ul < millis() - waitTmr)
		{
			//5 second failsafe
			SD_StopPlaying();
			break;
		}
	}

}

void Say_gRMode()
{
	//opens radio mode voice file and plays it - based on gRMode
	if (!ChkVoicePath())
	{
		return;
	}
	SD_StartPlaying("/VOICE/" + Dec_gRMode() + ".wav");	
	uint32_t waitTmr = millis();
	while (playSdWav.isPlaying())
	{
		if (5000ul < millis() - waitTmr)
		{
			//5 second failsafe
			SD_StopPlaying();
			break;
		}
	}

}

void Say_gOMode()
{
	//say op mode - don't use Dec_gOMode() - not the same as file names
	if (!ChkVoicePath())
	{
		return;
	}
	String temp = "CW"; //just use CW 
	switch (gOMode)
	{
	case 1:
		temp = "VOICEOP";
		break;
	case 2:
		temp = "RTTYOP";
		break;
	case 3:
		temp = "DIGOP";
		break;
	case 4:
		temp = "BEACONOP";
		break;
	}

	SD_StartPlaying("/VOICE/" + temp + ".wav");
	uint32_t waitTmr = millis();
	while (playSdWav.isPlaying())
	{
		if (5000ul < millis() - waitTmr)
		{
			//5 second failsafe
			SD_StopPlaying();
			break;
		}
	}

}

