# bandpass_response.m
# copyright 2022 TechDev LLC
# Author Steve Geers, KA8BUW
#
#{
 This script computes frequency response of a 65 tap the bandpass 
 fir filter and graphs the response and outputs the data to a text file. It 
 calculates the FFT of the filter coefficients.
 When running this file, change the working diretory to the directroy of this
 file to get the data file to save in the directory withn this file. 
#}

clear all;
pkg load signal;

clf;
f1 = 1000;
f2 = 2400;
delta_f = f2-f1;
Fs = 12000;
dB  = 40;
N = dB*Fs/(22*delta_f);
f =  [f1 ]/(Fs/2);


#65 tap fir filter coefficients
hc = [
0.00030100000,...
0.00043600000,...
0.00048200000,...
0.00035700000,...
0.00000000000,...
-0.00060000000,...
-0.00138200000,...
-0.00220700000,...
-0.00287200000,...
-0.00314300000,...
-0.00281300000,...
-0.00175900000,...
0.00000000000,...
0.00227700000,...
0.00471900000,...
0.00685800000,...
0.00819000000,...
0.00828700000,...
0.00689600000,...
0.00403000000,...
0.00000000000,...
-0.00460800000,...
-0.00902000000,...
-0.01241100000,...
-0.01406400000,...
-0.01352700000,...
-0.01071800000,...
-0.00597200000,...
0.00000000000,...
0.00622900000,...
0.01166200000,...
0.01535800000,...
0.01666700000,...
0.01535800000,...
0.01166200000,...
0.00622900000,...
0.00000000000,...
-0.00597200000,...
-0.01071800000,...
-0.01352700000,...
-0.01406400000,...
-0.01241100000,...
-0.00902000000,...
-0.00460800000,...
0.00000000000,...
0.00403000000,...
0.00689600000,...
0.00828700000,...
0.00819000000,...
0.00685800000,...
0.00471900000,...
0.00227700000,...
0.00000000000,...
-0.00175900000,...
-0.00281300000,...
-0.00314300000,...
-0.00287200000,...
-0.00220700000,...
-0.00138200000,...
-0.00060000000,...
0.00000000000,...
0.00035700000,...
0.00048200000,...
0.00043600000,...
0.000301,...
];


# create magnitude array using fftsift to reqseunce the values
M = 20*log10(abs(fftshift(fft(hc,4096))));

#the frequency response runs from -Fs/2 to FS/2
plot((-0.5:1/4096:0.5-1/4096)*Fs,M);
axis([0 6000 -100 0]);
title('Bandpass Response');
xlabel ("Frequency (Hz)");
ylabel ("Magnitiude (dB)");
grid on;

#calculate magnitude in dB
M = 20*log10(abs(fft(hc,4096)));
filename = "bandpass_out.txt";

#the data file will be saved in the default path
fid = fopen (filename, "w");
fprintf(fid, "Frequency,Magnitude\r\n");
fprintf(fid, "Hz,dB\r\n");
for i = 1:2048
  # output frquency and magnitude in dB
  fprintf(fid, "%f,%f\r\n",(i-1)*6000/2048 ,M(i) );
endfor
fclose (fid);

