#highpass_response.m
#copyright 2022 TechDev LLC
# Author Steve Geers, KA8BUW
#{
  This script computes  frequency response of the iir jighpass filter
 When running this file, change the working diretory to the directroy of this
 file to get the data file to save in the directory withn this file. 
#}

clear all;

pkg load signal
#set the sample rate
Fs = 12000;

#set the filter coefficients
B = [1, -1]; # Numerator
A = [1,-.99]; #Denominator

# Compute its frequency response
[H,w] = freqz(B,A,1024, Fs);

#calculate Magnitude in dB        
M= 20* log10(abs(H));

# Plot the frequency response
figure(1);
#semilogx(w,M,'-k');
semilogx(w,M);
grid;
title('Highpass Response');
ylabel('Magnitude IdB)');
xlabel('Frequency (Hz)');

filename = "highpass_out.txt";

#the data file will be saved in the default path
fid = fopen (filename, "w");
fprintf(fid, "Frequency,Magnitude\r\n");
fprintf(fid, "Hz,dB\r\n");
for i = 1:1024
  # output frquency and magnitude in dB
  fprintf(fid, "%f,%f\r\n",w(i) ,M(i) );
endfor
fclose (fid);

w