/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file    stm32f3xx_it.c
  * @brief   Interrupt Service Routines.
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2022 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* USER CODE END Header */

/* Includes ------------------------------------------------------------------*/
#include "main.h"
#include "stm32f3xx_it.h"
/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN TD */

/* USER CODE END TD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */

/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */

/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/
/* USER CODE BEGIN PV */
uint16_t dac_data = 0;
extern DAC_HandleTypeDef hdac1;
extern ADC_HandleTypeDef hadc1;

//variables for highpass filter
int32_t w = 0;
int32_t wn = 0;

//fir filter bandpass coefficients
const int32_t tap0 = 10;
const int32_t tap1 = 14;
const int32_t tap2 = 16;
const int32_t tap3 = 12;
const int32_t tap4 = 0;
const int32_t tap5 = -20;
const int32_t tap6 = -45;
const int32_t tap7 = -72;
const int32_t tap8 = -94;
const int32_t tap9 = -103;
const int32_t tap10 = -92;
const int32_t tap11 = -58;
const int32_t tap12 = 0;
const int32_t tap13 = 75;
const int32_t tap14 = 155;
const int32_t tap15 = 225;
const int32_t tap16 = 268;
const int32_t tap17 = 272;
const int32_t tap18 = 226;
const int32_t tap19 = 132;
const int32_t tap20 = 0;
const int32_t tap21 = -151;
const int32_t tap22 = -296;
const int32_t tap23 = -407;
const int32_t tap24 = -461;
const int32_t tap25 = -443;
const int32_t tap26 = -351;
const int32_t tap27 = -196;
const int32_t tap28 = 0;
const int32_t tap29 = 204;
const int32_t tap30 = 382;
const int32_t tap31 = 503;
const int32_t tap32 = 546;
const int32_t tap33 = 503;
const int32_t tap34 = 382;
const int32_t tap35 = 204;
const int32_t tap36 = 0;
const int32_t tap37 = -196;
const int32_t tap38 = -351;
const int32_t tap39 = -443;
const int32_t tap40 = -461;
const int32_t tap41 = -407;
const int32_t tap42 = -296;
const int32_t tap43 = -151;
const int32_t tap44 = 0;
const int32_t tap45 = 132;
const int32_t tap46 = 226;
const int32_t tap47 = 272;
const int32_t tap48 = 268;
const int32_t tap49 = 225;
const int32_t tap50 = 155;
const int32_t tap51 = 75;
const int32_t tap52 = 0;
const int32_t tap53 = -58;
const int32_t tap54 = -92;
const int32_t tap55 = -103;
const int32_t tap56 = -94;
const int32_t tap57 = -72;
const int32_t tap58 = -45;
const int32_t tap59 = -20;
const int32_t tap60 = 0;
const int32_t tap61 = 12;
const int32_t tap62 = 16;
const int32_t tap63 = 14;
const int32_t tap64 = 10;



// delay taps for fir bandpass  filter
int32_t r0 = 0;
int32_t r1 = 0;
int32_t r2 = 0;
int32_t r3 = 0;
int32_t r4 = 0;
int32_t r5 = 0;
int32_t r6 = 0;
int32_t r7 = 0;
int32_t r8 = 0;
int32_t r9 = 0;
int32_t r10 = 0;
int32_t r11 = 0;
int32_t r12 = 0;
int32_t r13 = 0;
int32_t r14 = 0;
int32_t r15 = 0;
int32_t r16 = 0;
int32_t r17 = 0;
int32_t r18 = 0;
int32_t r19 = 0;
int32_t r20 = 0;
int32_t r21 = 0;
int32_t r22 = 0;
int32_t r23 = 0;
int32_t r24 = 0;
int32_t r25 = 0;
int32_t r26 = 0;
int32_t r27 = 0;
int32_t r28 = 0;
int32_t r29 = 0;
int32_t r30 = 0;
int32_t r31 = 0;
int32_t r32 = 0;
int32_t r33 = 0;
int32_t r34 = 0;
int32_t r35 = 0;
int32_t r36 = 0;
int32_t r37 = 0;
int32_t r38 = 0;
int32_t r39 = 0;
int32_t r40 = 0;
int32_t r41 = 0;
int32_t r42 = 0;
int32_t r43 = 0;
int32_t r44 = 0;
int32_t r45 = 0;
int32_t r46 = 0;
int32_t r47 = 0;
int32_t r48 = 0;
int32_t r49 = 0;
int32_t r50 = 0;
int32_t r51 = 0;
int32_t r52 = 0;
int32_t r53 = 0;
int32_t r54 = 0;
int32_t r55 = 0;
int32_t r56 = 0;
int32_t r57 = 0;
int32_t r58 = 0;
int32_t r59 = 0;
int32_t r60 = 0;
int32_t r61 = 0;
int32_t r62 = 0;
int32_t r63 = 0;
int32_t r64 = 0;

/* USER CODE END PV */

/* Private function prototypes -----------------------------------------------*/
/* USER CODE BEGIN PFP */

/* USER CODE END PFP */

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */

/* USER CODE END 0 */

/* External variables --------------------------------------------------------*/
extern TIM_HandleTypeDef htim3;
/* USER CODE BEGIN EV */

/* USER CODE END EV */

/******************************************************************************/
/*           Cortex-M4 Processor Interruption and Exception Handlers          */
/******************************************************************************/
/**
  * @brief This function handles Non maskable interrupt.
  */
void NMI_Handler(void)
{
  /* USER CODE BEGIN NonMaskableInt_IRQn 0 */

  /* USER CODE END NonMaskableInt_IRQn 0 */
  /* USER CODE BEGIN NonMaskableInt_IRQn 1 */
  while (1)
  {
  }
  /* USER CODE END NonMaskableInt_IRQn 1 */
}

/**
  * @brief This function handles Hard fault interrupt.
  */
void HardFault_Handler(void)
{
  /* USER CODE BEGIN HardFault_IRQn 0 */

  /* USER CODE END HardFault_IRQn 0 */
  while (1)
  {
    /* USER CODE BEGIN W1_HardFault_IRQn 0 */
    /* USER CODE END W1_HardFault_IRQn 0 */
  }
}

/**
  * @brief This function handles Memory management fault.
  */
void MemManage_Handler(void)
{
  /* USER CODE BEGIN MemoryManagement_IRQn 0 */

  /* USER CODE END MemoryManagement_IRQn 0 */
  while (1)
  {
    /* USER CODE BEGIN W1_MemoryManagement_IRQn 0 */
    /* USER CODE END W1_MemoryManagement_IRQn 0 */
  }
}

/**
  * @brief This function handles Pre-fetch fault, memory access fault.
  */
void BusFault_Handler(void)
{
  /* USER CODE BEGIN BusFault_IRQn 0 */

  /* USER CODE END BusFault_IRQn 0 */
  while (1)
  {
    /* USER CODE BEGIN W1_BusFault_IRQn 0 */
    /* USER CODE END W1_BusFault_IRQn 0 */
  }
}

/**
  * @brief This function handles Undefined instruction or illegal state.
  */
void UsageFault_Handler(void)
{
  /* USER CODE BEGIN UsageFault_IRQn 0 */

  /* USER CODE END UsageFault_IRQn 0 */
  while (1)
  {
    /* USER CODE BEGIN W1_UsageFault_IRQn 0 */
    /* USER CODE END W1_UsageFault_IRQn 0 */
  }
}

/**
  * @brief This function handles System service call via SWI instruction.
  */
void SVC_Handler(void)
{
  /* USER CODE BEGIN SVCall_IRQn 0 */

  /* USER CODE END SVCall_IRQn 0 */
  /* USER CODE BEGIN SVCall_IRQn 1 */

  /* USER CODE END SVCall_IRQn 1 */
}

/**
  * @brief This function handles Debug monitor.
  */
void DebugMon_Handler(void)
{
  /* USER CODE BEGIN DebugMonitor_IRQn 0 */

  /* USER CODE END DebugMonitor_IRQn 0 */
  /* USER CODE BEGIN DebugMonitor_IRQn 1 */

  /* USER CODE END DebugMonitor_IRQn 1 */
}

/**
  * @brief This function handles Pendable request for system service.
  */
void PendSV_Handler(void)
{
  /* USER CODE BEGIN PendSV_IRQn 0 */

  /* USER CODE END PendSV_IRQn 0 */
  /* USER CODE BEGIN PendSV_IRQn 1 */

  /* USER CODE END PendSV_IRQn 1 */
}

/**
  * @brief This function handles System tick timer.
  */
void SysTick_Handler(void)
{
  /* USER CODE BEGIN SysTick_IRQn 0 */

  /* USER CODE END SysTick_IRQn 0 */
  HAL_IncTick();
  /* USER CODE BEGIN SysTick_IRQn 1 */

  /* USER CODE END SysTick_IRQn 1 */
}

/******************************************************************************/
/* STM32F3xx Peripheral Interrupt Handlers                                    */
/* Add here the Interrupt Handlers for the used peripherals.                  */
/* For the available peripheral interrupt handler names,                      */
/* please refer to the startup file (startup_stm32f3xx.s).                    */
/******************************************************************************/

/**
  * @brief This function handles TIM3 global interrupt.
  */
void TIM3_IRQHandler(void)
{
  /* USER CODE BEGIN TIM3_IRQn 0 */
    int32_t sum;
    int32_t y;

	// toggle debug GPIO high to mark the start of DSP function
    GPIOC->BSRR = (uint32_t)GPIO_PIN_0;

    __HAL_TIM_CLEAR_IT(&htim3, TIM_IT_CC3);


    // Start ADC Conversion
    HAL_ADC_Start(&hadc1);
   // Read The ADC Conversion Result & Map It To PWM DutyCycle
    dac_data = HAL_ADC_GetValue(&hadc1);

    //remove DC using IIR implementation
    w = ((uint32_t) dac_data) * 100LL + wn * 99LL;
    w = w /100LL;
    y = w -wn;
    wn = w;

    //Bandpass FIR filer calculation
    r0 = y;

    sum = 0;
    sum = r0 * tap0;
    sum = sum + r1 * tap1;
    sum = sum + r2 * tap2;
    sum = sum + r3 * tap3;
    sum = sum + r4 * tap4;
    sum = sum + r5 * tap5;
    sum = sum + r6 * tap6;
    sum = sum + r7 * tap7;
    sum = sum + r8 * tap8;
    sum = sum + r9 * tap9;
    sum = sum + r10 * tap10;
    sum = sum + r11 * tap11;
    sum = sum + r12 * tap12;
    sum = sum + r13 * tap13;
    sum = sum + r14 * tap14;
    sum = sum + r15 * tap15;
    sum = sum + r16 * tap16;
    sum = sum + r17 * tap17;
    sum = sum + r18 * tap18;
    sum = sum + r19 * tap19;
    sum = sum + r20 * tap20;
    sum = sum + r21 * tap21;
    sum = sum + r22 * tap22;
    sum = sum + r23 * tap23;
    sum = sum + r24 * tap24;
    sum = sum + r25 * tap25;
    sum = sum + r26 * tap26;
    sum = sum + r27 * tap27;
    sum = sum + r28 * tap28;
    sum = sum + r29 * tap29;
    sum = sum + r30 * tap30;
    sum = sum + r31 * tap31;
    sum = sum + r32 * tap32;
    sum = sum + r33 * tap33;
    sum = sum + r34 * tap34;
    sum = sum + r35 * tap35;
    sum = sum + r36 * tap36;
    sum = sum + r37 * tap37;
    sum = sum + r38 * tap38;
    sum = sum + r39 * tap39;
    sum = sum + r40 * tap40;
    sum = sum + r41 * tap41;
    sum = sum + r42 * tap42;
    sum = sum + r43 * tap43;
    sum = sum + r44 * tap44;
    sum = sum + r45 * tap45;
    sum = sum + r46 * tap46;
    sum = sum + r47 * tap47;
    sum = sum + r48 * tap48;
    sum = sum + r49 * tap49;
    sum = sum + r50 * tap50;
    sum = sum + r51 * tap51;
    sum = sum + r52 * tap52;
    sum = sum + r53 * tap53;
    sum = sum + r54 * tap54;
    sum = sum + r55 * tap55;
    sum = sum + r56 * tap56;
    sum = sum + r57 * tap57;
    sum = sum + r58 * tap58;
    sum = sum + r59 * tap59;
    sum = sum + r60 * tap60;
    sum = sum + r61 * tap61;
    sum = sum + r62 * tap62;
    sum = sum + r63 * tap63;
    sum = sum + r64 * tap64;

    // scale for 16 bits.
    //filter coefficients were -1 to +1
    //So, als0 dived by 2.

    sum = sum / 0x8000;

    //shift all samples by 1 step.
    r64 = r63;
    r63 = r62;
    r62 = r61;
    r61 = r60;
    r60 = r59;
    r59 = r58;
    r58 = r57;
    r57 = r56;
    r56 = r55;
    r55 = r54;
    r54 = r53;
    r53 = r52;
    r52 = r51;
    r51 = r50;
    r50 = r49;
    r49 = r48;
    r48 = r47;
    r47 = r46;
    r46 = r45;
    r45 = r44;
    r44 = r43;
    r43 = r42;
    r42 = r41;
    r41 = r40;
    r40 = r39;
    r39 = r38;
    r38 = r37;
    r37 = r36;
    r36 = r35;
    r35 = r34;
    r34 = r33;
    r33 = r32;
    r32 = r31;
    r31 = r30;
    r30 = r29;
    r29 = r28;
    r28 = r27;
    r27 = r26;
    r26 = r25;
    r25 = r24;
    r24 = r23;
    r23 = r22;
    r22 = r21;
    r21 = r20;
    r20 = r19;
    r19 = r18;
    r18 = r17;
    r17 = r16;
    r16 = r15;
    r15 = r14;
    r14 = r13;
    r13 = r12;
    r12 = r11;
    r11 = r10;
    r10 = r9;
    r9 = r8;
    r8 = r7;
    r7 = r6;
    r6 = r5;
    r5 = r4;
    r4 = r3;
    r3 = r2;
    r2 = r1;
    r1 = r0;

    //Apply DC to center in DAC
    y = sum + 2047;
    dac_data = (uint16_t ) y;

    // setup next DAC output
    htim3.Channel = HAL_TIM_ACTIVE_CHANNEL_3;
    htim3.Channel = HAL_TIM_ACTIVE_CHANNEL_CLEARED;
    HAL_DAC_SetValue ( &hdac1, DAC_CHANNEL_1, DAC_ALIGN_12B_R, dac_data);

    // toggle debug GPIO low to mark the end of DSP function
    GPIOC->BRR = (uint32_t)GPIO_PIN_0;
    return;
  /* USER CODE END TIM3_IRQn 0 */
  HAL_TIM_IRQHandler(&htim3);
  /* USER CODE BEGIN TIM3_IRQn 1 */

  // toggle debug GPIO low to mark end of routine
  GPIOC->BRR = (uint32_t)GPIO_PIN_0;

  /* USER CODE END TIM3_IRQn 1 */
}

/* USER CODE BEGIN 1 */

/* USER CODE END 1 */

